/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import java.util.AbstractList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.function.Function;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RearrangedRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumnsTestBase;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.junit.Test;

public class RearrangedRowsAndColumnsTest
extends RowsAndColumnsTestBase {
    public static Function<MapOfColumnsRowsAndColumns, RearrangedRowsAndColumns> MAKER = input -> {
        int[] pointers = new int[input.numRows()];
        for (int i = 0; i < pointers.length; ++i) {
            pointers[i] = i;
        }
        RearrangedRowsAndColumnsTest.shuffleArray(pointers);
        LinkedHashMap<String, ObjectArrayColumn> shuffledMap = new LinkedHashMap<String, ObjectArrayColumn>();
        for (String columnName : input.getColumnNames()) {
            ColumnAccessor accessor = input.findColumn(columnName).toAccessor();
            Object[] theVals = new Object[pointers.length];
            for (int i = 0; i < pointers.length; ++i) {
                theVals[pointers[i]] = accessor.getObject(i);
            }
            shuffledMap.put(columnName, new ObjectArrayColumn(theVals, accessor.getType()));
        }
        return new RearrangedRowsAndColumns(pointers, (RowsAndColumns)new MapOfColumnsRowsAndColumns(shuffledMap, pointers.length));
    };

    public RearrangedRowsAndColumnsTest() {
        super(RearrangedRowsAndColumns.class);
    }

    private static void shuffleArray(final int[] pointers) {
        Collections.shuffle(new AbstractList<Object>(){

            @Override
            public Object get(int index) {
                return pointers[index];
            }

            @Override
            public Object set(int index, Object element) {
                int retVal = pointers[index];
                pointers[index] = (Integer)element;
                return retVal;
            }

            @Override
            public int size() {
                return pointers.length;
            }
        });
    }

    @Test
    public void testSanity() {
        new RowsAndColumnsHelper().expectColumn("int", new int[]{0, 1, 2, 3, 4}).allColumnsRegistered().validate((RowsAndColumns)new RearrangedRowsAndColumns(new int[]{4, 2, 0, 3, 1}, (RowsAndColumns)MapOfColumnsRowsAndColumns.of((String)"int", (Column)new IntArrayColumn(new int[]{2, 4, 1, 3, 0}))));
    }
}

