/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Order;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.scan.ScanResultValueTimestampComparator;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ScanResultValueTimestampComparatorTest {
    private static QuerySegmentSpec intervalSpec;

    @BeforeClass
    public static void setup() {
        intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(new Interval((ReadableInstant)DateTimes.of((String)"2012-01-01"), (ReadableInstant)DateTimes.of((String)"2012-01-01").plusHours(1))));
    }

    @Test
    public void testComparisonDescendingList() {
        ScanQuery query = Druids.newScanQueryBuilder().order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).build();
        ScanResultValueTimestampComparator comparator = new ScanResultValueTimestampComparator(query);
        ArrayList events1 = new ArrayList();
        HashMap<String, Long> event1 = new HashMap<String, Long>();
        event1.put("__time", new Long(42L));
        events1.add(event1);
        ScanResultValue s1 = new ScanResultValue("segmentId", Collections.singletonList("__time"), events1);
        ArrayList events2 = new ArrayList();
        HashMap<String, Long> event2 = new HashMap<String, Long>();
        event2.put("__time", new Long(43L));
        events2.add(event2);
        ScanResultValue s2 = new ScanResultValue("segmentId", Collections.singletonList("__time"), events2);
        Assert.assertEquals((long)1L, (long)comparator.compare(s1, s2));
    }

    @Test
    public void testComparisonAscendingList() {
        ScanQuery query = Druids.newScanQueryBuilder().order(Order.ASCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).build();
        ScanResultValueTimestampComparator comparator = new ScanResultValueTimestampComparator(query);
        ArrayList events1 = new ArrayList();
        HashMap<String, Long> event1 = new HashMap<String, Long>();
        event1.put("__time", new Long(42L));
        events1.add(event1);
        ScanResultValue s1 = new ScanResultValue("segmentId", Collections.singletonList("__time"), events1);
        ArrayList events2 = new ArrayList();
        HashMap<String, Long> event2 = new HashMap<String, Long>();
        event2.put("__time", new Long(43L));
        events2.add(event2);
        ScanResultValue s2 = new ScanResultValue("segmentId", Collections.singletonList("__time"), events2);
        Assert.assertEquals((long)-1L, (long)comparator.compare(s1, s2));
    }

    @Test
    public void testComparisonDescendingCompactedList() {
        ScanQuery query = Druids.newScanQueryBuilder().order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).dataSource("some src").intervals(intervalSpec).build();
        ScanResultValueTimestampComparator comparator = new ScanResultValueTimestampComparator(query);
        ArrayList<List<Long>> events1 = new ArrayList<List<Long>>();
        List<Long> event1 = Collections.singletonList(new Long(42L));
        events1.add(event1);
        ScanResultValue s1 = new ScanResultValue("segmentId", Collections.singletonList("__time"), events1);
        ArrayList<List<Long>> events2 = new ArrayList<List<Long>>();
        List<Long> event2 = Collections.singletonList(new Long(43L));
        events2.add(event2);
        ScanResultValue s2 = new ScanResultValue("segmentId", Collections.singletonList("__time"), events2);
        Assert.assertEquals((long)1L, (long)comparator.compare(s1, s2));
    }

    @Test
    public void testAscendingCompactedList() {
        ScanQuery query = Druids.newScanQueryBuilder().order(Order.ASCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).dataSource("some src").intervals(intervalSpec).build();
        ScanResultValueTimestampComparator comparator = new ScanResultValueTimestampComparator(query);
        ArrayList<List<Long>> events1 = new ArrayList<List<Long>>();
        List<Long> event1 = Collections.singletonList(new Long(42L));
        events1.add(event1);
        ScanResultValue s1 = new ScanResultValue("segmentId", Collections.singletonList("__time"), events1);
        ArrayList<List<Long>> events2 = new ArrayList<List<Long>>();
        List<Long> event2 = Collections.singletonList(new Long(43L));
        events2.add(event2);
        ScanResultValue s2 = new ScanResultValue("segmentId", Collections.singletonList("__time"), events2);
        Assert.assertEquals((long)-1L, (long)comparator.compare(s1, s2));
    }
}

