/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.emitter.core.EventMap;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.query.DefaultQueryMetricsTest;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ListFilteredDimensionSpec;
import org.apache.druid.query.search.DefaultSearchQueryMetricsFactory;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchQueryMetrics;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.Interval;
import org.joda.time.base.AbstractInterval;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSearchQueryMetricsTest
extends InitializedNullHandlingTest {
    @Test
    public void testDefaultSearchQueryMetricsQuery() {
        StubServiceEmitter serviceEmitter = new StubServiceEmitter("", "");
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).dimensions((DimensionSpec)new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("tags", "tags"), (Set)ImmutableSet.of((Object)"t3"), null)).context((Map)ImmutableMap.of((Object)"testKey", (Object)"testValue")).build();
        SearchQueryMetrics queryMetrics = DefaultSearchQueryMetricsFactory.instance().makeMetrics(query);
        queryMetrics.query((Query)query);
        queryMetrics.reportQueryTime(0L).emit((ServiceEmitter)serviceEmitter);
        EventMap actualEvent = serviceEmitter.getEvents().get(0).toMap();
        Assert.assertEquals((long)13L, (long)actualEvent.size());
        Assert.assertTrue((boolean)actualEvent.containsKey("feed"));
        Assert.assertTrue((boolean)actualEvent.containsKey("timestamp"));
        Assert.assertEquals((Object)"", actualEvent.get("host"));
        Assert.assertEquals((Object)"", actualEvent.get("service"));
        Assert.assertEquals((Object)"testing", actualEvent.get("dataSource"));
        Assert.assertEquals((Object)query.getType(), actualEvent.get("type"));
        List expectedIntervals = QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC.getIntervals();
        List expectedStringIntervals = expectedIntervals.stream().map(AbstractInterval::toString).collect(Collectors.toList());
        Assert.assertEquals(expectedStringIntervals, actualEvent.get("interval"));
        Assert.assertEquals((Object)"false", actualEvent.get("hasFilters"));
        Assert.assertEquals((Object)((Interval)expectedIntervals.get(0)).toDuration().toString(), actualEvent.get("duration"));
        Assert.assertEquals((Object)"", actualEvent.get("id"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"testKey", (Object)"testValue"), actualEvent.get("context"));
        Assert.assertEquals((Object)"query/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)0L, actualEvent.get("value"));
        Assert.assertThrows(ISE.class, () -> queryMetrics.sqlQueryId("dummy"));
    }

    @Test
    public void testDefaultSearchQueryMetricsMetricNamesAndUnits() {
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).build();
        SearchQueryMetrics queryMetrics = DefaultSearchQueryMetricsFactory.instance().makeMetrics(query);
        DefaultQueryMetricsTest.testQueryMetricsDefaultMetricNamesAndUnits(queryMetrics);
    }
}

