/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Result;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.search.SearchBinaryFn;
import org.apache.druid.query.search.SearchHit;
import org.apache.druid.query.search.SearchResultValue;
import org.apache.druid.query.search.SearchSortSpec;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class SearchBinaryFnTest {
    private final DateTime currTime = DateTimes.nowUtc();

    private void assertSearchMergeResult(SearchResultValue o1, SearchResultValue o2) {
        Iterator i1 = o1.iterator();
        Iterator i2 = o2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            SearchHit s1 = (SearchHit)i1.next();
            SearchHit s2 = (SearchHit)i2.next();
            Assert.assertEquals((Object)s1, (Object)s2);
            Assert.assertEquals((Object)s1.getCount(), (Object)s2.getCount());
        }
        Assert.assertTrue((!i1.hasNext() && !i2.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testMerge() {
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"))));
        Result r2 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah2", "foo2"))));
        Result expected = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"), (Object)new SearchHit("blah2", "foo2"))));
        Result actual = new SearchBinaryFn(new SearchSortSpec(StringComparators.LEXICOGRAPHIC), Granularities.ALL, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult((SearchResultValue)expected.getValue(), (SearchResultValue)actual.getValue());
    }

    @Test
    public void testMergeDay() {
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"))));
        Result r2 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah2", "foo2"))));
        Result expected = new Result(Granularities.DAY.bucketStart(this.currTime), (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"), (Object)new SearchHit("blah2", "foo2"))));
        Result actual = new SearchBinaryFn(new SearchSortSpec(StringComparators.LEXICOGRAPHIC), Granularities.DAY, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult((SearchResultValue)expected.getValue(), (SearchResultValue)actual.getValue());
    }

    @Test
    public void testMergeOneResultNull() {
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"))));
        Result r2 = null;
        Result expected = r1;
        Result actual = new SearchBinaryFn(new SearchSortSpec(StringComparators.LEXICOGRAPHIC), Granularities.ALL, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult((SearchResultValue)expected.getValue(), (SearchResultValue)actual.getValue());
    }

    @Test
    public void testMergeShiftedTimestamp() {
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"))));
        Result r2 = new Result(this.currTime.plusHours(2), (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah2", "foo2"))));
        Result expected = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"), (Object)new SearchHit("blah2", "foo2"))));
        Result actual = new SearchBinaryFn(new SearchSortSpec(StringComparators.LEXICOGRAPHIC), Granularities.ALL, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult((SearchResultValue)expected.getValue(), (SearchResultValue)actual.getValue());
    }

    @Test
    public void testStrlenMerge() {
        SearchSortSpec searchSortSpec = new SearchSortSpec(StringComparators.STRLEN);
        Comparator c = searchSortSpec.getComparator();
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue(this.toHits(c, "blah:thisislong")));
        Result r2 = new Result(this.currTime, (Object)new SearchResultValue(this.toHits(c, "blah:short")));
        Result expected = new Result(this.currTime, (Object)new SearchResultValue(this.toHits(c, "blah:short", "blah:thisislong")));
        Result actual = new SearchBinaryFn(searchSortSpec, Granularities.ALL, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult((SearchResultValue)expected.getValue(), (SearchResultValue)actual.getValue());
    }

    @Test
    public void testStrlenMerge2() {
        SearchSortSpec searchSortSpec = new SearchSortSpec(StringComparators.STRLEN);
        Comparator c = searchSortSpec.getComparator();
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue(this.toHits(c, "blah:short", "blah:thisislong", "blah2:thisislong")));
        Result r2 = new Result(this.currTime, (Object)new SearchResultValue(this.toHits(c, "blah:short", "blah2:thisislong")));
        Result expected = new Result(this.currTime, (Object)new SearchResultValue(this.toHits(c, "blah:short", "blah:thisislong", "blah2:thisislong")));
        Result actual = new SearchBinaryFn(searchSortSpec, Granularities.ALL, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult((SearchResultValue)expected.getValue(), (SearchResultValue)actual.getValue());
    }

    @Test
    public void testAlphanumericMerge() {
        SearchSortSpec searchSortSpec = new SearchSortSpec(StringComparators.ALPHANUMERIC);
        Comparator c = searchSortSpec.getComparator();
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue(this.toHits(c, "blah:a100", "blah:a9", "alah:a100")));
        Result r2 = new Result(this.currTime, (Object)new SearchResultValue(this.toHits(c, "blah:b0", "alah:c3")));
        Result expected = new Result(this.currTime, (Object)new SearchResultValue(this.toHits(c, "blah:a9", "alah:a100", "blah:a100", "blah:b0", "alah:c3")));
        Result actual = new SearchBinaryFn(searchSortSpec, Granularities.ALL, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult((SearchResultValue)expected.getValue(), (SearchResultValue)actual.getValue());
    }

    private List<SearchHit> toHits(Comparator<SearchHit> comparator, String ... hits) {
        ArrayList<SearchHit> result = new ArrayList<SearchHit>();
        for (String hit : hits) {
            int colonIndex = hit.indexOf(58);
            if (colonIndex == -1) {
                throw new IAE("Invalid hit: [%s]", new Object[]{hit});
            }
            result.add(new SearchHit(hit.substring(0, colonIndex), hit.substring(colonIndex + 1)));
        }
        Collections.sort(result, comparator);
        return result;
    }

    @Test
    public void testMergeUniqueResults() {
        Result r1;
        Result r2 = r1 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"))));
        Result expected = r1;
        Result actual = new SearchBinaryFn(new SearchSortSpec(StringComparators.LEXICOGRAPHIC), Granularities.ALL, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult((SearchResultValue)expected.getValue(), (SearchResultValue)actual.getValue());
    }

    @Test
    public void testMergeLimit() {
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"))));
        Result r2 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah2", "foo2"))));
        Result expected = r1;
        Result actual = new SearchBinaryFn(new SearchSortSpec(StringComparators.LEXICOGRAPHIC), Granularities.ALL, 1).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult((SearchResultValue)expected.getValue(), (SearchResultValue)actual.getValue());
    }

    @Test
    public void testMergeCountWithNull() {
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"))));
        Result r2 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo", Integer.valueOf(3)))));
        Result expected = r1;
        Result actual = new SearchBinaryFn(new SearchSortSpec(StringComparators.LEXICOGRAPHIC), Granularities.ALL, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult((SearchResultValue)expected.getValue(), (SearchResultValue)actual.getValue());
    }
}

