/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.DefaultColumnFormatConfig;
import org.junit.Assert;
import org.junit.Test;

public class DefaultColumnFormatsConfigTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();

    @Test
    public void testDefaultsSerde() throws JsonProcessingException {
        DefaultColumnFormatConfig defaultColumnFormatConfig = new DefaultColumnFormatConfig(null, null);
        String there = MAPPER.writeValueAsString((Object)defaultColumnFormatConfig);
        DefaultColumnFormatConfig andBack = (DefaultColumnFormatConfig)MAPPER.readValue(there, DefaultColumnFormatConfig.class);
        Assert.assertEquals((Object)defaultColumnFormatConfig, (Object)andBack);
        Assert.assertNull((Object)andBack.getNestedColumnFormatVersion());
        Assert.assertNull((Object)andBack.getStringMultiValueHandlingMode());
    }

    @Test
    public void testDefaultsSerdeOverride() throws JsonProcessingException {
        DefaultColumnFormatConfig defaultColumnFormatConfig = new DefaultColumnFormatConfig(Integer.valueOf(4), "ARRAY");
        String there = MAPPER.writeValueAsString((Object)defaultColumnFormatConfig);
        DefaultColumnFormatConfig andBack = (DefaultColumnFormatConfig)MAPPER.readValue(there, DefaultColumnFormatConfig.class);
        Assert.assertEquals((Object)defaultColumnFormatConfig, (Object)andBack);
        Assert.assertEquals((long)4L, (long)andBack.getNestedColumnFormatVersion().intValue());
        Assert.assertEquals((Object)DimensionSchema.MultiValueHandling.ARRAY.toString(), (Object)andBack.getStringMultiValueHandlingMode());
    }

    @Test
    public void testEqualsAndHashcode() {
        EqualsVerifier.forClass(DefaultColumnFormatConfig.class).usingGetClass().verify();
    }
}

