/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.druid.segment.AutoTypeColumnMerger;
import org.apache.druid.segment.SimpleDictionaryMergingIterator;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.junit.Assert;
import org.junit.Test;

public class SimpleDictionaryMergingIteratorTest {
    @Test
    public void testMergingIterator() {
        Indexed[] sortedLookups = new Indexed[]{new ListIndexed(new Object[]{null, "", "null", "z"}), new ListIndexed(new Object[]{"", "a", "b", "c", "d", "e", "f", "g", "h"}), new ListIndexed(new Object[]{null, "b", "c", "null", "z"}), new ListIndexed(new Object[]{null, "hello"})};
        SimpleDictionaryMergingIterator dictionaryMergeIterator = new SimpleDictionaryMergingIterator(sortedLookups, AutoTypeColumnMerger.STRING_MERGING_COMPARATOR);
        ArrayList expectedSequence = Lists.newArrayListWithExpectedSize((int)13);
        expectedSequence.add(null);
        expectedSequence.addAll(ImmutableList.of((Object)"", (Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object)"g", (Object)"h", (Object)"hello", (Object)"null", (Object)"z", (Object[])new String[0]));
        ArrayList actualSequence = Lists.newArrayListWithExpectedSize((int)13);
        while (dictionaryMergeIterator.hasNext()) {
            actualSequence.add((String)((Object)dictionaryMergeIterator.next()));
        }
        Assert.assertEquals((Object)expectedSequence, (Object)actualSequence);
    }
}

