/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.SelectorPredicateFactory;
import org.apache.druid.segment.AutoTypeColumnIndexer;
import org.apache.druid.segment.AutoTypeColumnMerger;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.index.semantic.ValueIndexes;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedDataColumnSupplierTest;
import org.apache.druid.segment.nested.ScalarDoubleColumn;
import org.apache.druid.segment.nested.ScalarDoubleColumnAndIndexSupplier;
import org.apache.druid.segment.nested.ScalarDoubleColumnSerializer;
import org.apache.druid.segment.nested.SortedValueDictionary;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ScalarDoubleColumnSupplierTest
extends InitializedNullHandlingTest {
    private static final String NO_MATCH = "no";
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    BitmapSerdeFactory bitmapSerdeFactory = RoaringBitmapSerdeFactory.getInstance();
    DefaultBitmapResultFactory resultFactory = new DefaultBitmapResultFactory(this.bitmapSerdeFactory.getBitmapFactory());
    List<Double> data = Arrays.asList(1.0, 0.0, null, 2.0, 3.3, 9.9);
    Closer closer = Closer.create();
    SmooshedFileMapper fileMapper;
    ByteBuffer baseBuffer;

    @BeforeClass
    public static void staticSetup() {
        BuiltInTypesModule.registerHandlersAndSerde();
    }

    @Before
    public void setup() throws IOException {
        String fileNameBase = "test";
        this.fileMapper = this.smooshify("test", this.tempFolder.newFolder(), this.data);
        this.baseBuffer = this.fileMapper.mapFile("test");
    }

    private SmooshedFileMapper smooshify(String fileNameBase, File tmpFile, List<?> data) throws IOException {
        TmpFileSegmentWriteOutMediumFactory writeOutMediumFactory = TmpFileSegmentWriteOutMediumFactory.instance();
        try (FileSmoosher smoosher = new FileSmoosher(tmpFile);){
            ScalarDoubleColumnSerializer serializer = new ScalarDoubleColumnSerializer(fileNameBase, IndexSpec.DEFAULT, writeOutMediumFactory.makeSegmentWriteOutMedium(this.tempFolder.newFolder()), this.closer);
            AutoTypeColumnIndexer indexer = new AutoTypeColumnIndexer("test", null);
            for (Object o : data) {
                indexer.processRowValsToUnsortedEncodedKeyComponent(o, false);
            }
            TreeMap sortedFields = new TreeMap();
            IndexableAdapter.NestedColumnMergable mergable = (IndexableAdapter.NestedColumnMergable)this.closer.register((Closeable)new IndexableAdapter.NestedColumnMergable(indexer.getSortedValueLookups(), indexer.getFieldTypeInfo(), false, false, null));
            SortedValueDictionary globalDictionarySortedCollector = mergable.getValueDictionary();
            mergable.mergeFieldsInto(sortedFields);
            serializer.openDictionaryWriter(this.tempFolder.newFolder());
            serializer.serializeDictionaries((Iterable)globalDictionarySortedCollector.getSortedStrings(), (Iterable)globalDictionarySortedCollector.getSortedLongs(), (Iterable)globalDictionarySortedCollector.getSortedDoubles(), () -> new AutoTypeColumnMerger.ArrayDictionaryMergingIterator(new Iterable[]{globalDictionarySortedCollector.getSortedArrays()}, serializer.getDictionaryIdLookup()));
            serializer.open();
            NestedDataColumnSupplierTest.SettableSelector valueSelector = new NestedDataColumnSupplierTest.SettableSelector();
            for (Object o : data) {
                valueSelector.setObject(StructuredData.wrap(o));
                serializer.serialize((ColumnValueSelector)valueSelector);
            }
            try (SmooshedWriter writer = smoosher.addWithSmooshedWriter(fileNameBase, serializer.getSerializedSize());){
                serializer.writeTo((WritableByteChannel)writer, smoosher);
            }
            smoosher.close();
            SmooshedFileMapper smooshedFileMapper = (SmooshedFileMapper)this.closer.register((Closeable)SmooshedFileMapper.load((File)tmpFile));
            return smooshedFileMapper;
        }
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testBasicFunctionality() {
        ColumnBuilder bob = new ColumnBuilder();
        bob.setFileMapper(this.fileMapper);
        ScalarDoubleColumnAndIndexSupplier supplier = ScalarDoubleColumnAndIndexSupplier.read((ByteOrder)ByteOrder.nativeOrder(), (BitmapSerdeFactory)this.bitmapSerdeFactory, (ByteBuffer)this.baseBuffer, (ColumnBuilder)bob, (ColumnConfig)ColumnConfig.SELECTION_SIZE, null);
        try (ScalarDoubleColumn column = (ScalarDoubleColumn)supplier.get();){
            this.smokeTest(supplier, column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrency() throws ExecutionException, InterruptedException {
        ColumnBuilder bob = new ColumnBuilder();
        bob.setFileMapper(this.fileMapper);
        ScalarDoubleColumnAndIndexSupplier supplier = ScalarDoubleColumnAndIndexSupplier.read((ByteOrder)ByteOrder.nativeOrder(), (BitmapSerdeFactory)this.bitmapSerdeFactory, (ByteBuffer)this.baseBuffer, (ColumnBuilder)bob, (ColumnConfig)ColumnConfig.SELECTION_SIZE, null);
        String expectedReason = "none";
        AtomicReference<String> failureReason = new AtomicReference<String>("none");
        int threads = 10;
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)10, (String)"ScalarDoubleColumnSupplierTest-%d"));
        try {
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(10);
            CountDownLatch threadsStartLatch = new CountDownLatch(1);
            for (int i = 0; i < 10; ++i) {
                futures.add(executorService.submit(() -> {
                    try {
                        threadsStartLatch.await();
                        for (int iter = 0; iter < 5000; ++iter) {
                            try (ScalarDoubleColumn column = (ScalarDoubleColumn)supplier.get();){
                                this.smokeTest(supplier, column);
                                continue;
                            }
                        }
                    }
                    catch (Throwable ex) {
                        failureReason.set(ex.getMessage());
                    }
                }));
            }
            threadsStartLatch.countDown();
            Futures.allAsList(futures).get();
            Assert.assertEquals((Object)"none", (Object)failureReason.get());
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private void smokeTest(ScalarDoubleColumnAndIndexSupplier supplier, ScalarDoubleColumn column) {
        SimpleAscendingOffset offset = new SimpleAscendingOffset(this.data.size());
        NoFilterVectorOffset vectorOffset = new NoFilterVectorOffset(1, 0, this.data.size());
        ColumnValueSelector valueSelector = column.makeColumnValueSelector((ReadableOffset)offset);
        VectorValueSelector vectorValueSelector = column.makeVectorValueSelector((ReadableVectorOffset)vectorOffset);
        ValueIndexes valueIndexes = (ValueIndexes)supplier.as(ValueIndexes.class);
        StringValueSetIndexes valueSetIndex = (StringValueSetIndexes)supplier.as(StringValueSetIndexes.class);
        DruidPredicateIndexes predicateIndex = (DruidPredicateIndexes)supplier.as(DruidPredicateIndexes.class);
        NullValueIndex nullValueIndex = (NullValueIndex)supplier.as(NullValueIndex.class);
        SortedMap fields = column.getFieldTypeInfo();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"$", (Object)new FieldTypeInfo.MutableTypeSet().add(ColumnType.DOUBLE)), (Object)fields);
        for (int i = 0; i < this.data.size(); ++i) {
            Double row = this.data.get(i);
            if (row != null) {
                Assert.assertEquals((Object)row, (Object)valueSelector.getObject());
                Assert.assertEquals((double)row, (double)valueSelector.getDouble(), (double)0.0);
                Assert.assertFalse((boolean)valueSelector.isNull());
                Assert.assertEquals((double)row, (double)vectorValueSelector.getDoubleVector()[0], (double)0.0);
                Assert.assertEquals((long)row.longValue(), (long)vectorValueSelector.getLongVector()[0]);
                Assert.assertEquals((double)row.floatValue(), (double)vectorValueSelector.getFloatVector()[0], (double)0.0);
                boolean[] nullVector = vectorValueSelector.getNullVector();
                if (nullVector != null) {
                    Assert.assertFalse((boolean)nullVector[0]);
                } else {
                    Assert.assertNull((Object)nullVector);
                }
                Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forValue(String.valueOf(row)).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                Assert.assertTrue((boolean)((ImmutableBitmap)valueIndexes.forValue((Object)row, (TypeSignature)ColumnType.DOUBLE).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)String.valueOf(row)))).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                Assert.assertTrue((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(String.valueOf(row))).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)NO_MATCH))).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(NO_MATCH)).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)nullValueIndex.get().computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
            } else {
                Assert.assertNull((Object)valueSelector.getObject());
                Assert.assertTrue((boolean)valueSelector.isNull());
                Assert.assertTrue((boolean)vectorValueSelector.getNullVector()[0]);
                Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forValue(null).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                Assert.assertTrue((boolean)((ImmutableBitmap)nullValueIndex.get().computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                Assert.assertTrue((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(null)).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(NO_MATCH)).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
            }
            offset.increment();
            vectorOffset.advance();
        }
    }
}

