/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.ByteBuffer;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.NullColumnPartSerde;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class NullColumnPartSerdeTest
extends InitializedNullHandlingTest {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);

    @Test
    public void testSerde() throws JsonProcessingException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        NullColumnPartSerde partSerde = new NullColumnPartSerde(10, (BitmapSerdeFactory)RoaringBitmapSerdeFactory.getInstance());
        String json = mapper.writeValueAsString((Object)partSerde);
        Assert.assertEquals((Object)partSerde, (Object)mapper.readValue(json, ColumnPartSerde.class));
    }

    @Test
    public void testDeserializer() {
        NullColumnPartSerde partSerde = new NullColumnPartSerde(10, (BitmapSerdeFactory)RoaringBitmapSerdeFactory.getInstance());
        ColumnBuilder builder = new ColumnBuilder().setType(ValueType.DOUBLE);
        partSerde.getDeserializer().read(EMPTY_BUFFER, builder, ColumnConfig.DEFAULT, null);
        ColumnCapabilities columnCapabilities = builder.build().getCapabilities();
        Assert.assertTrue((boolean)Types.is((TypeSignature)columnCapabilities, (TypeDescriptor)ValueType.DOUBLE));
        Assert.assertTrue((boolean)columnCapabilities.hasNulls().isTrue());
        Assert.assertTrue((boolean)columnCapabilities.hasMultipleValues().isFalse());
        Assert.assertTrue((boolean)columnCapabilities.hasBitmapIndexes());
        Assert.assertTrue((boolean)columnCapabilities.isDictionaryEncoded().isTrue());
        Assert.assertTrue((boolean)columnCapabilities.areDictionaryValuesSorted().isTrue());
        Assert.assertTrue((boolean)columnCapabilities.areDictionaryValuesUnique().isTrue());
    }

    @Test
    public void testDimensionSelector() {
        NullColumnPartSerde partSerde = new NullColumnPartSerde(10, (BitmapSerdeFactory)RoaringBitmapSerdeFactory.getInstance());
        ColumnBuilder builder = new ColumnBuilder().setType(ValueType.STRING);
        partSerde.getDeserializer().read(EMPTY_BUFFER, builder, ColumnConfig.DEFAULT, null);
        ColumnHolder holder = builder.build();
        BaseColumn theColumn = holder.getColumn();
        Assert.assertTrue((boolean)(theColumn instanceof DictionaryEncodedColumn));
        DictionaryEncodedColumn dictionaryEncodedColumn = (DictionaryEncodedColumn)theColumn;
        SimpleAscendingOffset offset = new SimpleAscendingOffset(10);
        DimensionSelector dimensionSelector = dictionaryEncodedColumn.makeDimensionSelector((ReadableOffset)offset, null);
        Assert.assertNull((Object)dimensionSelector.getObject());
        Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
        Assert.assertEquals((long)0L, (long)dimensionSelector.getRow().get(0));
    }

    @Test
    public void testDimensionVectorSelector() {
        NullColumnPartSerde partSerde = new NullColumnPartSerde(10, (BitmapSerdeFactory)RoaringBitmapSerdeFactory.getInstance());
        ColumnBuilder builder = new ColumnBuilder().setType(ValueType.STRING);
        partSerde.getDeserializer().read(EMPTY_BUFFER, builder, ColumnConfig.DEFAULT, null);
        ColumnHolder holder = builder.build();
        BaseColumn theColumn = holder.getColumn();
        Assert.assertTrue((boolean)(theColumn instanceof DictionaryEncodedColumn));
        DictionaryEncodedColumn dictionaryEncodedColumn = (DictionaryEncodedColumn)theColumn;
        NoFilterVectorOffset vectorOffset = new NoFilterVectorOffset(8, 0, 10);
        SingleValueDimensionVectorSelector vectorSelector = dictionaryEncodedColumn.makeSingleValueDimensionVectorSelector((ReadableVectorOffset)vectorOffset);
        int[] rowVector = vectorSelector.getRowVector();
        for (int i = 0; i < vectorOffset.getCurrentVectorSize(); ++i) {
            Assert.assertEquals((long)0L, (long)rowVector[i]);
            Assert.assertNull((Object)vectorSelector.lookupName(rowVector[i]));
        }
        Assert.assertThrows(UnsupportedOperationException.class, () -> NullColumnPartSerdeTest.lambda$testDimensionVectorSelector$0(dictionaryEncodedColumn, (ReadableVectorOffset)vectorOffset));
    }

    @Test
    public void testVectorObjectSelector() {
        NullColumnPartSerde partSerde = new NullColumnPartSerde(10, (BitmapSerdeFactory)RoaringBitmapSerdeFactory.getInstance());
        ColumnBuilder builder = new ColumnBuilder().setType(ValueType.STRING);
        partSerde.getDeserializer().read(EMPTY_BUFFER, builder, ColumnConfig.DEFAULT, null);
        ColumnHolder holder = builder.build();
        BaseColumn theColumn = holder.getColumn();
        NoFilterVectorOffset vectorOffset = new NoFilterVectorOffset(8, 0, 10);
        VectorObjectSelector objectSelector = theColumn.makeVectorObjectSelector((ReadableVectorOffset)vectorOffset);
        Object[] vector = objectSelector.getObjectVector();
        for (int i = 0; i < vectorOffset.getCurrentVectorSize(); ++i) {
            Assert.assertNull((Object)vector[i]);
        }
    }

    @Test
    public void testColumnValueSelector() {
        NullColumnPartSerde partSerde = new NullColumnPartSerde(10, (BitmapSerdeFactory)RoaringBitmapSerdeFactory.getInstance());
        ColumnBuilder builder = new ColumnBuilder().setType(ValueType.DOUBLE);
        partSerde.getDeserializer().read(EMPTY_BUFFER, builder, ColumnConfig.DEFAULT, null);
        ColumnHolder holder = builder.build();
        BaseColumn theColumn = holder.getColumn();
        SimpleAscendingOffset offset = new SimpleAscendingOffset(10);
        ColumnValueSelector valueSelector = theColumn.makeColumnValueSelector((ReadableOffset)offset);
        Assert.assertTrue((boolean)valueSelector.isNull());
        Assert.assertEquals((double)0.0, (double)valueSelector.getDouble(), (double)0.0);
    }

    @Test
    public void testVectorValueSelector() {
        NullColumnPartSerde partSerde = new NullColumnPartSerde(10, (BitmapSerdeFactory)RoaringBitmapSerdeFactory.getInstance());
        ColumnBuilder builder = new ColumnBuilder().setType(ValueType.DOUBLE);
        partSerde.getDeserializer().read(EMPTY_BUFFER, builder, ColumnConfig.DEFAULT, null);
        ColumnHolder holder = builder.build();
        BaseColumn theColumn = holder.getColumn();
        NoFilterVectorOffset vectorOffset = new NoFilterVectorOffset(8, 0, 10);
        VectorValueSelector selector = theColumn.makeVectorValueSelector((ReadableVectorOffset)vectorOffset);
        double[] vector = selector.getDoubleVector();
        boolean[] nulls = selector.getNullVector();
        for (int i = 0; i < vectorOffset.getCurrentVectorSize(); ++i) {
            Assert.assertEquals((double)0.0, (double)vector[i], (double)0.0);
            Assert.assertTrue((boolean)nulls[i]);
        }
    }

    @Test
    public void testIndexSupplier() {
        NullColumnPartSerde partSerde = new NullColumnPartSerde(10, (BitmapSerdeFactory)RoaringBitmapSerdeFactory.getInstance());
        ColumnBuilder builder = new ColumnBuilder().setType(ValueType.DOUBLE);
        partSerde.getDeserializer().read(EMPTY_BUFFER, builder, ColumnConfig.DEFAULT, null);
        ColumnHolder holder = builder.build();
        Assert.assertNull((Object)holder.getIndexSupplier());
    }

    private static /* synthetic */ void lambda$testDimensionVectorSelector$0(DictionaryEncodedColumn dictionaryEncodedColumn, ReadableVectorOffset vectorOffset) throws Throwable {
        dictionaryEncodedColumn.makeMultiValueDimensionVectorSelector(vectorOffset);
    }
}

