/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.transform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.transform.ExpressionTransform;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.transform.Transformer;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TransformerTest
extends InitializedNullHandlingTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testTransformNullRowReturnNull() {
        Transformer transformer = new Transformer(new TransformSpec(null, null));
        Assert.assertNull((Object)transformer.transform((InputRow)null));
        Assert.assertNull((Object)transformer.transform((InputRowListPlusRawValues)null));
    }

    @Test
    public void testTransformTimeColumn() {
        Transformer transformer = new Transformer(new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("__time", "timestamp_shift(__time, 'P1D', -2)", TestExprMacroTable.INSTANCE))));
        DateTime now = DateTimes.nowUtc();
        MapBasedInputRow row = new MapBasedInputRow(now, (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"__time", (Object)now, (Object)"dim", (Object)false));
        InputRow actual = transformer.transform((InputRow)row);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)now.minusDays(2), (Object)actual.getTimestamp());
    }

    @Test
    public void testTransformTimeColumnWithInvalidTimeValue() {
        Transformer transformer = new Transformer(new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("__time", "timestamp_parse(ts, null, 'UTC')", TestExprMacroTable.INSTANCE))));
        DateTime now = DateTimes.nowUtc();
        MapBasedInputRow row = new MapBasedInputRow(now, (List)ImmutableList.of((Object)"ts", (Object)"dim"), (Map)ImmutableMap.of((Object)"ts", (Object)"not_a_timestamp", (Object)"dim", (Object)false));
        this.expectedException.expectMessage("Could not transform value for __time.");
        this.expectedException.expect(ParseException.class);
        transformer.transform((InputRow)row);
    }

    @Test
    public void testTransformTimeColumnWithInvalidTimeValueInputRowListPlusRawValues() {
        Transformer transformer = new Transformer(new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("__time", "timestamp_parse(ts, null, 'UTC')", TestExprMacroTable.INSTANCE))));
        DateTime now = DateTimes.nowUtc();
        MapBasedInputRow row = new MapBasedInputRow(now, (List)ImmutableList.of((Object)"ts", (Object)"dim"), (Map)ImmutableMap.of((Object)"ts", (Object)"not_a_timestamp", (Object)"dim", (Object)false));
        InputRowListPlusRawValues actual = transformer.transform(InputRowListPlusRawValues.of((InputRow)row, (Map)ImmutableMap.of((Object)"ts", (Object)"not_a_timestamp", (Object)"dim", (Object)false)));
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((long)1L, (long)actual.getRawValuesList().size());
        Assert.assertNull((Object)actual.getInputRows());
        Assert.assertEquals((Object)"Could not transform value for __time.", (Object)actual.getParseException().getMessage());
    }

    @Test
    public void testTransformWithStringTransformOnBooleanColumnTransformAfterCasting() {
        Transformer transformer = new Transformer(new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("dim", "strlen(dim)", TestExprMacroTable.INSTANCE))));
        MapBasedInputRow row = new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)false));
        InputRow actual = transformer.transform((InputRow)row);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim"), (Object)actual.getDimensions());
        Assert.assertEquals((Object)1L, (Object)actual.getRaw("dim"));
        Assert.assertEquals((Object)row.getTimestamp(), (Object)actual.getTimestamp());
    }

    @Test
    public void testTransformWithStringTransformOnLongColumnTransformAfterCasting() {
        Transformer transformer = new Transformer(new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("dim", "strlen(dim)", TestExprMacroTable.INSTANCE))));
        MapBasedInputRow row = new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)10L));
        InputRow actual = transformer.transform((InputRow)row);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim"), (Object)actual.getDimensions());
        Assert.assertEquals((Object)2L, (Object)actual.getRaw("dim"));
        Assert.assertEquals((Object)row.getTimestamp(), (Object)actual.getTimestamp());
    }

    @Test
    public void testTransformWithStringTransformOnDoubleColumnTransformAfterCasting() {
        Transformer transformer = new Transformer(new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("dim", "strlen(dim)", TestExprMacroTable.INSTANCE))));
        MapBasedInputRow row = new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)200.5));
        InputRow actual = transformer.transform((InputRow)row);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim"), (Object)actual.getDimensions());
        Assert.assertEquals((Object)5L, (Object)actual.getRaw("dim"));
        Assert.assertEquals((Object)row.getTimestamp(), (Object)actual.getTimestamp());
    }

    @Ignore(value="Disabled until https://github.com/apache/druid/issues/9824 is fixed")
    @Test
    public void testTransformWithStringTransformOnListColumnThrowingException() {
        Transformer transformer = new Transformer(new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("dim", "strlen(dim)", TestExprMacroTable.INSTANCE))));
        MapBasedInputRow row = new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)ImmutableList.of((Object)10, (Object)20, (Object)100)));
        InputRow actual = transformer.transform((InputRow)row);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim"), (Object)actual.getDimensions());
        this.expectedException.expect(AssertionError.class);
        actual.getRaw("dim");
    }

    @Test
    public void testTransformWithSelectorFilterWithStringBooleanValueOnBooleanColumnFilterAfterCasting() {
        Transformer transformer = new Transformer(new TransformSpec((DimFilter)new SelectorDimFilter("dim", "false", null), null));
        MapBasedInputRow row1 = new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)false));
        Assert.assertEquals((Object)row1, (Object)transformer.transform((InputRow)row1));
        MapBasedInputRow row2 = new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)true));
        Assert.assertNull((Object)transformer.transform((InputRow)row2));
    }

    @Test
    public void testTransformWithSelectorFilterWithStringBooleanValueOnStringColumn() {
        Transformer transformer = new Transformer(new TransformSpec((DimFilter)new SelectorDimFilter("dim", "false", null), null));
        MapBasedInputRow row = new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)"false"));
        Assert.assertEquals((Object)row, (Object)transformer.transform((InputRow)row));
        MapBasedInputRow row2 = new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)"true"));
        Assert.assertNull((Object)transformer.transform((InputRow)row2));
    }

    @Test
    public void testTransformWithTransformAndFilterTransformFirst() {
        Transformer transformer = new Transformer(new TransformSpec((DimFilter)new SelectorDimFilter("dim", "0", null), (List)ImmutableList.of((Object)new ExpressionTransform("dim", "strlen(dim) == 10", TestExprMacroTable.INSTANCE))));
        MapBasedInputRow row = new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)"short"));
        InputRow actual = transformer.transform((InputRow)row);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim"), (Object)actual.getDimensions());
        Assert.assertEquals((Object)0L, (Object)actual.getRaw("dim"));
        Assert.assertEquals((Object)row.getTimestamp(), (Object)actual.getTimestamp());
    }

    @Test
    public void testInputRowListPlusRawValuesTransformWithFilter() {
        Transformer transformer = new Transformer(new TransformSpec((DimFilter)new SelectorDimFilter("dim", "val1", null), null));
        List<InputRow> rows = Arrays.asList(new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)"val1")), new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)"val2")));
        List<Map> valList = Arrays.asList(ImmutableMap.of((Object)"dim", (Object)"val1"), ImmutableMap.of((Object)"dim", (Object)"val2"));
        InputRowListPlusRawValues actual = transformer.transform(InputRowListPlusRawValues.ofList(valList, rows));
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((long)1L, (long)actual.getInputRows().size());
        Assert.assertEquals((long)1L, (long)actual.getRawValuesList().size());
        Assert.assertEquals((Object)"val1", (Object)((InputRow)actual.getInputRows().get(0)).getRaw("dim"));
        Assert.assertEquals((Object)"val1", ((Map)actual.getRawValuesList().get(0)).get("dim"));
    }

    @Test
    public void testTransformWithArrayStringInputsExpr() {
        Transformer transformer = new Transformer(new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("dimlen", "array_length(dim)", TestExprMacroTable.INSTANCE))));
        MapBasedInputRow row = new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        InputRow actual = transformer.transform((InputRow)row);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim"), (Object)actual.getDimensions());
        Assert.assertEquals((Object)3L, (Object)actual.getRaw("dimlen"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"3"), (Object)actual.getDimension("dimlen"));
        Assert.assertEquals((Object)row.getTimestamp(), (Object)actual.getTimestamp());
    }

    @Test
    public void testTransformWithArrayStringInputs() {
        Transformer transformer = new Transformer(new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("dim", "dim", TestExprMacroTable.INSTANCE))));
        MapBasedInputRow row = new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        InputRow actual = transformer.transform((InputRow)row);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim"), (Object)actual.getDimensions());
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b", "c"}, (Object[])((Object[])actual.getRaw("dim")));
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)actual.getDimension("dim"));
        Assert.assertEquals((Object)row.getTimestamp(), (Object)actual.getTimestamp());
    }

    @Test
    public void testTransformWithArrayLongInputs() {
        Transformer transformer = new Transformer(new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("dim", "dim", TestExprMacroTable.INSTANCE))));
        MapBasedInputRow row = new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", Arrays.asList(1, 2, null, 3)));
        InputRow actual = transformer.transform((InputRow)row);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim"), (Object)actual.getDimensions());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L, null, 3L}, (Object[])((Object[])actual.getRaw("dim")));
        Assert.assertEquals((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"null", (Object)"3"), (Object)actual.getDimension("dim"));
        Assert.assertEquals((Object)row.getTimestamp(), (Object)actual.getTimestamp());
    }

    @Test
    public void testTransformWithArrayFloatInputs() {
        Transformer transformer = new Transformer(new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("dim", "dim", TestExprMacroTable.INSTANCE))));
        MapBasedInputRow row = new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", Arrays.asList(Float.valueOf(1.2f), Float.valueOf(2.3f), null, Float.valueOf(3.4f))));
        InputRow actual = transformer.transform((InputRow)row);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim"), (Object)actual.getDimensions());
        Object[] raw = (Object[])actual.getRaw("dim");
        Assert.assertEquals((double)1.2, (double)((Double)raw[0]), (double)1.0E-5);
        Assert.assertEquals((double)2.3, (double)((Double)raw[1]), (double)1.0E-5);
        Assert.assertNull((Object)raw[2]);
        Assert.assertEquals((double)3.4, (double)((Double)raw[3]), (double)1.0E-5);
        Assert.assertEquals((Object)ImmutableList.of((Object)"1.2000000476837158", (Object)"2.299999952316284", (Object)"null", (Object)"3.4000000953674316"), (Object)actual.getDimension("dim"));
        Assert.assertEquals((Object)row.getTimestamp(), (Object)actual.getTimestamp());
    }

    @Test
    public void testTransformWithArrayDoubleInputs() {
        Transformer transformer = new Transformer(new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("dim", "dim", TestExprMacroTable.INSTANCE))));
        MapBasedInputRow row = new MapBasedInputRow(DateTimes.nowUtc(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", Arrays.asList(1.2, 2.3, null, 3.4)));
        InputRow actual = transformer.transform((InputRow)row);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim"), (Object)actual.getDimensions());
        Object[] raw = (Object[])actual.getRaw("dim");
        Assert.assertEquals((double)1.2, (double)((Double)raw[0]), (double)0.0);
        Assert.assertEquals((double)2.3, (double)((Double)raw[1]), (double)0.0);
        Assert.assertNull((Object)raw[2]);
        Assert.assertEquals((double)3.4, (double)((Double)raw[3]), (double)0.0);
        Assert.assertEquals((Object)ImmutableList.of((Object)"1.2", (Object)"2.3", (Object)"null", (Object)"3.4"), (Object)actual.getDimension("dim"));
        Assert.assertEquals((Object)row.getTimestamp(), (Object)actual.getTimestamp());
    }

    @Test
    public void testTransformWithArrayExpr() {
        Transformer transformer = new Transformer(new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("dim", "array_slice(dim, 0, 5)", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("dim1", "array_slice(dim, 0, 1)", TestExprMacroTable.INSTANCE))));
        ImmutableList dimList = ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object)"g");
        final MapBasedRow row = new MapBasedRow(DateTimes.nowUtc(), (Map)ImmutableMap.of((Object)"dim", (Object)dimList));
        Assert.assertEquals((Object)row.getDimension("dim"), (Object)dimList);
        Assert.assertEquals((Object)row.getRaw("dim"), (Object)dimList);
        InputRow actualTranformedRow = transformer.transform(new InputRow(){

            public List<String> getDimensions() {
                return new ArrayList<String>(row.getEvent().keySet());
            }

            public long getTimestampFromEpoch() {
                return 0L;
            }

            public DateTime getTimestamp() {
                return row.getTimestamp();
            }

            public List<String> getDimension(String dimension) {
                return row.getDimension(dimension);
            }

            @Nullable
            public Object getRaw(String dimension) {
                return row.getRaw(dimension);
            }

            @Nullable
            public Number getMetric(String metric) {
                return row.getMetric(metric);
            }

            public int compareTo(Row o) {
                return row.compareTo(o);
            }
        });
        Assert.assertEquals((Object)actualTranformedRow.getDimension("dim"), dimList.subList(0, 5));
        Assert.assertArrayEquals((Object[])dimList.subList(0, 5).toArray(), (Object[])((Object[])actualTranformedRow.getRaw("dim")));
        Assert.assertEquals((Object)ImmutableList.of((Object)"a"), (Object)actualTranformedRow.getDimension("dim1"));
    }
}

