/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.timeline.partition.HashBasedNumberedPartialShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwritePartialShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecTestUtils;
import org.apache.druid.timeline.partition.SingleDimensionPartialShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class NumberedOverwriteShardSpecTest {
    @Test
    public void testEquals() {
        EqualsVerifier.forClass(NumberedOverwriteShardSpec.class).usingGetClass().verify();
    }

    @Test
    public void testSerde() throws JsonProcessingException {
        ObjectMapper mapper = ShardSpecTestUtils.initObjectMapper();
        mapper.registerSubtypes(new NamedType[]{new NamedType(NumberedOverwriteShardSpec.class, "numbered_overwrite")});
        NumberedOverwriteShardSpec original = new NumberedOverwriteShardSpec(32770, 0, 10, 1, 3);
        String json = mapper.writeValueAsString((Object)original);
        ShardSpec shardSpec = (ShardSpec)mapper.readValue(json, ShardSpec.class);
        Assert.assertEquals((Object)"numbered_overwrite", (Object)shardSpec.getType());
        NumberedOverwriteShardSpec fromJson = (NumberedOverwriteShardSpec)shardSpec;
        Assert.assertEquals((Object)original, (Object)fromJson);
    }

    @Test
    public void testSharePartitionSpace() {
        NumberedOverwriteShardSpec shardSpec = new NumberedOverwriteShardSpec(32768, 0, 3, 1, 1);
        Assert.assertFalse((boolean)shardSpec.sharePartitionSpace((PartialShardSpec)NumberedPartialShardSpec.instance()));
        Assert.assertFalse((boolean)shardSpec.sharePartitionSpace((PartialShardSpec)new HashBasedNumberedPartialShardSpec(null, 0, 1, null)));
        Assert.assertFalse((boolean)shardSpec.sharePartitionSpace((PartialShardSpec)new SingleDimensionPartialShardSpec("dim", 0, null, null, 1)));
        Assert.assertTrue((boolean)shardSpec.sharePartitionSpace((PartialShardSpec)new NumberedOverwritePartialShardSpec(0, 2, 1)));
    }
}

