/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast.last;

import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.firstlast.StringFirstLastUtils;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;

public class StringLastAggregator
implements Aggregator {
    private final BaseLongColumnValueSelector timeSelector;
    private final BaseObjectColumnValueSelector<?> valueSelector;
    private final int maxStringBytes;
    private final boolean needsFoldCheck;
    protected long lastTime;
    protected String lastValue;

    public StringLastAggregator(BaseLongColumnValueSelector timeSelector, BaseObjectColumnValueSelector<?> valueSelector, int maxStringBytes, boolean needsFoldCheck) {
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.maxStringBytes = maxStringBytes;
        this.needsFoldCheck = needsFoldCheck;
        this.lastTime = DateTimes.MIN.getMillis();
        this.lastValue = null;
    }

    @Override
    public void aggregate() {
        if (this.needsFoldCheck) {
            SerializablePairLongString inPair = StringFirstLastUtils.readPairFromSelectors(this.timeSelector, this.valueSelector);
            if (inPair != null && (Long)inPair.lhs >= this.lastTime) {
                this.lastTime = (Long)inPair.lhs;
                this.lastValue = StringUtils.fastLooseChop((String)inPair.rhs, this.maxStringBytes);
            }
        } else {
            if (this.timeSelector.isNull()) {
                return;
            }
            long time = this.timeSelector.getLong();
            if (time >= this.lastTime) {
                String value = DimensionHandlerUtils.convertObjectToString(this.valueSelector.getObject());
                this.lastTime = time;
                this.lastValue = StringUtils.fastLooseChop(value, this.maxStringBytes);
            }
        }
    }

    @Override
    public Object get() {
        return new SerializablePairLongString(this.lastTime, StringUtils.chop(this.lastValue, this.maxStringBytes));
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("StringLastAggregator does not support getFloat()");
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("StringLastAggregator does not support getLong()");
    }

    @Override
    public double getDouble() {
        throw new UnsupportedOperationException("StringLastAggregator does not support getDouble()");
    }

    @Override
    public void close() {
    }
}

