/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import java.util.ArrayList;
import java.util.List;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.AppendableMemory;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.FieldWriters;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.read.FrameReaderUtils;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.RowBasedFrameWriter;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.utils.CloseableUtils;

public class RowBasedFrameWriterFactory
implements FrameWriterFactory {
    private final MemoryAllocatorFactory allocatorFactory;
    private final RowSignature signature;
    private final List<KeyColumn> sortColumns;
    private final boolean removeNullBytes;

    public RowBasedFrameWriterFactory(MemoryAllocatorFactory allocatorFactory, RowSignature signature, List<KeyColumn> sortColumns, boolean removeNullBytes) {
        this.allocatorFactory = allocatorFactory;
        this.signature = signature;
        this.sortColumns = sortColumns;
        this.removeNullBytes = removeNullBytes;
        FrameWriterUtils.verifySortColumns(sortColumns, signature);
    }

    @Override
    public FrameWriter newFrameWriter(ColumnSelectorFactory columnSelectorFactory) {
        MemoryAllocator allocator = this.allocatorFactory.newAllocator();
        AppendableMemory rowOrderMemory = this.sortColumns.isEmpty() ? null : AppendableMemory.create(allocator);
        AppendableMemory rowOffsetMemory = AppendableMemory.create(allocator);
        AppendableMemory dataMemory = AppendableMemory.create(allocator, 8192);
        return new RowBasedFrameWriter(this.signature, this.sortColumns, this.makeFieldWriters(columnSelectorFactory, this.removeNullBytes), FrameReaderUtils.makeRowMemorySupplier(columnSelectorFactory, this.signature), rowOrderMemory, rowOffsetMemory, dataMemory);
    }

    @Override
    public long allocatorCapacity() {
        return this.allocatorFactory.allocatorCapacity();
    }

    @Override
    public RowSignature signature() {
        return this.signature;
    }

    @Override
    public FrameType frameType() {
        return FrameType.ROW_BASED;
    }

    private List<FieldWriter> makeFieldWriters(ColumnSelectorFactory columnSelectorFactory, boolean removeNullBytes) {
        ArrayList<FieldWriter> fieldWriters = new ArrayList<FieldWriter>();
        try {
            for (int i = 0; i < this.signature.size(); ++i) {
                String column = this.signature.getColumnName(i);
                ColumnType columnType = this.signature.getColumnType(i).orElse(null);
                fieldWriters.add(FieldWriters.create(columnSelectorFactory, column, columnType, removeNullBytes));
            }
        }
        catch (Throwable e) {
            throw CloseableUtils.closeAndWrapInCatch(e, () -> CloseableUtils.closeAll(fieldWriters));
        }
        return fieldWriters;
    }
}

