/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.segment.SegmentReference;

@JsonTypeName(value="table")
public class TableDataSource
implements DataSource {
    private final String name;

    @JsonCreator
    public TableDataSource(@JsonProperty(value="name") String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"'name' must be nonnull");
    }

    @JsonCreator
    public static TableDataSource create(String name) {
        return new TableDataSource(name);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getTableNames() {
        return Collections.singleton(this.name);
    }

    @Override
    public List<DataSource> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (!children.isEmpty()) {
            throw new IAE("Cannot accept children", new Object[0]);
        }
        return this;
    }

    @Override
    public boolean isCacheable(boolean isBroker) {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isConcrete() {
        return true;
    }

    @Override
    public Function<SegmentReference, SegmentReference> createSegmentMapFunction(Query query, AtomicLong cpuTime) {
        return Function.identity();
    }

    @Override
    public DataSource withUpdatedDataSource(DataSource newSource) {
        return newSource;
    }

    @Override
    public DataSource withPolicies(Map<String, Optional<Policy>> policyMap) {
        Optional policy = policyMap.getOrDefault(this.name, Optional.empty());
        if (!policy.isPresent()) {
            return this;
        }
        return RestrictedDataSource.create(this, (Policy)policy.get());
    }

    @Override
    public byte[] getCacheKey() {
        return new byte[0];
    }

    @Override
    public DataSourceAnalysis getAnalysis() {
        return new DataSourceAnalysis(this, null, null, Collections.emptyList());
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableDataSource that = (TableDataSource)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

