/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;

public abstract class TrimExprMacro
implements ExprMacroTable.ExprMacro {
    private static final char[] EMPTY_CHARS = new char[0];
    private static final char[] DEFAULT_CHARS = new char[]{' '};
    private final TrimMode mode;

    public TrimExprMacro(TrimMode mode) {
        this.mode = mode;
    }

    @Override
    public String name() {
        return this.mode.getFnName();
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckAnyOfArgumentCount(args, 1, 2);
        if (args.size() == 1) {
            return new TrimStaticCharsExpr(this, args, DEFAULT_CHARS);
        }
        Expr charsArg = args.get(1);
        if (charsArg.isLiteral()) {
            String charsString = charsArg.eval(InputBindings.nilBindings()).asString();
            char[] chars = charsString == null ? EMPTY_CHARS : charsString.toCharArray();
            return new TrimStaticCharsExpr(this, args, chars);
        }
        return new TrimDynamicCharsExpr(this, args);
    }

    private static boolean arrayContains(char[] array, char c) {
        for (char arrayChar : array) {
            if (arrayChar != c) continue;
            return true;
        }
        return false;
    }

    private static boolean stringContains(String string, char c) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static class RightTrimExprMacro
    extends TrimExprMacro {
        public RightTrimExprMacro() {
            super(TrimMode.RIGHT);
        }
    }

    public static class LeftTrimExprMacro
    extends TrimExprMacro {
        public LeftTrimExprMacro() {
            super(TrimMode.LEFT);
        }
    }

    public static class BothTrimExprMacro
    extends TrimExprMacro {
        public BothTrimExprMacro() {
            super(TrimMode.BOTH);
        }
    }

    @VisibleForTesting
    static class TrimDynamicCharsExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final TrimMode mode;
        private final Expr stringExpr;
        private final Expr charsExpr;

        public TrimDynamicCharsExpr(TrimExprMacro macro, List<Expr> args) {
            super(macro, args);
            this.mode = macro.mode;
            this.stringExpr = args.get(0);
            this.charsExpr = args.get(1);
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            int start;
            ExprEval stringEval = this.stringExpr.eval(bindings);
            if (stringEval.value() == null) {
                return stringEval;
            }
            ExprEval charsEval = this.charsExpr.eval(bindings);
            if (charsEval.value() == null) {
                return stringEval;
            }
            String s = stringEval.asString();
            String chars = charsEval.asString();
            int end = s.length();
            if (this.mode.isLeft()) {
                for (start = 0; start < s.length() && TrimExprMacro.stringContains(chars, s.charAt(start)); ++start) {
                }
            }
            if (this.mode.isRight()) {
                while (end > start && TrimExprMacro.stringContains(chars, s.charAt(end - 1))) {
                    --end;
                }
            }
            if (start == 0 && end == s.length()) {
                return stringEval;
            }
            return ExprEval.of(s.substring(start, end));
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.STRING;
        }
    }

    @VisibleForTesting
    static class TrimStaticCharsExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final TrimMode mode;
        private final char[] chars;
        private final Expr stringExpr;

        public TrimStaticCharsExpr(TrimExprMacro macro, List<Expr> args, char[] chars) {
            super(macro, args);
            this.mode = macro.mode;
            this.stringExpr = args.get(0);
            this.chars = chars;
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            int start;
            ExprEval stringEval = this.stringExpr.eval(bindings);
            if (this.chars.length == 0 || stringEval.value() == null) {
                return stringEval;
            }
            String s = stringEval.asString();
            int end = s.length();
            if (this.mode.isLeft()) {
                for (start = 0; start < s.length() && TrimExprMacro.arrayContains(this.chars, s.charAt(start)); ++start) {
                }
            }
            if (this.mode.isRight()) {
                while (end > start && TrimExprMacro.arrayContains(this.chars, s.charAt(end - 1))) {
                    --end;
                }
            }
            if (start == 0 && end == s.length()) {
                return stringEval;
            }
            return ExprEval.of(s.substring(start, end));
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.STRING;
        }
    }

    static enum TrimMode {
        BOTH("trim", true, true),
        LEFT("ltrim", true, false),
        RIGHT("rtrim", false, true);

        private final String name;
        private final boolean left;
        private final boolean right;

        private TrimMode(String name, boolean left, boolean right) {
            this.name = name;
            this.left = left;
            this.right = right;
        }

        public String getFnName() {
            return this.name;
        }

        public boolean isLeft() {
            return this.left;
        }

        public boolean isRight() {
            return this.right;
        }
    }
}

