/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.rowsandcols.RowsAndColumns;

public abstract class AbstractPartitioningOperator
implements Operator {
    protected final List<String> partitionColumns;
    protected final Operator child;

    public AbstractPartitioningOperator(List<String> partitionColumns, Operator child) {
        this.partitionColumns = partitionColumns;
        this.child = child;
    }

    @Override
    public Closeable goOrContinue(Closeable continuation, Operator.Receiver receiver) {
        if (continuation != null) {
            Continuation cont = (Continuation)continuation;
            if (cont.iter != null) {
                HandleContinuationResult handleContinuationResult = this.handleContinuation(receiver, cont);
                if (!handleContinuationResult.needToContinueProcessing()) {
                    return handleContinuationResult.getContinuation();
                }
                if (cont.subContinuation == null) {
                    receiver.completed();
                    return null;
                }
            }
            continuation = cont.subContinuation;
        }
        AtomicReference<Iterator<RowsAndColumns>> iterHolder = new AtomicReference<Iterator<RowsAndColumns>>();
        Closeable retVal = this.child.goOrContinue(continuation, this.createReceiver(receiver, iterHolder));
        if (iterHolder.get() != null || retVal != null) {
            return new Continuation(iterHolder.get(), retVal);
        }
        return null;
    }

    protected abstract HandleContinuationResult handleContinuation(Operator.Receiver var1, Continuation var2);

    protected abstract Operator.Receiver createReceiver(Operator.Receiver var1, AtomicReference<Iterator<RowsAndColumns>> var2);

    protected HandleContinuationResult handleNonGoCases(Operator.Signal signal, Iterator<RowsAndColumns> iter, Operator.Receiver receiver, Continuation cont) {
        switch (signal) {
            case PAUSE: {
                if (iter.hasNext()) {
                    return HandleContinuationResult.of(cont);
                }
                if (cont.subContinuation == null) {
                    receiver.completed();
                    return HandleContinuationResult.of(null);
                }
                return HandleContinuationResult.of(new Continuation(null, cont.subContinuation));
            }
            case STOP: {
                receiver.completed();
                try {
                    cont.close();
                }
                catch (IOException e) {
                    throw new RE(e, "Unable to close continuation", new Object[0]);
                }
                return HandleContinuationResult.of(null);
            }
        }
        throw new RE("Unknown signal[%s]", new Object[]{signal});
    }

    protected static class HandleContinuationResult {
        private final Closeable continuation;
        private final boolean continueProcessing;
        protected static final HandleContinuationResult CONTINUE_PROCESSING = new HandleContinuationResult(null, true);

        private HandleContinuationResult(Closeable continuation, boolean continueProcessing) {
            this.continuation = continuation;
            this.continueProcessing = continueProcessing;
        }

        protected static HandleContinuationResult of(Closeable closeable) {
            return new HandleContinuationResult(closeable, false);
        }

        private boolean needToContinueProcessing() {
            return this.continueProcessing;
        }

        private Closeable getContinuation() {
            return this.continuation;
        }
    }

    protected static class Continuation
    implements Closeable {
        Iterator<RowsAndColumns> iter;
        Closeable subContinuation;

        public Continuation(Iterator<RowsAndColumns> iter, Closeable subContinuation) {
            this.iter = iter;
            this.subContinuation = subContinuation;
        }

        @Override
        public void close() throws IOException {
            if (this.subContinuation != null) {
                this.subContinuation.close();
            }
        }
    }

    protected static abstract class AbstractReceiver
    implements Operator.Receiver {
        protected final Operator.Receiver delegate;
        protected final AtomicReference<Iterator<RowsAndColumns>> iterHolder;
        protected final List<String> partitionColumns;

        public AbstractReceiver(Operator.Receiver delegate, AtomicReference<Iterator<RowsAndColumns>> iterHolder, List<String> partitionColumns) {
            this.delegate = delegate;
            this.iterHolder = iterHolder;
            this.partitionColumns = partitionColumns;
        }

        @Override
        public Operator.Signal push(RowsAndColumns rac) {
            if (rac == null) {
                throw DruidException.defensive("Should never get a null rac here.", new Object[0]);
            }
            Iterator<RowsAndColumns> partitionsIter = this.getIteratorForRAC(rac);
            Operator.Signal keepItGoing = Operator.Signal.GO;
            while (keepItGoing == Operator.Signal.GO && partitionsIter.hasNext()) {
                RowsAndColumns rowsAndColumns = partitionsIter.next();
                keepItGoing = this.pushPartition(rowsAndColumns, !partitionsIter.hasNext(), keepItGoing);
            }
            if (keepItGoing == Operator.Signal.PAUSE && partitionsIter.hasNext()) {
                this.iterHolder.set(partitionsIter);
                return Operator.Signal.PAUSE;
            }
            return keepItGoing;
        }

        @Override
        public void completed() {
            if (this.iterHolder.get() == null) {
                this.delegate.completed();
            }
        }

        protected Operator.Signal pushPartition(RowsAndColumns partition, boolean isLastPartition, Operator.Signal previousSignal) {
            return this.delegate.push(partition);
        }

        protected abstract Iterator<RowsAndColumns> getIteratorForRAC(RowsAndColumns var1);
    }
}

