/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import javax.annotation.Nullable;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.IncrementalIndexMaxIngestedEventTimeInspector;
import org.apache.druid.segment.IncrementalIndexTimeBoundaryInspector;
import org.apache.druid.segment.MaxIngestedEventTimeInspector;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SimpleTopNOptimizationInspector;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.TopNOptimizationInspector;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCursorFactory;
import org.apache.druid.segment.incremental.IncrementalIndexPhysicalSegmentInspector;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class IncrementalIndexSegment
implements Segment {
    private final IncrementalIndex index;
    private final SegmentId segmentId;

    public IncrementalIndexSegment(IncrementalIndex index, SegmentId segmentId) {
        this.index = index;
        this.segmentId = segmentId;
    }

    @Override
    public SegmentId getId() {
        return this.segmentId;
    }

    @Override
    public Interval getDataInterval() {
        return this.index.getInterval();
    }

    @Override
    public QueryableIndex asQueryableIndex() {
        return null;
    }

    @Override
    public CursorFactory asCursorFactory() {
        return new IncrementalIndexCursorFactory(this.index);
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (TimeBoundaryInspector.class.equals(clazz)) {
            return (T)new IncrementalIndexTimeBoundaryInspector(this.index);
        }
        if (MaxIngestedEventTimeInspector.class.equals(clazz)) {
            return (T)new IncrementalIndexMaxIngestedEventTimeInspector(this.index);
        }
        if (Metadata.class.equals(clazz)) {
            return (T)this.index.getMetadata();
        }
        if (PhysicalSegmentInspector.class.equals(clazz)) {
            return (T)new IncrementalIndexPhysicalSegmentInspector(this.index);
        }
        if (TopNOptimizationInspector.class.equals(clazz)) {
            return (T)new SimpleTopNOptimizationInspector(true);
        }
        return Segment.super.as(clazz);
    }

    @Override
    public void close() {
        this.index.close();
    }
}

