/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.ColumnCache;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorHolder;
import org.apache.druid.segment.QueryableIndexTimeBoundaryInspector;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.data.Offset;
import org.apache.druid.segment.projections.QueryableProjection;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorOffset;

public class QueryableIndexCursorFactory
implements CursorFactory {
    private final QueryableIndex index;
    private final TimeBoundaryInspector timeBoundaryInspector;

    public QueryableIndexCursorFactory(QueryableIndex index, TimeBoundaryInspector timeBoundaryInspector) {
        this.index = index;
        this.timeBoundaryInspector = timeBoundaryInspector;
    }

    public QueryableIndexCursorFactory(QueryableIndex index) {
        this(index, QueryableIndexTimeBoundaryInspector.create(index));
    }

    @Override
    public CursorHolder makeCursorHolder(CursorBuildSpec spec) {
        final QueryableProjection<QueryableIndex> projection = this.index.getProjection(spec);
        if (projection != null) {
            return new QueryableIndexCursorHolder(projection.getRowSelector(), projection.getCursorBuildSpec(), this.timeBoundaryInspector){

                @Override
                protected ColumnSelectorFactory makeColumnSelectorFactoryForOffset(ColumnCache columnCache, Offset baseOffset) {
                    return projection.wrapColumnSelectorFactory(super.makeColumnSelectorFactoryForOffset(columnCache, baseOffset));
                }

                @Override
                protected VectorColumnSelectorFactory makeVectorColumnSelectorFactoryForOffset(ColumnCache columnCache, VectorOffset baseOffset) {
                    return projection.wrapVectorColumnSelectorFactory(super.makeVectorColumnSelectorFactoryForOffset(columnCache, baseOffset));
                }

                @Override
                public boolean isPreAggregated() {
                    return true;
                }

                @Override
                @Nullable
                public List<AggregatorFactory> getAggregatorsForPreAggregated() {
                    return projection.getCursorBuildSpec().getAggregators();
                }
            };
        }
        return new QueryableIndexCursorHolder(this.index, CursorBuildSpec.builder(spec).build(), this.timeBoundaryInspector);
    }

    @Override
    public RowSignature getRowSignature() {
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        for (OrderBy orderBy : this.index.getOrdering()) {
            columns.add(orderBy.getColumnName());
        }
        columns.add("__time");
        columns.addAll(this.index.getColumnNames());
        RowSignature.Builder builder = RowSignature.builder();
        for (String column : columns) {
            ColumnType columnType = ColumnType.fromCapabilities(this.index.getColumnCapabilities(column));
            if (columnType == null) continue;
            builder.add(column, columnType);
        }
        return builder.build();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.index.getColumnCapabilities(column);
    }
}

