/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorAndSize;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.EncodedKeyComponent;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.CapabilitiesBasedFormat;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.FactsHolder;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.druid.segment.incremental.IncrementalIndexRowSelector;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;

public class OnHeapAggregateProjection
implements IncrementalIndexRowSelector {
    private final AggregateProjectionMetadata.Schema projectionSchema;
    private final List<IncrementalIndex.DimensionDesc> dimensions;
    private final int[] parentDimensionIndex;
    private final AggregatorFactory[] aggregatorFactories;
    private final Map<String, IncrementalIndex.DimensionDesc> dimensionsMap;
    private final Map<String, IncrementalIndex.MetricDesc> aggregatorsMap;
    private final Map<String, ColumnFormat> columnFormats;
    private final FactsHolder factsHolder;
    private final IncrementalIndex.InputRowHolder inputRowHolder = new IncrementalIndex.InputRowHolder();
    private final ConcurrentHashMap<Integer, Aggregator[]> aggregators = new ConcurrentHashMap();
    private final ColumnSelectorFactory virtualSelectorFactory;
    private final Map<String, ColumnSelectorFactory> aggSelectors;
    private final boolean useMaxMemoryEstimates;
    private final long maxBytesPerRowForAggregators;
    private final long minTimestamp;
    private final AtomicInteger rowCounter = new AtomicInteger(0);
    private final AtomicInteger numEntries = new AtomicInteger(0);

    public OnHeapAggregateProjection(AggregateProjectionMetadata.Schema schema, List<IncrementalIndex.DimensionDesc> dimensions, Map<String, IncrementalIndex.DimensionDesc> dimensionsMap, int[] parentDimensionIndex, long minTimestamp, boolean useMaxMemoryEstimates, long maxBytesPerRowForAggregators) {
        this.projectionSchema = schema;
        this.dimensions = dimensions;
        this.parentDimensionIndex = parentDimensionIndex;
        this.dimensionsMap = dimensionsMap;
        this.minTimestamp = minTimestamp;
        IncrementalIndex.IncrementalIndexRowComparator rowComparator = new IncrementalIndex.IncrementalIndexRowComparator(this.projectionSchema.getTimeColumnPosition() < 0 ? dimensions.size() : this.projectionSchema.getTimeColumnPosition(), dimensions);
        this.factsHolder = new OnheapIncrementalIndex.RollupFactsHolder(rowComparator, dimensions, this.projectionSchema.getTimeColumnPosition() == 0);
        this.useMaxMemoryEstimates = useMaxMemoryEstimates;
        this.maxBytesPerRowForAggregators = maxBytesPerRowForAggregators;
        this.virtualSelectorFactory = new OnheapIncrementalIndex.CachingColumnSelectorFactory(IncrementalIndex.makeColumnSelectorFactory(schema.getVirtualColumns(), this.inputRowHolder, null));
        this.aggSelectors = new LinkedHashMap<String, ColumnSelectorFactory>();
        this.aggregatorsMap = new LinkedHashMap<String, IncrementalIndex.MetricDesc>();
        this.aggregatorFactories = new AggregatorFactory[schema.getAggregators().length];
        this.columnFormats = new LinkedHashMap<String, ColumnFormat>();
        for (IncrementalIndex.DimensionDesc dimension : dimensions) {
            if (dimension.getName().equals(this.projectionSchema.getTimeColumnName())) {
                this.columnFormats.put(dimension.getName(), new CapabilitiesBasedFormat(ColumnCapabilitiesImpl.createDefault().setType(ColumnType.LONG)));
                continue;
            }
            this.columnFormats.put(dimension.getName(), dimension.getIndexer().getFormat());
        }
        int i = 0;
        for (AggregatorFactory agg : schema.getAggregators()) {
            IncrementalIndex.MetricDesc metricDesc = new IncrementalIndex.MetricDesc(this.aggregatorsMap.size(), agg);
            this.aggregatorsMap.put(metricDesc.getName(), metricDesc);
            this.columnFormats.put(metricDesc.getName(), new CapabilitiesBasedFormat(metricDesc.getCapabilities()));
            ColumnSelectorFactory factory = agg.getIntermediateType().is(ValueType.COMPLEX) ? new OnheapIncrementalIndex.CachingColumnSelectorFactory(IncrementalIndex.makeColumnSelectorFactory(VirtualColumns.EMPTY, this.inputRowHolder, agg)) : this.virtualSelectorFactory;
            this.aggSelectors.put(agg.getName(), factory);
            this.aggregatorFactories[i++] = agg;
        }
    }

    public void addToFacts(IncrementalIndexRow key, InputRow inputRow, List<String> parseExceptionMessages, AtomicLong totalSizeInBytes) {
        Aggregator[] aggs;
        this.inputRowHolder.set(inputRow);
        Object[] projectionDims = new Object[this.dimensions.size()];
        for (int i = 0; i < projectionDims.length; ++i) {
            int parentDimIndex = this.parentDimensionIndex[i];
            if (parentDimIndex < 0) {
                IncrementalIndex.DimensionDesc desc = this.dimensions.get(i);
                ColumnValueSelector virtualSelector = this.virtualSelectorFactory.makeColumnValueSelector(desc.getName());
                EncodedKeyComponent<?> k = desc.getIndexer().processRowValsToUnsortedEncodedKeyComponent(virtualSelector.getObject(), false);
                projectionDims[i] = k.getComponent();
                totalSizeInBytes.addAndGet(k.getEffectiveSizeBytes());
                continue;
            }
            projectionDims[i] = key.dims[this.parentDimensionIndex[i]];
        }
        IncrementalIndexRow subKey = new IncrementalIndexRow(this.projectionSchema.getTimeColumnName() != null ? this.projectionSchema.getGranularity().bucketStart(DateTimes.utc(key.getTimestamp())).getMillis() : this.minTimestamp, projectionDims, this.dimensions);
        int priorIndex = this.factsHolder.getPriorIndex(subKey);
        if (-1 != priorIndex) {
            aggs = this.aggregators.get(priorIndex);
            long aggForProjectionSizeDelta = OnheapIncrementalIndex.doAggregate(this.aggregatorFactories, aggs, this.inputRowHolder, parseExceptionMessages, this.useMaxMemoryEstimates, false);
            totalSizeInBytes.addAndGet(this.useMaxMemoryEstimates ? 0L : aggForProjectionSizeDelta);
        } else {
            aggs = new Aggregator[this.aggregatorFactories.length];
            long aggSizeForProjectionRow = this.factorizeAggs(this.aggregatorFactories, aggs);
            long estimatedSizeOfAggregators = this.useMaxMemoryEstimates ? this.maxBytesPerRowForAggregators : (aggSizeForProjectionRow += OnheapIncrementalIndex.doAggregate(this.aggregatorFactories, aggs, this.inputRowHolder, parseExceptionMessages, this.useMaxMemoryEstimates, false));
            long projectionRowSize = key.estimateBytesInMemory() + estimatedSizeOfAggregators + 44L;
            totalSizeInBytes.addAndGet(this.useMaxMemoryEstimates ? 0L : projectionRowSize);
            this.numEntries.incrementAndGet();
        }
        int rowIndex = this.rowCounter.getAndIncrement();
        this.aggregators.put(rowIndex, aggs);
        this.factsHolder.putIfAbsent(subKey, rowIndex);
    }

    @Override
    public FactsHolder getFacts() {
        return this.factsHolder;
    }

    @Override
    public List<IncrementalIndex.DimensionDesc> getDimensions() {
        return this.dimensions;
    }

    @Override
    public List<String> getMetricNames() {
        return ImmutableList.copyOf(this.aggregatorsMap.keySet());
    }

    @Override
    public IncrementalIndex.DimensionDesc getDimension(String columnName) {
        return this.dimensionsMap.get(columnName);
    }

    @Override
    public IncrementalIndex.MetricDesc getMetric(String columnName) {
        return this.aggregatorsMap.get(columnName);
    }

    @Override
    public List<OrderBy> getOrdering() {
        return this.projectionSchema.getOrderingWithTimeColumnSubstitution();
    }

    @Override
    public int getTimePosition() {
        return this.projectionSchema.getTimeColumnPosition();
    }

    @Override
    public boolean isEmpty() {
        return this.rowCounter.get() == 0;
    }

    @Override
    public int getLastRowIndex() {
        return this.rowCounter.get();
    }

    @Override
    public float getMetricFloatValue(int rowOffset, int aggOffset) {
        return this.aggregators.get(rowOffset)[aggOffset].getFloat();
    }

    @Override
    public long getMetricLongValue(int rowOffset, int aggOffset) {
        return this.aggregators.get(rowOffset)[aggOffset].getLong();
    }

    @Override
    public double getMetricDoubleValue(int rowOffset, int aggOffset) {
        return this.aggregators.get(rowOffset)[aggOffset].getDouble();
    }

    @Override
    @Nullable
    public Object getMetricObjectValue(int rowOffset, int aggOffset) {
        return this.aggregators.get(rowOffset)[aggOffset].get();
    }

    @Override
    public boolean isNull(int rowOffset, int aggOffset) {
        return this.aggregators.get(rowOffset)[aggOffset].isNull();
    }

    @Override
    public ColumnFormat getColumnFormat(String columnName) {
        return this.columnFormats.get(columnName);
    }

    @Override
    public int numRows() {
        return this.numEntries.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDimensionNames(boolean includeTime) {
        Map<String, IncrementalIndex.DimensionDesc> map = this.dimensionsMap;
        synchronized (map) {
            if (includeTime && this.projectionSchema.getTimeColumnName() != null) {
                ImmutableList.Builder listBuilder = ImmutableList.builderWithExpectedSize((int)(this.dimensionsMap.size() + 1));
                int i = 0;
                if (i == this.projectionSchema.getTimeColumnPosition()) {
                    listBuilder.add((Object)this.projectionSchema.getTimeColumnName());
                }
                for (String dimName : this.dimensionsMap.keySet()) {
                    listBuilder.add((Object)dimName);
                    if (++i != this.projectionSchema.getTimeColumnPosition()) continue;
                    listBuilder.add((Object)this.projectionSchema.getTimeColumnName());
                }
                return listBuilder.build();
            }
            return ImmutableList.copyOf(this.dimensionsMap.keySet());
        }
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        if ("__time".equals(column) || Objects.equals(column, this.projectionSchema.getTimeColumnName())) {
            return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.LONG).setHasNulls(false);
        }
        if (this.dimensionsMap.containsKey(column)) {
            return this.dimensionsMap.get(column).getCapabilities();
        }
        if (this.aggregatorsMap.containsKey(column)) {
            return this.aggregatorsMap.get(column).getCapabilities();
        }
        return null;
    }

    public Map<String, IncrementalIndex.DimensionDesc> getDimensionsMap() {
        return this.dimensionsMap;
    }

    public AggregateProjectionMetadata toMetadata() {
        return new AggregateProjectionMetadata(this.projectionSchema, this.numEntries.get());
    }

    private long factorizeAggs(AggregatorFactory[] aggregatorFactories, Aggregator[] aggs) {
        long totalInitialSizeBytes = 0L;
        long aggReferenceSize = 8L;
        for (int i = 0; i < aggregatorFactories.length; ++i) {
            AggregatorFactory agg = aggregatorFactories[i];
            if (this.useMaxMemoryEstimates) {
                aggs[i] = agg.factorize(this.aggSelectors.get(agg.getName()));
                continue;
            }
            AggregatorAndSize aggregatorAndSize = agg.factorizeWithSize(this.aggSelectors.get(agg.getName()));
            aggs[i] = aggregatorAndSize.getAggregator();
            totalInitialSizeBytes += aggregatorAndSize.getInitialSizeBytes();
            totalInitialSizeBytes += 8L;
        }
        return totalInitialSizeBytes;
    }
}

