/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.druid.collections.CircularList;
import org.junit.Assert;
import org.junit.Test;

public class CircularListTest {
    @Test
    public void testIterateInNaturalOrder() {
        ImmutableSet input = ImmutableSet.of((Object)"b", (Object)"a", (Object)"c");
        CircularList circularList = new CircularList((Set)input, Comparator.naturalOrder());
        ArrayList<String> observedElements = new ArrayList<String>();
        int cnt = 0;
        for (String x : circularList) {
            observedElements.add(x);
            if (++cnt < input.size()) continue;
            break;
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), observedElements);
    }

    @Test
    public void testIterateInReverseOrder() {
        ImmutableSet input = ImmutableSet.of((Object)-1, (Object)100, (Object)0, (Object)-4);
        CircularList circularList = new CircularList((Set)input, Comparator.reverseOrder());
        ArrayList<Integer> observedElements = new ArrayList<Integer>();
        int cnt = 0;
        for (Integer x : circularList) {
            observedElements.add(x);
            if (++cnt < 2 * input.size()) continue;
            break;
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)100, (Object)0, (Object)-1, (Object)-4, (Object)100, (Object)0, (Object)-1, (Object)-4), observedElements);
    }

    @Test
    public void testIteratorResumesFromLastPosition() {
        ImmutableSet input = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object[])new String[0]);
        CircularList circularList = new CircularList((Set)input, Comparator.naturalOrder());
        ArrayList<String> observedElements = new ArrayList<String>();
        int cnt = 0;
        for (String element : circularList) {
            observedElements.add(element);
            if (++cnt < input.size() / 2) continue;
            break;
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), observedElements);
        observedElements = new ArrayList();
        for (String element : circularList) {
            observedElements.add(element);
            if (++cnt != input.size() + 2) continue;
            break;
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"d", (Object)"e", (Object)"f", (Object)"a", (Object)"b"), observedElements);
    }

    @Test
    public void testEqualsSet() {
        ImmutableSet input = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c");
        CircularList circularList = new CircularList((Set)input, Comparator.naturalOrder());
        Assert.assertTrue((boolean)circularList.equalsSet((Set)ImmutableSet.of((Object)"b", (Object)"a", (Object)"c")));
        Assert.assertFalse((boolean)circularList.equalsSet((Set)ImmutableSet.of((Object)"c")));
        Assert.assertFalse((boolean)circularList.equalsSet((Set)ImmutableSet.of((Object)"a", (Object)"c")));
    }

    @Test
    public void testEmptyIterator() {
        ImmutableSet input = ImmutableSet.of();
        CircularList circularList = new CircularList((Set)input, Comparator.naturalOrder());
        ArrayList<String> observedElements = new ArrayList<String>();
        int cnt = 0;
        for (String x : circularList) {
            observedElements.add(x);
            if (++cnt < input.size()) continue;
            break;
        }
        Assert.assertEquals((Object)ImmutableList.of(), observedElements);
    }

    @Test
    public void testNextOnEmptyIteratorThrowsException() {
        ImmutableSet input = ImmutableSet.of();
        CircularList circularList = new CircularList((Set)input, Comparator.naturalOrder());
        Iterator iterator = circularList.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertThrows(NoSuchElementException.class, iterator::next);
    }
}

