/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.bitmap;

import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.testing.CollectionTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.druid.collections.bitmap.BitSetBitmapFactory;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.roaringbitmap.IntIterator;

public class BitmapIterationTest
extends TestCase {
    public static Test suite() {
        List<BitmapFactory> factories = Arrays.asList(new BitSetBitmapFactory(), new ConciseBitmapFactory());
        TestSuite suite = new TestSuite();
        for (BitmapFactory factory : factories) {
            suite.addTest(BitmapIterationTest.suiteForFactory(factory));
        }
        return suite;
    }

    private static Test suiteForFactory(BitmapFactory factory) {
        return ((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new BitmapCollectionGenerator(factory)).named("bitmap iteration tests of " + String.valueOf(factory))).withFeatures(new Feature[]{CollectionFeature.KNOWN_ORDER})).withFeatures(new Feature[]{CollectionFeature.REJECTS_DUPLICATES_AT_CREATION})).withFeatures(new Feature[]{CollectionFeature.RESTRICTS_ELEMENTS})).withFeatures(new Feature[]{CollectionSize.ANY})).createTestSuite();
    }

    private static class BitmapCollectionGenerator
    implements TestCollectionGenerator<Integer> {
        private final BitmapFactory factory;

        private BitmapCollectionGenerator(BitmapFactory factory) {
            this.factory = factory;
        }

        public SampleElements<Integer> samples() {
            return new SampleElements.Ints();
        }

        public BitmapCollection create(Object ... objects) {
            MutableBitmap mutableBitmap = this.factory.makeEmptyMutableBitmap();
            for (Object element : objects) {
                mutableBitmap.add(((Integer)element).intValue());
            }
            return new BitmapCollection(this.factory.makeImmutableBitmap(mutableBitmap), objects.length);
        }

        public Integer[] createArray(int n) {
            return new Integer[n];
        }

        public Iterable<Integer> order(List<Integer> list) {
            Collections.sort(list);
            return list;
        }
    }

    private static class BitmapCollection
    extends AbstractCollection<Integer> {
        private final ImmutableBitmap bitmap;
        private final int size;

        private BitmapCollection(ImmutableBitmap bitmap, int size) {
            this.bitmap = bitmap;
            this.size = size;
        }

        @Override
        public UnmodifiableIterator<Integer> iterator() {
            final IntIterator iterator = this.bitmap.iterator();
            return new UnmodifiableIterator<Integer>(){

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public Integer next() {
                    return iterator.next();
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

