/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import java.util.Arrays;
import java.util.Collections;
import org.apache.druid.data.input.impl.DelimitedBytes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class DelimitedBytesTest
extends InitializedNullHandlingTest {
    private static final byte TSV = 9;

    @Test
    public void testEmpty() {
        Assert.assertEquals(Collections.singletonList(null), (Object)DelimitedBytes.split((byte[])new byte[0], (byte)9, (int)-1));
    }

    @Test
    public void testNoDelimiter() {
        Assert.assertEquals(Collections.singletonList("abc"), (Object)DelimitedBytes.split((byte[])StringUtils.toUtf8((String)"abc"), (byte)9, (int)-1));
    }

    @Test
    public void testOneDelimiter() {
        Assert.assertEquals(Arrays.asList("a", "bc"), (Object)DelimitedBytes.split((byte[])StringUtils.toUtf8((String)"a\tbc"), (byte)9, (int)-1));
    }

    @Test
    public void testDelimiterAtStart() {
        Assert.assertEquals(Arrays.asList(null, "abc"), (Object)DelimitedBytes.split((byte[])StringUtils.toUtf8((String)"\tabc"), (byte)9, (int)-1));
    }

    @Test
    public void testDelimiterAtEnd() {
        Assert.assertEquals(Arrays.asList("a", "bc", null), (Object)DelimitedBytes.split((byte[])StringUtils.toUtf8((String)"a\tbc\t"), (byte)9, (int)-1));
    }

    @Test
    public void testMoreFieldsThanHint() {
        Assert.assertEquals(Arrays.asList("a", "b", "c"), (Object)DelimitedBytes.split((byte[])StringUtils.toUtf8((String)"a\tb\tc"), (byte)9, (int)1));
    }
}

