/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.error;

import java.io.IOException;
import java.util.Map;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.error.NotFound;
import org.apache.druid.matchers.DruidMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class NotFoundTest {
    @Test
    public void testAsErrorResponse() {
        ErrorResponse errorResponse = new ErrorResponse(NotFound.exception((Throwable)new IOException("could not open file"), (String)"id not found", (Object[])new Object[0]));
        Map asMap = errorResponse.getAsMap();
        MatcherAssert.assertThat((Object)asMap, DruidMatchers.mapMatcher("error", "druidException", "errorCode", "notFound", "persona", "USER", "category", "NOT_FOUND", "errorMessage", "id not found"));
        ErrorResponse recomposed = ErrorResponse.fromMap((Map)asMap);
        MatcherAssert.assertThat((Object)recomposed.getUnderlyingException(), (Matcher)new DruidExceptionMatcher(DruidException.Persona.USER, DruidException.Category.NOT_FOUND, "notFound").expectMessageContains("id not found"));
    }
}

