/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.testutil;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.HeapMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.ByteTracker;
import org.apache.druid.frame.channel.FrameChannelSequence;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameSegment;
import org.apache.druid.frame.testutil.FrameSequenceBuilder;
import org.apache.druid.frame.testutil.RowNumberUpdatingCursor;
import org.apache.druid.frame.testutil.RowReadingVectorColumnProcessorFactory;
import org.apache.druid.frame.util.SettableLongVirtualColumn;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;
import org.junit.Assert;

public class FrameTestUtil {
    public static final String ROW_NUMBER_COLUMN = "__row_number";

    private FrameTestUtil() {
    }

    public static File writeFrameFile(Sequence<Frame> frames, File file) throws IOException {
        FrameTestUtil.writeFrameFile(frames, Files.newOutputStream(file.toPath(), new OpenOption[0]));
        return file;
    }

    public static void writeFrameFile(Sequence<Frame> frames, OutputStream out) throws IOException {
        try (FrameFileWriter writer = FrameFileWriter.open((WritableByteChannel)Channels.newChannel(out), null, (ByteTracker)ByteTracker.unboundedTracker());){
            frames.forEach(frame -> {
                try {
                    writer.writeFrame(frame, -1);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static void writeFrameFileWithPartitions(Sequence<IntObjectPair<Frame>> framesWithPartitions, OutputStream out) throws IOException {
        try (FrameFileWriter writer = FrameFileWriter.open((WritableByteChannel)Channels.newChannel(out), null, (ByteTracker)ByteTracker.unboundedTracker());){
            framesWithPartitions.forEach(frameWithPartition -> {
                try {
                    writer.writeFrame((Frame)frameWithPartition.right(), frameWithPartition.leftInt());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static void assertRowsEqual(Sequence<List<Object>> expected, Sequence<List<Object>> actual) {
        List expectedRows = expected.toList();
        List actualRows = actual.toList();
        Assert.assertEquals((String)"number of rows", (long)expectedRows.size(), (long)actualRows.size());
        for (int i = 0; i < expectedRows.size(); ++i) {
            FrameTestUtil.assertRowEqual("row #" + i, (List)expectedRows.get(i), (List)actualRows.get(i));
        }
    }

    public static void assertRowEqual(List<Object> expected, List<Object> actual) {
        FrameTestUtil.assertRowEqual(null, expected, actual);
    }

    public static void assertRowEqual(String message, List<Object> expected, List<Object> actual) {
        boolean ok;
        if (expected.size() == actual.size()) {
            ok = true;
            for (int i = 0; i < expected.size(); ++i) {
                Object actualValue;
                Object expectedValue = expected.get(i);
                if (Objects.deepEquals(expectedValue, actualValue = actual.get(i))) continue;
                ok = false;
                break;
            }
        } else {
            ok = false;
        }
        if (!ok) {
            Assert.assertEquals((String)message, (Object)Arrays.deepToString(expected.toArray()), (Object)Arrays.deepToString(actual.toArray()));
            Assert.fail((String)message);
        }
    }

    public static Frame cursorFactoryToFrame(CursorFactory adapter, FrameType frameType) {
        return (Frame)Iterables.getOnlyElement((Iterable)FrameSequenceBuilder.fromCursorFactory(adapter).allocator((MemoryAllocator)HeapMemoryAllocator.unlimited()).frameType(frameType).frames().toList());
    }

    public static FrameSegment cursorFactoryToFrameSegment(CursorFactory adapter, FrameType frameType) {
        return new FrameSegment(FrameTestUtil.cursorFactoryToFrame(adapter, frameType), FrameReader.create((RowSignature)adapter.getRowSignature()), SegmentId.of((String)"TestFrame", (Interval)Intervals.ETERNITY, (String)"0", (int)0));
    }

    public static FrameSegment cursorFactoryToFrameSegment(CursorFactory cursorFactory, FrameType frameType, SegmentId segmentId) {
        return new FrameSegment(FrameTestUtil.cursorFactoryToFrame(cursorFactory, frameType), FrameReader.create((RowSignature)cursorFactory.getRowSignature()), segmentId);
    }

    public static Sequence<List<Object>> readRowsFromFrameChannel(ReadableFrameChannel channel, FrameReader frameReader) {
        return new FrameChannelSequence(channel).flatMap(frame -> {
            CursorHolder cursorHolder = frameReader.makeCursorFactory(frame).makeCursorHolder(CursorBuildSpec.FULL_SCAN);
            Cursor cursor = cursorHolder.asCursor();
            if (cursor == null) {
                return Sequences.withBaggage((Sequence)Sequences.empty(), (Closeable)cursorHolder);
            }
            return FrameTestUtil.readRowsFromCursor(cursor, frameReader.signature()).withBaggage((Closeable)cursorHolder);
        });
    }

    public static Sequence<List<Object>> readRowsFromCursorFactory(CursorFactory cursorFactory, @Nullable RowSignature signature, boolean populateRowNumber) {
        RowSignature signatureToUse = signature == null ? cursorFactory.getRowSignature() : signature;
        CursorHolder cursorHolder = FrameTestUtil.makeCursorForCursorFactory(cursorFactory, populateRowNumber);
        Cursor cursor = cursorHolder.asCursor();
        if (cursor == null) {
            return Sequences.withBaggage((Sequence)Sequences.empty(), (Closeable)cursorHolder);
        }
        return FrameTestUtil.readRowsFromCursor(cursor, signatureToUse).withBaggage((Closeable)cursorHolder);
    }

    public static Sequence<List<Object>> readRowsFromCursorFactory(CursorFactory cursorFactory) {
        return FrameTestUtil.readRowsFromCursorFactory(cursorFactory, null, false);
    }

    public static Sequence<List<Object>> readRowsFromCursorFactoryWithRowNumber(CursorFactory cursorFactory) {
        return FrameTestUtil.readRowsFromCursorFactory(cursorFactory, null, true);
    }

    public static CursorHolder makeCursorForCursorFactory(CursorFactory cursorFactory, boolean populateRowNumber) {
        VirtualColumns virtualColumns;
        SettableLongVirtualColumn rowNumberVirtualColumn;
        if (populateRowNumber) {
            rowNumberVirtualColumn = new SettableLongVirtualColumn(ROW_NUMBER_COLUMN);
            virtualColumns = VirtualColumns.create(Collections.singletonList(rowNumberVirtualColumn));
        } else {
            rowNumberVirtualColumn = null;
            virtualColumns = VirtualColumns.EMPTY;
        }
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setVirtualColumns(virtualColumns).build();
        final CursorHolder cursorHolder = cursorFactory.makeCursorHolder(buildSpec);
        if (populateRowNumber) {
            return new CursorHolder(){

                @Nullable
                public Cursor asCursor() {
                    Cursor cursor = cursorHolder.asCursor();
                    if (cursor == null) {
                        return null;
                    }
                    return new RowNumberUpdatingCursor(cursor, rowNumberVirtualColumn);
                }

                public List<OrderBy> getOrdering() {
                    return cursorHolder.getOrdering();
                }

                public void close() {
                    cursorHolder.close();
                }
            };
        }
        return cursorHolder;
    }

    public static Sequence<List<Object>> readRowsFromCursor(Cursor cursor, RowSignature signature) {
        ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
        ArrayList<Supplier<Object>> columnReaders = new ArrayList<Supplier<Object>>();
        for (int i = 0; i < signature.size(); ++i) {
            ColumnValueSelector selector;
            String columnName = signature.getColumnName(i);
            Optional columnType = signature.getColumnType(i);
            if (columnType.isPresent() && ((ColumnType)columnType.get()).is((TypeDescriptor)ValueType.STRING)) {
                selector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)columnName));
                columnReaders.add(FrameTestUtil.dimensionSelectorReader((DimensionSelector)selector));
                continue;
            }
            selector = columnSelectorFactory.makeColumnValueSelector(columnName);
            columnReaders.add(() -> ((ColumnValueSelector)selector).getObject());
        }
        ArrayList retVal = new ArrayList();
        while (!cursor.isDone()) {
            List o = columnReaders.stream().map(Supplier::get).collect(Collectors.toList());
            retVal.add(o);
            cursor.advance();
        }
        return Sequences.simple(retVal);
    }

    public static Sequence<List<Object>> readRowsFromVectorCursor(VectorCursor cursor, RowSignature signature) {
        VectorColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
        ArrayList<Supplier> columnReaders = new ArrayList<Supplier>();
        for (int i = 0; i < signature.size(); ++i) {
            String columnName = signature.getColumnName(i);
            Supplier columnReader = (Supplier)ColumnProcessors.makeVectorProcessor((String)columnName, (VectorColumnProcessorFactory)RowReadingVectorColumnProcessorFactory.INSTANCE, (VectorColumnSelectorFactory)columnSelectorFactory);
            columnReaders.add(columnReader);
        }
        ArrayList retVal = new ArrayList();
        while (!cursor.isDone()) {
            int vectorSize = cursor.getCurrentVectorSize();
            List columns = columnReaders.stream().map(Supplier::get).collect(Collectors.toList());
            for (int i = 0; i < vectorSize; ++i) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (Object[] column : columns) {
                    row.add(column[i]);
                }
                retVal.add(row);
            }
            cursor.advance();
        }
        return Sequences.simple(retVal);
    }

    private static Supplier<Object> dimensionSelectorReader(DimensionSelector selector) {
        return () -> {
            IndexedInts row = selector.getRow();
            int sz = row.size();
            if (sz == 1) {
                return selector.lookupName(row.get(0));
            }
            ArrayList<String> retVal = new ArrayList<String>(sz);
            for (int i = 0; i < sz; ++i) {
                retVal.add(selector.lookupName(row.get(i)));
            }
            return retVal;
        };
    }
}

