/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.druid.java.util.RetryableException;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.junit.Assert;
import org.junit.Test;

public class RetryUtilsTest {
    private static final Predicate<Throwable> IS_TRANSIENT = e -> e instanceof IOException && e.getMessage().equals("what");

    @Test
    public void testImmediateSuccess() throws Exception {
        AtomicInteger count = new AtomicInteger();
        String result = (String)RetryUtils.retry(() -> {
            count.incrementAndGet();
            return "hey";
        }, IS_TRANSIENT, (int)2);
        Assert.assertEquals((String)"result", (Object)"hey", (Object)result);
        Assert.assertEquals((String)"count", (long)1L, (long)count.get());
    }

    @Test
    public void testEventualFailure() throws Exception {
        AtomicInteger count = new AtomicInteger();
        boolean threwExpectedException = false;
        try {
            RetryUtils.retry(() -> {
                count.incrementAndGet();
                throw new IOException("what");
            }, IS_TRANSIENT, (int)2);
        }
        catch (IOException e) {
            threwExpectedException = e.getMessage().equals("what");
        }
        Assert.assertTrue((String)"threw expected exception", (boolean)threwExpectedException);
        Assert.assertEquals((String)"count", (long)2L, (long)count.get());
    }

    @Test
    public void testEventualSuccess() throws Exception {
        AtomicInteger count = new AtomicInteger();
        String result = (String)RetryUtils.retry(() -> {
            if (count.incrementAndGet() >= 2) {
                return "hey";
            }
            throw new IOException("what");
        }, IS_TRANSIENT, (int)3);
        Assert.assertEquals((String)"result", (Object)"hey", (Object)result);
        Assert.assertEquals((String)"count", (long)2L, (long)count.get());
    }

    @Test
    public void testExceptionPredicateNotMatching() {
        AtomicInteger count = new AtomicInteger();
        Assert.assertThrows((String)"uhh", IOException.class, () -> RetryUtils.retry(() -> {
            if (count.incrementAndGet() >= 2) {
                return "hey";
            }
            throw new IOException("uhh");
        }, IS_TRANSIENT, (int)3));
        Assert.assertEquals((String)"count", (long)1L, (long)count.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testInterruptWhileSleepingBetweenTries() {
        ExecutorService exec = Execs.singleThreaded((String)"test-interrupt");
        try {
            MutableInt count = new MutableInt(0);
            Future<Object> future = exec.submit(() -> RetryUtils.retry(() -> {
                if (count.incrementAndGet() > 1) {
                    Thread.currentThread().interrupt();
                }
                throw new RuntimeException("Test exception");
            }, (Predicate)Predicates.alwaysTrue(), (int)2, (int)Integer.MAX_VALUE));
            Assert.assertThrows((String)"sleep interrupted", ExecutionException.class, future::get);
        }
        finally {
            exec.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testInterruptRetryLoop() {
        ExecutorService exec = Execs.singleThreaded((String)"test-interrupt");
        try {
            MutableInt count = new MutableInt(0);
            Future<Object> future = exec.submit(() -> RetryUtils.retry(() -> {
                if (count.incrementAndGet() > 1) {
                    Thread.currentThread().interrupt();
                }
                throw new RuntimeException("Test exception");
            }, (Predicate)Predicates.alwaysTrue(), (int)2, (int)Integer.MAX_VALUE, null, null, (boolean)true));
            Assert.assertThrows((String)"Current thread is interrupted after [2] tries", ExecutionException.class, future::get);
        }
        finally {
            exec.shutdownNow();
        }
    }

    @Test
    public void testExceptionPredicateForRetryableException() throws Exception {
        AtomicInteger count = new AtomicInteger();
        String result = (String)RetryUtils.retry(() -> {
            if (count.incrementAndGet() >= 2) {
                return "hey";
            }
            throw new RetryableException((Throwable)new RuntimeException("uhh"));
        }, e -> e instanceof RetryableException, (int)3);
        Assert.assertEquals((Object)result, (Object)"hey");
        Assert.assertEquals((String)"count", (long)2L, (long)count.get());
    }

    @Test
    public void testNextRetrySleepMillis() {
        long nextSleepMillis;
        int i;
        long totalSleepTimeMillis = 0L;
        for (i = 1; i < 7; ++i) {
            nextSleepMillis = RetryUtils.nextRetrySleepMillis((int)i);
            Assert.assertTrue((nextSleepMillis >= 0L ? 1 : 0) != 0);
            Assert.assertTrue(((double)nextSleepMillis <= 2000.0 * Math.pow(2.0, i - 1) ? 1 : 0) != 0);
            totalSleepTimeMillis += nextSleepMillis;
        }
        for (i = 7; i < 11; ++i) {
            nextSleepMillis = RetryUtils.nextRetrySleepMillis((int)i);
            Assert.assertTrue((nextSleepMillis >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((nextSleepMillis <= 120000L ? 1 : 0) != 0);
            totalSleepTimeMillis += nextSleepMillis;
        }
        Assert.assertTrue((totalSleepTimeMillis > 180000L ? 1 : 0) != 0);
        Assert.assertTrue((totalSleepTimeMillis < 480000L ? 1 : 0) != 0);
    }
}

