/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.base.Ticker;
import com.google.common.testing.FakeTicker;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.Stopwatch;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class StopwatchTest {
    @Test
    public void testDuplicateStartThrowsException() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Assert.assertThrows(IllegalStateException.class, () -> ((Stopwatch)stopwatch).start());
    }

    @Test
    public void testDuplicateStopThrowsException() {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        Assert.assertThrows(IllegalStateException.class, () -> ((Stopwatch)stopwatch).stop());
    }

    @Test
    public void testMillisElapsed() {
        FakeTicker fakeTicker = new FakeTicker();
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)fakeTicker);
        fakeTicker.advance(100L, TimeUnit.MILLISECONDS);
        stopwatch.stop();
        Assert.assertEquals((long)100L, (long)stopwatch.millisElapsed());
    }

    @Test
    public void testHasElapsed() {
        FakeTicker fakeTicker = new FakeTicker();
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)fakeTicker);
        fakeTicker.advance(100L, TimeUnit.MILLISECONDS);
        stopwatch.stop();
        Assert.assertTrue((boolean)stopwatch.hasElapsed(Duration.millis((long)50L)));
        Assert.assertTrue((boolean)stopwatch.hasElapsed(Duration.millis((long)100L)));
        Assert.assertTrue((boolean)stopwatch.hasNotElapsed(Duration.millis((long)101L)));
        Assert.assertTrue((boolean)stopwatch.hasNotElapsed(Duration.millis((long)500L)));
    }
}

