/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class InlineDataSourceTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final AtomicLong iterationCounter = new AtomicLong();
    private final List<Object[]> rows = ImmutableList.of((Object)new Object[]{DateTimes.of((String)"2000").getMillis(), "foo", 0.0, ImmutableMap.of((Object)"n", (Object)"0"), ImmutableList.of((Object)1.0, (Object)2.0)}, (Object)new Object[]{DateTimes.of((String)"2000").getMillis(), "bar", 1.0, ImmutableMap.of((Object)"n", (Object)"1"), ImmutableList.of((Object)2.0, (Object)4.0)}, (Object)new Object[]{DateTimes.of((String)"2000").getMillis(), "baz", 2.0, ImmutableMap.of((Object)"n", (Object)"2"), ImmutableList.of((Object)3.0, (Object)6.0)});
    private final Iterable<Object[]> rowsIterable = () -> {
        this.iterationCounter.incrementAndGet();
        return this.rows.iterator();
    };
    private final List<String> expectedColumnNames = ImmutableList.of((Object)"__time", (Object)"str", (Object)"double", (Object)"complex", (Object)"double_array");
    private final ColumnType someComplex = new ColumnType(ValueType.COMPLEX, "foo", null);
    private final List<ColumnType> expectedColumnTypes = ImmutableList.of((Object)ColumnType.LONG, (Object)ColumnType.STRING, (Object)ColumnType.DOUBLE, (Object)this.someComplex, (Object)ColumnType.DOUBLE_ARRAY);
    private final RowSignature expectedRowSignature;
    private final InlineDataSource listDataSource;
    private final InlineDataSource iterableDataSource;

    public InlineDataSourceTest() {
        RowSignature.Builder builder = RowSignature.builder();
        for (int i = 0; i < this.expectedColumnNames.size(); ++i) {
            builder.add(this.expectedColumnNames.get(i), this.expectedColumnTypes.get(i));
        }
        this.expectedRowSignature = builder.build();
        this.listDataSource = InlineDataSource.fromIterable(this.rows, (RowSignature)this.expectedRowSignature);
        this.iterableDataSource = InlineDataSource.fromIterable(this.rowsIterable, (RowSignature)this.expectedRowSignature);
    }

    @Test
    public void test_getTableNames() {
        Assert.assertEquals(Collections.emptySet(), (Object)this.listDataSource.getTableNames());
        Assert.assertEquals(Collections.emptySet(), (Object)this.iterableDataSource.getTableNames());
    }

    @Test
    public void test_getColumnNames() {
        Assert.assertEquals(this.expectedColumnNames, (Object)this.listDataSource.getColumnNames());
        Assert.assertEquals(this.expectedColumnNames, (Object)this.iterableDataSource.getColumnNames());
    }

    @Test
    public void test_getColumnTypes() {
        Assert.assertEquals(this.expectedColumnTypes, (Object)this.listDataSource.getColumnTypes());
        Assert.assertEquals(this.expectedColumnTypes, (Object)this.iterableDataSource.getColumnTypes());
    }

    @Test
    public void test_getChildren() {
        Assert.assertEquals(Collections.emptyList(), (Object)this.listDataSource.getChildren());
        Assert.assertEquals(Collections.emptyList(), (Object)this.iterableDataSource.getChildren());
    }

    @Test
    public void test_getRowSignature() {
        Assert.assertEquals((Object)RowSignature.builder().add("__time", ColumnType.LONG).add("str", ColumnType.STRING).add("double", ColumnType.DOUBLE).add("complex", this.someComplex).add("double_array", ColumnType.DOUBLE_ARRAY).build(), (Object)this.listDataSource.getRowSignature());
    }

    @Test
    public void test_isCacheable() {
        Assert.assertFalse((boolean)this.listDataSource.isCacheable(true));
        Assert.assertFalse((boolean)this.listDataSource.isCacheable(false));
    }

    @Test
    public void test_isGlobal() {
        Assert.assertTrue((boolean)this.listDataSource.isGlobal());
    }

    @Test
    public void test_isConcrete() {
        Assert.assertTrue((boolean)this.listDataSource.isConcrete());
    }

    @Test
    public void test_rowAdapter() {
        RowAdapter adapter = this.listDataSource.rowAdapter();
        Object[] row = this.rows.get(1);
        Assert.assertEquals((long)DateTimes.of((String)"2000").getMillis(), (long)adapter.timestampFunction().applyAsLong(row));
        Assert.assertEquals((Object)"bar", adapter.columnFunction("str").apply(row));
        Assert.assertEquals((Object)1.0, adapter.columnFunction("double").apply(row));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"n", (Object)"1"), adapter.columnFunction("complex").apply(row));
        Assert.assertEquals((Object)ImmutableList.of((Object)2.0, (Object)4.0), adapter.columnFunction("double_array").apply(row));
    }

    @Test
    public void test_getRows_list() {
        Assert.assertSame(this.rows, (Object)this.listDataSource.getRowsAsList());
    }

    @Test
    public void test_getRows_iterable() {
        Iterable iterable = this.iterableDataSource.getRows();
        Assert.assertNotSame(this.rows, (Object)iterable);
        Assert.assertEquals((long)0L, (long)this.iterationCounter.get());
        InlineDataSourceTest.assertRowsEqual(this.rows, (Iterable<Object[]>)ImmutableList.copyOf((Iterable)iterable));
        Assert.assertEquals((long)1L, (long)this.iterationCounter.get());
        ArrayList ignored = Lists.newArrayList((Iterable)iterable);
        Assert.assertEquals((long)2L, (long)this.iterationCounter.get());
    }

    @Test
    public void test_getRowsAsList_list() {
        Assert.assertSame(this.rows, (Object)this.listDataSource.getRowsAsList());
    }

    @Test
    public void test_getRowsAsList_iterable() {
        List list = this.iterableDataSource.getRowsAsList();
        Assert.assertEquals((long)1L, (long)this.iterationCounter.get());
        InlineDataSourceTest.assertRowsEqual(this.rows, list);
        ArrayList ignored = Lists.newArrayList((Iterable)list);
        Assert.assertEquals((long)1L, (long)this.iterationCounter.get());
    }

    @Test
    public void test_withChildren_empty() {
        Assert.assertSame((Object)this.listDataSource, (Object)this.listDataSource.withChildren(Collections.emptyList()));
    }

    @Test
    public void test_withChildren_nonEmpty() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Cannot accept children");
        this.listDataSource.withChildren((List)ImmutableList.of((Object)new TableDataSource("foo")));
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(InlineDataSource.class).usingGetClass().withNonnullFields(new String[]{"rows", "signature"}).verify();
    }

    @Test
    public void test_toString_iterable() {
        String ignored = this.iterableDataSource.toString();
        Assert.assertEquals((long)0L, (long)this.iterationCounter.get());
    }

    @Test
    public void test_serde_list() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        InlineDataSource deserialized = (InlineDataSource)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)this.listDataSource), DataSource.class);
        Assert.assertEquals((Object)this.listDataSource.getColumnNames(), (Object)deserialized.getColumnNames());
        Assert.assertEquals((Object)this.listDataSource.getColumnTypes(), (Object)deserialized.getColumnTypes());
        Assert.assertEquals((Object)this.listDataSource.getRowSignature(), (Object)deserialized.getRowSignature());
        InlineDataSourceTest.assertRowsEqual(this.listDataSource.getRows(), deserialized.getRows());
    }

    @Test
    public void test_serde_iterable() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        InlineDataSource deserialized = (InlineDataSource)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)this.iterableDataSource), DataSource.class);
        Assert.assertEquals((Object)this.listDataSource.getColumnNames(), (Object)deserialized.getColumnNames());
        Assert.assertEquals((Object)this.listDataSource.getColumnTypes(), (Object)deserialized.getColumnTypes());
        Assert.assertEquals((Object)this.listDataSource.getRowSignature(), (Object)deserialized.getRowSignature());
        InlineDataSourceTest.assertRowsEqual(this.listDataSource.getRows(), deserialized.getRows());
        Assert.assertEquals((long)1L, (long)this.iterationCounter.get());
    }

    @Test
    public void test_serde_untyped() throws Exception {
        RowSignature.Builder builder = RowSignature.builder();
        for (String columnName : this.expectedRowSignature.getColumnNames()) {
            builder.add(columnName, null);
        }
        RowSignature untypedSignature = builder.build();
        InlineDataSource untypedDataSource = InlineDataSource.fromIterable(this.rows, (RowSignature)untypedSignature);
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        InlineDataSource deserialized = (InlineDataSource)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)untypedDataSource), DataSource.class);
        Assert.assertEquals((Object)untypedDataSource.getColumnNames(), (Object)deserialized.getColumnNames());
        Assert.assertEquals((Object)untypedDataSource.getColumnTypes(), (Object)deserialized.getColumnTypes());
        Assert.assertEquals((Object)untypedDataSource.getRowSignature(), (Object)deserialized.getRowSignature());
        Assert.assertNull((Object)deserialized.getColumnTypes());
        InlineDataSourceTest.assertRowsEqual(this.listDataSource.getRows(), deserialized.getRows());
    }

    private static void assertRowsEqual(Iterable<Object[]> expectedRows, Iterable<Object[]> actualRows) {
        if (expectedRows instanceof List && actualRows instanceof List) {
            List expectedRowsList = (List)expectedRows;
            List actualRowsList = (List)actualRows;
            int sz = expectedRowsList.size();
            Assert.assertEquals((String)"number of rows", (long)sz, (long)actualRowsList.size());
            for (int i = 0; i < sz; ++i) {
                Assert.assertArrayEquals((String)("row #" + i), (Object[])((Object[])expectedRowsList.get(i)), (Object[])((Object[])actualRowsList.get(i)));
            }
        } else {
            Assert.assertEquals((String)"rows", expectedRows, actualRows);
        }
    }
}

