/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.segment.join.JoinType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class QueriesTest {
    @Test
    public void testVerifyAggregations() {
        List<AggregatorFactory> aggFactories = Arrays.asList(new CountAggregatorFactory("count"), new DoubleSumAggregatorFactory("idx", "index"), new DoubleSumAggregatorFactory("rev", "revenue"));
        List<ArithmeticPostAggregator> postAggs = Collections.singletonList(new ArithmeticPostAggregator("addStuff", "+", Arrays.asList(new FieldAccessPostAggregator("idx", "idx"), new FieldAccessPostAggregator("count", "count"))));
        boolean exceptionOccurred = false;
        try {
            Queries.prepareAggregations((List)ImmutableList.of(), aggFactories, postAggs);
        }
        catch (IllegalArgumentException e) {
            exceptionOccurred = true;
        }
        Assert.assertFalse((boolean)exceptionOccurred);
    }

    @Test
    public void testVerifyAggregationsMissingVal() {
        List<AggregatorFactory> aggFactories = Arrays.asList(new CountAggregatorFactory("count"), new DoubleSumAggregatorFactory("idx", "index"), new DoubleSumAggregatorFactory("rev", "revenue"));
        List<ArithmeticPostAggregator> postAggs = Collections.singletonList(new ArithmeticPostAggregator("addStuff", "+", Arrays.asList(new FieldAccessPostAggregator("idx", "idx2"), new FieldAccessPostAggregator("count", "count"))));
        boolean exceptionOccurred = false;
        try {
            Queries.prepareAggregations((List)ImmutableList.of(), aggFactories, postAggs);
        }
        catch (IllegalArgumentException e) {
            exceptionOccurred = true;
        }
        Assert.assertTrue((boolean)exceptionOccurred);
    }

    @Test
    public void testVerifyAggregationsMultiLevel() {
        List<AggregatorFactory> aggFactories = Arrays.asList(new CountAggregatorFactory("count"), new DoubleSumAggregatorFactory("idx", "index"), new DoubleSumAggregatorFactory("rev", "revenue"));
        List<PostAggregator> postAggs = Arrays.asList(new ArithmeticPostAggregator("divideStuff", "/", Arrays.asList(new ArithmeticPostAggregator("addStuff", "+", Arrays.asList(new FieldAccessPostAggregator("idx", "idx"), new ConstantPostAggregator("const", (Number)1))), new ArithmeticPostAggregator("subtractStuff", "-", Arrays.asList(new FieldAccessPostAggregator("rev", "rev"), new ConstantPostAggregator("const", (Number)1))))), new ArithmeticPostAggregator("addStuff", "+", Arrays.asList(new FieldAccessPostAggregator("divideStuff", "divideStuff"), new FieldAccessPostAggregator("count", "count"))));
        boolean exceptionOccurred = false;
        try {
            Queries.prepareAggregations((List)ImmutableList.of(), aggFactories, postAggs);
        }
        catch (IllegalArgumentException e) {
            exceptionOccurred = true;
        }
        Assert.assertFalse((boolean)exceptionOccurred);
    }

    @Test
    public void testVerifyAggregationsMultiLevelMissingVal() {
        List<AggregatorFactory> aggFactories = Arrays.asList(new CountAggregatorFactory("count"), new DoubleSumAggregatorFactory("idx", "index"), new DoubleSumAggregatorFactory("rev", "revenue"));
        List<PostAggregator> postAggs = Arrays.asList(new ArithmeticPostAggregator("divideStuff", "/", Arrays.asList(new ArithmeticPostAggregator("addStuff", "+", Arrays.asList(new FieldAccessPostAggregator("idx", "idx"), new ConstantPostAggregator("const", (Number)1))), new ArithmeticPostAggregator("subtractStuff", "-", Arrays.asList(new FieldAccessPostAggregator("rev", "rev2"), new ConstantPostAggregator("const", (Number)1))))), new ArithmeticPostAggregator("addStuff", "+", Arrays.asList(new FieldAccessPostAggregator("divideStuff", "divideStuff"), new FieldAccessPostAggregator("count", "count"))));
        boolean exceptionOccurred = false;
        try {
            Queries.prepareAggregations((List)ImmutableList.of(), aggFactories, postAggs);
        }
        catch (IllegalArgumentException e) {
            exceptionOccurred = true;
        }
        Assert.assertTrue((boolean)exceptionOccurred);
    }

    @Test
    public void testWithSpecificSegmentsBasic() {
        ImmutableList descriptors = ImmutableList.of((Object)new SegmentDescriptor(Intervals.of((String)"2000/3000"), "0", 0), (Object)new SegmentDescriptor(Intervals.of((String)"2000/3000"), "0", 1));
        Assert.assertEquals((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleSpecificSegmentSpec((List)ImmutableList.of((Object)new SegmentDescriptor(Intervals.of((String)"2000/3000"), "0", 0), (Object)new SegmentDescriptor(Intervals.of((String)"2000/3000"), "0", 1)))).granularity(Granularities.ALL).build(), (Object)Queries.withSpecificSegments((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals("2000/3000").granularity(Granularities.ALL).build(), (List)descriptors));
    }

    @Test
    public void testWithSpecificSegmentsSubQueryStack() {
        ImmutableList descriptors = ImmutableList.of((Object)new SegmentDescriptor(Intervals.of((String)"2000/3000"), "0", 0), (Object)new SegmentDescriptor(Intervals.of((String)"2000/3000"), "0", 1));
        Assert.assertEquals((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleSpecificSegmentSpec((List)descriptors)).granularity(Granularities.ALL).build())).intervals("2000/3000").granularity(Granularities.ALL).build())).intervals("2000/3000").granularity(Granularities.ALL).build(), (Object)Queries.withSpecificSegments((Query)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals("2000/3000").granularity(Granularities.ALL).build())).intervals("2000/3000").granularity(Granularities.ALL).build())).intervals("2000/3000").granularity(Granularities.ALL).build(), (List)descriptors));
    }

    @Test
    public void testWithSpecificSegmentsOnUnionIsAnError() {
        ImmutableList descriptors = ImmutableList.of((Object)new SegmentDescriptor(Intervals.of((String)"2000/3000"), "0", 0), (Object)new SegmentDescriptor(Intervals.of((String)"2000/3000"), "0", 1));
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new LookupDataSource("lookyloo")).intervals("2000/3000").granularity(Granularities.ALL).build();
        DruidException e = (DruidException)Assertions.assertThrows(DruidException.class, () -> Queries.withSpecificSegments((Query)query, (List)descriptors));
        Assert.assertEquals((Object)"Base dataSource[LookupDataSource{lookupName='lookyloo'}] is not a table!", (Object)e.getMessage());
    }

    @Test
    public void testWithBaseDataSourceBasic() {
        Assert.assertEquals((Object)Druids.newTimeseriesQueryBuilder().dataSource("bar").intervals("2000/3000").granularity(Granularities.ALL).build(), (Object)Queries.withBaseDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals("2000/3000").granularity(Granularities.ALL).build(), (DataSource)new TableDataSource("bar")));
    }

    @Test
    public void testWithBaseDataSourceSubQueryStack() {
        Assert.assertEquals((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("bar").intervals("2000/3000").granularity(Granularities.ALL).build())).intervals("2000/3000").granularity(Granularities.ALL).build())).intervals("2000/3000").granularity(Granularities.ALL).build(), (Object)Queries.withBaseDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals("2000/3000").granularity(Granularities.ALL).build())).intervals("2000/3000").granularity(Granularities.ALL).build())).intervals("2000/3000").granularity(Granularities.ALL).build(), (DataSource)new TableDataSource("bar")));
    }

    @Test
    public void testWithBaseDataSourceSubQueryStackWithJoinOnUnion() {
        Assert.assertEquals((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)JoinDataSource.create((DataSource)new TableDataSource("foo"), (DataSource)new TableDataSource("bar"), (String)"j0.", (String)"\"foo.x\" == \"bar.x\"", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST)).intervals("2000/3000").granularity(Granularities.ALL).build())).intervals("2000/3000").granularity(Granularities.ALL).build())).intervals("2000/3000").granularity(Granularities.ALL).build(), (Object)Queries.withBaseDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)JoinDataSource.create((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("bar"))), (DataSource)new TableDataSource("bar"), (String)"j0.", (String)"\"foo.x\" == \"bar.x\"", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST)).intervals("2000/3000").granularity(Granularities.ALL).build())).intervals("2000/3000").granularity(Granularities.ALL).build())).intervals("2000/3000").granularity(Granularities.ALL).build(), (DataSource)new TableDataSource("foo")));
    }

    @Test
    public void testWithBaseDataSourcedBaseFilterWithMultiJoin() {
        Assert.assertEquals((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)JoinDataSource.create((DataSource)JoinDataSource.create((DataSource)new TableDataSource("foo"), (DataSource)new TableDataSource("bar"), (String)"j1.", (String)"\"foo.x\" == \"bar.x\"", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST), (DataSource)new TableDataSource("foo_outer"), (String)"j0.", (String)"\"foo_outer.x\" == \"bar.x\"", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST)).intervals("2000/3000").granularity(Granularities.ALL).build())).intervals("2000/3000").granularity(Granularities.ALL).build(), (Object)Queries.withBaseDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)JoinDataSource.create((DataSource)JoinDataSource.create((DataSource)new TableDataSource("foo_inner"), (DataSource)new TableDataSource("bar"), (String)"j1.", (String)"\"foo.x\" == \"bar.x\"", (JoinType)JoinType.INNER, (DimFilter)TrueDimFilter.instance(), (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST), (DataSource)new TableDataSource("foo_outer"), (String)"j0.", (String)"\"foo_outer.x\" == \"bar.x\"", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST)).intervals("2000/3000").granularity(Granularities.ALL).build())).intervals("2000/3000").granularity(Granularities.ALL).build(), (DataSource)new TableDataSource("foo")));
    }
}

