/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.util.Comparator;
import org.apache.druid.query.aggregation.DoubleSumAggregator;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.TestDoubleColumnSelectorImpl;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.junit.Assert;
import org.junit.Test;

public class DoubleSumAggregatorTest {
    private void aggregate(TestDoubleColumnSelectorImpl selector, DoubleSumAggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    @Test
    public void testAggregate() {
        double[] values = new double[]{0.15, 0.27};
        TestDoubleColumnSelectorImpl selector = new TestDoubleColumnSelectorImpl(values);
        DoubleSumAggregator agg = new DoubleSumAggregator((BaseDoubleColumnValueSelector)selector);
        double expectedFirst = new Double(values[0]);
        double expectedSecond = new Double(values[1]) + expectedFirst;
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        this.aggregate(selector, agg);
        Assert.assertEquals((Object)expectedFirst, (Object)agg.get());
        Assert.assertEquals((Object)expectedFirst, (Object)agg.get());
        Assert.assertEquals((Object)expectedFirst, (Object)agg.get());
        this.aggregate(selector, agg);
        Assert.assertEquals((Object)expectedSecond, (Object)agg.get());
        Assert.assertEquals((Object)expectedSecond, (Object)agg.get());
        Assert.assertEquals((Object)expectedSecond, (Object)agg.get());
    }

    @Test
    public void testComparator() {
        TestDoubleColumnSelectorImpl selector = new TestDoubleColumnSelectorImpl(new double[]{0.15, 0.27});
        DoubleSumAggregator agg = new DoubleSumAggregator((BaseDoubleColumnValueSelector)selector);
        Object first = agg.get();
        agg.aggregate();
        Comparator comp = new DoubleSumAggregatorFactory("null", "null").getComparator();
        Assert.assertEquals((long)-1L, (long)comp.compare(first, agg.get()));
        Assert.assertEquals((long)0L, (long)comp.compare(first, first));
        Assert.assertEquals((long)0L, (long)comp.compare(agg.get(), agg.get()));
        Assert.assertEquals((long)1L, (long)comp.compare(agg.get(), first));
    }
}

