/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AbstractSerializablePairLongObjectBufferStore;
import org.apache.druid.query.aggregation.AbstractSerializablePairLongObjectColumnHeader;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.SerializablePairLongStringBufferStore;
import org.apache.druid.query.aggregation.SerializablePairLongStringColumnHeader;
import org.apache.druid.query.aggregation.SerializablePairLongStringComplexColumn;
import org.apache.druid.query.aggregation.SerializablePairLongStringComplexMetricSerde;
import org.apache.druid.query.aggregation.SerializablePairLongStringSimpleStagedSerde;
import org.apache.druid.query.aggregation.SerializedStorage;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.IOIterator;
import org.apache.druid.segment.serde.cell.NativeClearedByteBufferProvider;
import org.apache.druid.segment.serde.cell.StagedSerde;
import org.apache.druid.segment.writeout.HeapByteBufferWriteOutBytes;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SerializablePairLongStringBufferStoreTest {
    private final Random random = new Random(0L);
    private static final int MIN_INTEGER = 100;
    private static final long MIN_LONG = 0L;
    private final SerializablePairLongString[] integerRangeArr = new SerializablePairLongString[]{new SerializablePairLongString(Long.valueOf(100L), "fuu"), new SerializablePairLongString(Long.valueOf(101L), "bar"), new SerializablePairLongString(Long.valueOf(102L), "baz")};
    private final SerializablePairLongString[] longRangeArr = new SerializablePairLongString[]{new SerializablePairLongString(Long.valueOf(0L), "fuu"), new SerializablePairLongString(Long.valueOf(100L), "bar"), new SerializablePairLongString(Long.valueOf(Integer.MAX_VALUE), "baz"), new SerializablePairLongString(Long.valueOf(Long.MAX_VALUE), "fuubarbaz")};
    private final SegmentWriteOutMedium writeOutMedium = new OnHeapMemorySegmentWriteOutMedium();
    private SerializablePairLongStringBufferStore bufferStore;

    @Before
    public void setup() throws Exception {
        this.bufferStore = new SerializablePairLongStringBufferStore(new SerializedStorage(this.writeOutMedium.makeWriteOutBytes(), (StagedSerde)new SerializablePairLongStringSimpleStagedSerde()));
    }

    @Test
    public void testIteratorSimple() throws Exception {
        for (SerializablePairLongString value : this.integerRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        IOIterator iterator = this.bufferStore.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals((Object)this.integerRangeArr[i], (Object)iterator.next());
            ++i;
        }
    }

    @Test
    public void testIteratorEmptyBuffer() throws Exception {
        IOIterator iterator = this.bufferStore.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorNull() throws Exception {
        this.bufferStore.store(null);
        IOIterator iterator = this.bufferStore.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNull((Object)iterator.next());
    }

    @Test
    public void testIteratorIdempotentHasNext() throws Exception {
        this.bufferStore.store((SerializablePair)this.integerRangeArr[0]);
        IOIterator iterator = this.bufferStore.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
    }

    @Test(expected=NoSuchElementException.class)
    public void testIteratorEmptyThrows() throws Exception {
        IOIterator iterator = this.bufferStore.iterator();
        iterator.next();
    }

    @Test
    public void testIteratorEmptyHasNext() throws Exception {
        IOIterator iterator = this.bufferStore.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testMinValueUsesInteger() throws Exception {
        for (SerializablePairLongString value : this.integerRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        SerializablePairLongStringColumnHeader columnHeader = (SerializablePairLongStringColumnHeader)this.bufferStore.createColumnHeader();
        Assert.assertEquals((long)((Long)this.integerRangeArr[0].lhs), (long)columnHeader.getMinValue());
        Assert.assertTrue((boolean)columnHeader.isUseIntegerDeltas());
    }

    @Test
    public void testMinValueUsesLong() throws Exception {
        for (SerializablePairLongString value : this.longRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        SerializablePairLongStringColumnHeader columnHeader = (SerializablePairLongStringColumnHeader)this.bufferStore.createColumnHeader();
        Assert.assertEquals((long)0L, (long)columnHeader.getMinValue());
        Assert.assertFalse((boolean)columnHeader.isUseIntegerDeltas());
    }

    @Test
    public void testMinValueUsesIntegerSerialization() throws Exception {
        for (SerializablePairLongString value : this.integerRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        SerializablePairLongStringColumnHeader columnHeader = (SerializablePairLongStringColumnHeader)this.bufferStore.createColumnHeader();
        HeapByteBufferWriteOutBytes channel = new HeapByteBufferWriteOutBytes();
        try (ResourceHolder resourceHolder = NativeClearedByteBufferProvider.INSTANCE.get();){
            columnHeader.transferTo((WritableByteChannel)channel);
            ByteBuffer byteBuffer = (ByteBuffer)resourceHolder.get();
            channel.writeTo(byteBuffer);
            byteBuffer.flip();
            SerializablePairLongStringColumnHeader deserializedColumnhHeader = (SerializablePairLongStringColumnHeader)AbstractSerializablePairLongObjectColumnHeader.fromBuffer((ByteBuffer)byteBuffer, SerializablePairLongString.class);
            Assert.assertEquals((long)100L, (long)deserializedColumnhHeader.getMinValue());
            Assert.assertTrue((boolean)deserializedColumnhHeader.isUseIntegerDeltas());
        }
    }

    @Test
    public void testMinValueSerialization() throws Exception {
        for (SerializablePairLongString value : this.longRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        SerializablePairLongStringColumnHeader columnHeader = (SerializablePairLongStringColumnHeader)this.bufferStore.createColumnHeader();
        HeapByteBufferWriteOutBytes channel = new HeapByteBufferWriteOutBytes();
        try (ResourceHolder resourceHolder = NativeClearedByteBufferProvider.INSTANCE.get();){
            columnHeader.transferTo((WritableByteChannel)channel);
            ByteBuffer byteBuffer = (ByteBuffer)resourceHolder.get();
            channel.writeTo(byteBuffer);
            byteBuffer.flip();
            SerializablePairLongStringColumnHeader deserializedColumnhHeader = (SerializablePairLongStringColumnHeader)AbstractSerializablePairLongObjectColumnHeader.fromBuffer((ByteBuffer)byteBuffer, SerializablePairLongString.class);
            Assert.assertEquals((long)0L, (long)deserializedColumnhHeader.getMinValue());
            Assert.assertFalse((boolean)deserializedColumnhHeader.isUseIntegerDeltas());
        }
    }

    @Test
    public void testVariedSize() throws Exception {
        int rowCount = 100;
        int maxStringSize = 0x100000;
        int minStringSize = 1024;
        ArrayList<SerializablePairLongString> input = new ArrayList<SerializablePairLongString>(rowCount);
        int totalCount = 0;
        for (int i = 0; i < rowCount; ++i) {
            long longValue = this.random.nextLong();
            SerializablePairLongString value = new SerializablePairLongString(Long.valueOf(longValue), RandomStringUtils.randomAlphabetic((int)minStringSize, (int)maxStringSize));
            input.add(value);
            totalCount = (int)((long)totalCount + longValue);
            totalCount = Math.max(totalCount, 0);
            this.bufferStore.store((SerializablePair)value);
        }
        IOIterator iterator = this.bufferStore.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals(input.get(i), (Object)iterator.next());
            ++i;
        }
    }

    @Test
    public void testLargeBuffer() throws Exception {
        int stringSize = 131072;
        SerializablePairLongString value = new SerializablePairLongString(Long.valueOf(Long.MAX_VALUE), RandomStringUtils.randomAlphabetic((int)stringSize));
        this.bufferStore.store((SerializablePair)value);
        IOIterator iterator = this.bufferStore.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)value, (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testLargeValueCount() throws Exception {
        ArrayList<SerializablePairLongString> valueList = new ArrayList<SerializablePairLongString>();
        for (int i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongString(Long.valueOf(Integer.MAX_VALUE + (long)i), "the same string"));
        }
        this.assertBufferedValuesEqual(valueList);
    }

    @Test
    public void testOverflowTransfer() throws Exception {
        this.bufferStore.store((SerializablePair)new SerializablePairLongString(Long.valueOf(Long.MIN_VALUE), "fuu"));
        this.bufferStore.store((SerializablePair)new SerializablePairLongString(Long.valueOf(Long.MAX_VALUE), "fuu"));
        SerializablePairLongStringColumnHeader columnHeader = (SerializablePairLongStringColumnHeader)this.bufferStore.createColumnHeader();
        Assert.assertEquals((long)0L, (long)columnHeader.getMinValue());
        AbstractSerializablePairLongObjectBufferStore.TransferredBuffer transferredBuffer = this.bufferStore.transferToRowWriter((ByteBufferProvider)NativeClearedByteBufferProvider.INSTANCE, this.writeOutMedium);
        Assert.assertEquals((long)94L, (long)transferredBuffer.getSerializedSize());
    }

    @Test
    public void testNullOnlyTransfer() throws Exception {
        this.bufferStore.store(null);
        this.bufferStore.store(null);
        this.bufferStore.store(null);
        SerializablePairLongStringColumnHeader columnHeader = (SerializablePairLongStringColumnHeader)this.bufferStore.createColumnHeader();
        Assert.assertEquals((long)0L, (long)columnHeader.getMinValue());
        AbstractSerializablePairLongObjectBufferStore.TransferredBuffer transferredBuffer = this.bufferStore.transferToRowWriter((ByteBufferProvider)NativeClearedByteBufferProvider.INSTANCE, this.writeOutMedium);
        Assert.assertEquals((long)59L, (long)transferredBuffer.getSerializedSize());
    }

    @Test
    public void testTransferIntegerRange() throws Exception {
        for (SerializablePairLongString value : this.integerRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        Assert.assertTrue((boolean)this.bufferStore.createColumnHeader().isUseIntegerDeltas());
        this.assertTransferredValuesEqual(this.integerRangeArr);
    }

    @Test
    public void testTransferLongRange() throws Exception {
        for (SerializablePairLongString value : this.longRangeArr) {
            this.bufferStore.store((SerializablePair)value);
        }
        Assert.assertFalse((boolean)this.bufferStore.createColumnHeader().isUseIntegerDeltas());
        this.assertTransferredValuesEqual(this.longRangeArr);
    }

    private void assertBufferedValuesEqual(List<SerializablePairLongString> input) throws IOException {
        for (SerializablePairLongString pairLongString : input) {
            this.bufferStore.store((SerializablePair)pairLongString);
        }
        IOIterator iterator = this.bufferStore.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals((Object)input.get(i), (Object)iterator.next());
            ++i;
        }
        Assert.assertEquals((String)StringUtils.format((String)"element count mismatch: expected %s, got %s", (Object[])new Object[]{input.size(), i}), (long)input.size(), (long)i);
    }

    private void assertTransferredValuesEqual(SerializablePairLongString[] input) throws IOException {
        AbstractSerializablePairLongObjectBufferStore.TransferredBuffer transferredBuffer = this.bufferStore.transferToRowWriter((ByteBufferProvider)NativeClearedByteBufferProvider.INSTANCE, this.writeOutMedium);
        HeapByteBufferWriteOutBytes resultChannel = new HeapByteBufferWriteOutBytes();
        transferredBuffer.writeTo((WritableByteChannel)resultChannel, null);
        try (SerializablePairLongStringComplexColumn column = SerializablePairLongStringBufferStoreTest.createComplexColumn(transferredBuffer, resultChannel);){
            for (int i = 0; i < input.length; ++i) {
                Assert.assertEquals((Object)input[i], (Object)column.getRowValue(i));
            }
        }
    }

    private static SerializablePairLongStringComplexColumn createComplexColumn(AbstractSerializablePairLongObjectBufferStore.TransferredBuffer transferredBuffer, HeapByteBufferWriteOutBytes resultChannel) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(Ints.checkedCast((long)transferredBuffer.getSerializedSize()));
        resultChannel.readFully(0L, byteBuffer);
        byteBuffer.flip();
        SerializablePairLongStringComplexMetricSerde complexMetricSerde = new SerializablePairLongStringComplexMetricSerde();
        ColumnBuilder builder = new ColumnBuilder();
        complexMetricSerde.deserializeColumn(byteBuffer, builder);
        builder.setType(ValueType.COMPLEX);
        ColumnHolder columnHolder = builder.build();
        SerializablePairLongStringComplexColumn column = (SerializablePairLongStringComplexColumn)columnHolder.getColumn();
        return column;
    }
}

