/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ExprMacroTest {
    private static final String IPV4_STRING = "192.168.0.1";
    private static final long IPV4_LONG = 3232235521L;
    private static final Expr.ObjectBinding BINDINGS = InputBindings.forInputSuppliers((Map)ImmutableMap.builder().put((Object)"t", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.LONG, () -> DateTimes.of((String)"2000-02-03T04:05:06").getMillis())).put((Object)"t1", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.LONG, () -> DateTimes.of((String)"2000-02-03T00:00:00").getMillis())).put((Object)"tstr", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "2000-02-03T04:05:06")).put((Object)"tstr_sql", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "2000-02-03 04:05:06")).put((Object)"x", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "foo")).put((Object)"y", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.LONG, () -> 2)).put((Object)"z", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.DOUBLE, () -> 3.1)).put((Object)"CityOfAngels", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "America/Los_Angeles")).put((Object)"spacey", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "  hey there  ")).put((Object)"ipv4_string", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "192.168.0.1")).put((Object)"ipv4_long", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.LONG, () -> 3232235521L)).put((Object)"ipv4_network", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "192.168.0.0")).put((Object)"ipv4_broadcast", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "192.168.255.255")).build());
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testLike() {
        this.assertExpr("like(x, 'f%')", 1L);
        this.assertExpr("like(x, 'f__')", 1L);
        this.assertExpr("like(x, '%o%')", 1L);
        this.assertExpr("like(x, 'b%')", 0L);
        this.assertExpr("like(x, 'b__')", 0L);
        this.assertExpr("like(x, '%x%')", 0L);
        this.assertExpr("like(x, '')", 0L);
    }

    @Test
    public void testRegexpExtract() {
        this.assertExpr("regexp_extract(x, 'f(.)')", "fo");
        this.assertExpr("regexp_extract(x, 'f(.)', 0)", "fo");
        this.assertExpr("regexp_extract(x, 'f(.)', 1)", "o");
    }

    @Test
    public void testTimestampCeil() {
        this.assertExpr("timestamp_ceil(null, 'P1M')", null);
        this.assertExpr("timestamp_ceil(t, 'P1M')", DateTimes.of((String)"2000-03-01").getMillis());
        this.assertExpr("timestamp_ceil(t, 'P1D',null,'America/Los_Angeles')", DateTimes.of((String)"2000-02-03T08").getMillis());
        this.assertExpr("timestamp_ceil(t, 'P1D',null,CityOfAngels)", DateTimes.of((String)"2000-02-03T08").getMillis());
        this.assertExpr("timestamp_ceil(t, 'P1D','1970-01-01T01','Etc/UTC')", DateTimes.of((String)"2000-02-04T01").getMillis());
        this.assertExpr("timestamp_ceil(t1, 'P1D')", DateTimes.of((String)"2000-02-03").getMillis());
    }

    @Test
    public void testTimestampFloor() {
        this.assertExpr("timestamp_floor(null, 'P1M')", null);
        this.assertExpr("timestamp_floor(t, 'P1M')", DateTimes.of((String)"2000-02-01").getMillis());
        this.assertExpr("timestamp_floor(t, 'P1D',null,'America/Los_Angeles')", DateTimes.of((String)"2000-02-02T08").getMillis());
        this.assertExpr("timestamp_floor(t, 'P1D',null,CityOfAngels)", DateTimes.of((String)"2000-02-02T08").getMillis());
        this.assertExpr("timestamp_floor(t, 'P1D','1970-01-01T01','Etc/UTC')", DateTimes.of((String)"2000-02-03T01").getMillis());
    }

    @Test
    public void testTimestampShift() {
        this.assertExpr("timestamp_shift(t, 'P1D', 2)", DateTimes.of((String)"2000-02-05T04:05:06").getMillis());
        this.assertExpr("timestamp_shift(t, 'P1D', 2, 'America/Los_Angeles')", DateTimes.of((String)"2000-02-05T04:05:06").getMillis());
        this.assertExpr("timestamp_shift(t, 'P1D', 2, CityOfAngels)", DateTimes.of((String)"2000-02-05T04:05:06").getMillis());
        this.assertExpr("timestamp_shift(t, 'P1D', 2, '-08:00')", DateTimes.of((String)"2000-02-05T04:05:06").getMillis());
        this.assertExpr("timestamp_shift(t, 'P1D', 2, '')", DateTimes.of((String)"2000-02-05T04:05:06").getMillis());
    }

    @Test
    public void testTimestampExtract() {
        this.assertExpr("timestamp_extract(t, 'DAY')", 3L);
        this.assertExpr("timestamp_extract(t, 'HOUR')", 4L);
        this.assertExpr("timestamp_extract(t, 'DAY', 'America/Los_Angeles')", 2L);
        this.assertExpr("timestamp_extract(t, 'HOUR', 'America/Los_Angeles')", 20L);
    }

    @Test
    public void testTimestampParse() {
        this.assertExpr("timestamp_parse(tstr)", DateTimes.of((String)"2000-02-03T04:05:06").getMillis());
        this.assertExpr("timestamp_parse(tstr_sql)", DateTimes.of((String)"2000-02-03T04:05:06").getMillis());
        this.assertExpr("timestamp_parse(tstr_sql,null,'America/Los_Angeles')", DateTimes.of((String)"2000-02-03T04:05:06-08:00").getMillis());
        this.assertExpr("timestamp_parse('2000-02-03')", DateTimes.of((String)"2000-02-03").getMillis());
        this.assertExpr("timestamp_parse('2000-02')", DateTimes.of((String)"2000-02-01").getMillis());
        this.assertExpr("timestamp_parse(null)", null);
        this.assertExpr("timestamp_parse('z2000')", null);
        this.assertExpr("timestamp_parse(tstr_sql,'yyyy-MM-dd HH:mm:ss')", DateTimes.of((String)"2000-02-03T04:05:06").getMillis());
        this.assertExpr("timestamp_parse('02/03/2000','MM/dd/yyyy')", DateTimes.of((String)"2000-02-03").getMillis());
        this.assertExpr("timestamp_parse(tstr_sql,'yyyy-MM-dd HH:mm:ss','America/Los_Angeles')", DateTimes.of((String)"2000-02-03T04:05:06-08:00").getMillis());
    }

    @Test
    public void testTimestampFormat() {
        this.assertExpr("timestamp_format(t)", "2000-02-03T04:05:06.000Z");
        this.assertExpr("timestamp_format(t,'yyyy-MM-dd HH:mm:ss')", "2000-02-03 04:05:06");
        this.assertExpr("timestamp_format(t,'yyyy-MM-dd HH:mm:ss','America/Los_Angeles')", "2000-02-02 20:05:06");
    }

    @Test
    public void testTrim() {
        String emptyString = "";
        this.assertExpr("trim('')", emptyString);
        this.assertExpr("trim(concat(' ',x,' '))", "foo");
        this.assertExpr("trim(spacey)", "hey there");
        this.assertExpr("trim(spacey, '')", "  hey there  ");
        this.assertExpr("trim(spacey, 'he ')", "y ther");
        this.assertExpr("trim(spacey, spacey)", emptyString);
        this.assertExpr("trim(spacey, substring(spacey, 0, 4))", "y ther");
    }

    @Test
    public void testLTrim() {
        String emptyString = "";
        this.assertExpr("ltrim('')", emptyString);
        this.assertExpr("ltrim(concat(' ',x,' '))", "foo ");
        this.assertExpr("ltrim(spacey)", "hey there  ");
        this.assertExpr("ltrim(spacey, '')", "  hey there  ");
        this.assertExpr("ltrim(spacey, 'he ')", "y there  ");
        this.assertExpr("ltrim(spacey, spacey)", emptyString);
        this.assertExpr("ltrim(spacey, substring(spacey, 0, 4))", "y there  ");
    }

    @Test
    public void testRTrim() {
        String emptyString = "";
        this.assertExpr("rtrim('')", emptyString);
        this.assertExpr("rtrim(concat(' ',x,' '))", " foo");
        this.assertExpr("rtrim(spacey)", "  hey there");
        this.assertExpr("rtrim(spacey, '')", "  hey there  ");
        this.assertExpr("rtrim(spacey, 'he ')", "  hey ther");
        this.assertExpr("rtrim(spacey, spacey)", emptyString);
        this.assertExpr("rtrim(spacey, substring(spacey, 0, 4))", "  hey ther");
    }

    @Test
    public void testIPv4AddressParse() {
        this.assertExpr("ipv4_parse(x)", null);
        this.assertExpr("ipv4_parse(ipv4_string)", 3232235521L);
        this.assertExpr("ipv4_parse(ipv4_long)", 3232235521L);
        this.assertExpr("ipv4_parse(ipv4_stringify(ipv4_long))", 3232235521L);
    }

    @Test
    public void testIPv4AddressStringify() {
        this.assertExpr("ipv4_stringify(x)", null);
        this.assertExpr("ipv4_stringify(ipv4_long)", IPV4_STRING);
        this.assertExpr("ipv4_stringify(ipv4_string)", IPV4_STRING);
        this.assertExpr("ipv4_stringify(ipv4_parse(ipv4_string))", IPV4_STRING);
    }

    @Test
    public void testIPv4AddressMatch() {
        this.assertExpr("ipv4_match(ipv4_string,    '10.0.0.0/8')", 0L);
        this.assertExpr("ipv4_match(ipv4_string,    '192.168.0.0/16')", 1L);
        this.assertExpr("ipv4_match(ipv4_network,   '192.168.0.0/16')", 1L);
        this.assertExpr("ipv4_match(ipv4_broadcast, '192.168.0.0/16')", 1L);
    }

    private void assertExpr(String expression, Object expectedResult) {
        Expr expr = Parser.parse((String)expression, (ExprMacroTable)TestExprMacroTable.INSTANCE);
        Assert.assertEquals((String)expression, (Object)expectedResult, (Object)expr.eval(BINDINGS).value());
        Expr exprNotFlattened = Parser.parse((String)expression, (ExprMacroTable)TestExprMacroTable.INSTANCE, (boolean)false);
        Expr roundTripNotFlattened = Parser.parse((String)exprNotFlattened.stringify(), (ExprMacroTable)TestExprMacroTable.INSTANCE);
        Assert.assertEquals((String)exprNotFlattened.stringify(), (Object)expectedResult, (Object)roundTripNotFlattened.eval(BINDINGS).value());
        Expr roundTrip = Parser.parse((String)expr.stringify(), (ExprMacroTable)TestExprMacroTable.INSTANCE);
        Assert.assertEquals((String)exprNotFlattened.stringify(), (Object)expectedResult, (Object)roundTrip.eval(BINDINGS).value());
    }
}

