/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.NestedDataTestUtils;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NestedDataGroupByQueryTest
extends InitializedNullHandlingTest {
    private static final Logger LOG = new Logger(NestedDataGroupByQueryTest.class);
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final Closer closer;
    private final QueryContexts.Vectorize vectorize;
    private final AggregationTestHelper helper;
    private final BiFunction<TemporaryFolder, Closer, List<Segment>> segmentsGenerator;
    private final String segmentsName;

    public NestedDataGroupByQueryTest(GroupByQueryConfig config, BiFunction<TemporaryFolder, Closer, List<Segment>> segmentGenerator, String vectorize) {
        BuiltInTypesModule.registerHandlersAndSerde();
        this.vectorize = QueryContexts.Vectorize.fromString((String)vectorize);
        this.helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(BuiltInTypesModule.getJacksonModulesList(), config, this.tempFolder);
        this.segmentsGenerator = segmentGenerator;
        this.segmentsName = segmentGenerator.toString();
        this.closer = Closer.create();
    }

    public Map<String, Object> getContext() {
        return ImmutableMap.of((Object)"vectorize", (Object)this.vectorize.toString(), (Object)"vectorizeVirtualColumns", (Object)this.vectorize.toString());
    }

    @Parameterized.Parameters(name="config = {0}, segments = {1}, vectorize = {2}")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        List<BiFunction<TemporaryFolder, Closer, List<Segment>>> segmentsGenerators = NestedDataTestUtils.getSegmentGenerators("nested-simple-test-data.json");
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            for (BiFunction<TemporaryFolder, Closer, List<Segment>> generatorFn : segmentsGenerators) {
                for (String vectorize : new String[]{"false", "true", "force"}) {
                    constructors.add(new Object[]{config, generatorFn, vectorize});
                }
            }
        }
        return constructors;
    }

    @Before
    public void setup() {
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testGroupBySomeField() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 8L}, (Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 2L}, (Object)new Object[]{"300", 4L}));
    }

    @Test
    public void testGroupByRegularColumns() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0"), DefaultDimensionSpec.of((String)"v1"), new DefaultDimensionSpec("v2", "v2", ColumnType.LONG), new DefaultDimensionSpec("v3", "v3", ColumnType.LONG), new DefaultDimensionSpec("v4", "v4", ColumnType.STRING), new DefaultDimensionSpec("v5", "v5", ColumnType.LONG)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("dim", "$", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("dim", "$.x", "v1", ColumnType.STRING), new NestedFieldVirtualColumn("dim", "$", "v2", ColumnType.LONG), new NestedFieldVirtualColumn("count", "$", "v3", ColumnType.LONG), new NestedFieldVirtualColumn("count", "$", "v4", ColumnType.STRING), new NestedFieldVirtualColumn("count", "$.x", "v5", ColumnType.LONG)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", null, 100L, 1L, "1", null, 2L}, (Object)new Object[]{"hello", null, null, 1L, "1", null, 12L}, (Object)new Object[]{"world", null, null, 1L, "1", null, 2L}));
    }

    @Test
    public void testGroupBySomeFieldWithFilter() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(null);
        vals.add("100");
        vals.add("200");
        vals.add("300");
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).setDimFilter((DimFilter)new InDimFilter("v0", vals, null)).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 8L}, (Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 2L}, (Object)new Object[]{"300", 4L}));
    }

    @Test
    public void testGroupByNoFieldWithFilter() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(null);
        vals.add("100");
        vals.add("200");
        vals.add("300");
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.fake", "v0", ColumnType.STRING)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).setDimFilter((DimFilter)new InDimFilter("v0", vals, null)).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 16L}));
    }

    @Test
    public void testGroupBySomeFieldWithNonExistentAgg() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(null);
        vals.add("100");
        vals.add("200");
        vals.add("300");
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.nope", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.fake", "v2", ColumnType.DOUBLE)}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v2")}).setDimFilter((DimFilter)new InDimFilter("v1", vals, null)).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, null}));
    }

    @Test
    public void testGroupByNonExistentVirtualColumn() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v1")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("fake", "$.fake", "v0", ColumnType.STRING), new ExpressionVirtualColumn("v1", "concat(v0, 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 16L}));
    }

    @Test
    public void testGroupByNonExistentFilterAsString() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.fake", "v0", ColumnType.STRING)}).setDimFilter((DimFilter)new SelectorDimFilter("v0", "1", null)).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, Collections.emptyList());
    }

    @Test
    public void testGroupByNonExistentFilterAsNumeric() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.fake", "v0", ColumnType.LONG)}).setDimFilter((DimFilter)new SelectorDimFilter("v0", "1", null)).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, Collections.emptyList());
    }

    @Test
    public void testGroupBySomeFieldOnStringColumn() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0"), DefaultDimensionSpec.of((String)"v1")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("dim", "$", "v0"), new NestedFieldVirtualColumn("dim", "$.x", "v1")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", null, 2L}, (Object)new Object[]{"hello", null, 12L}, (Object)new Object[]{"world", null, 2L}));
    }

    @Test
    public void testGroupBySomeFieldOnStringColumnWithFilter() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("100");
        vals.add("200");
        vals.add("300");
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("dim", "$", "v0")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).setDimFilter((DimFilter)new InDimFilter("v0", vals, null)).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}));
    }

    @Test
    public void testGroupBySomeFieldOnStringColumnWithFilterExpectedTypeLong() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("100");
        vals.add("200");
        vals.add("300");
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.LONG)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("dim", "$", "v0", ColumnType.LONG)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).setDimFilter((DimFilter)new InDimFilter("v0", vals, null)).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{100L, 2L}));
    }

    @Test
    public void testGroupBySomeFieldOnNestedStringColumnWithFilterExpectedTypeLong() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.LONG)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nester", "$.y.a", "v0", ColumnType.LONG)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).setDimFilter((DimFilter)new SelectorDimFilter("v0", "100", null)).build();
        this.runResults(groupQuery, Collections.emptyList());
    }

    @Test
    public void testGroupBySomeFieldOnStringColumnWithFilterExpectedTypeDouble() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("100");
        vals.add("200");
        vals.add("300");
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.DOUBLE)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("dim", "$", "v0", ColumnType.LONG)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).setDimFilter((DimFilter)new InDimFilter("v0", vals, null)).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{100.0, 2L}));
    }

    @Test
    public void testGroupBySomeFieldOnStringColumnWithFilterExpectedTypeFloat() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("100");
        vals.add("200");
        vals.add("300");
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.FLOAT)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("dim", "$", "v0", ColumnType.LONG)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).setDimFilter((DimFilter)new InDimFilter("v0", vals, null)).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(100.0f), 2L}));
    }

    @Test
    public void testGroupBySomeFieldOnStringColumnWithFilterNil() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("100");
        vals.add("200");
        vals.add("300");
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("dim", "$.x", "v0")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).setDimFilter((DimFilter)new InDimFilter("v0", vals, null)).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testGroupBySomeFieldOnLongColumn() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.LONG), DefaultDimensionSpec.of((String)"v1", (ColumnType)ColumnType.LONG)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("__time", "$", "v0"), new NestedFieldVirtualColumn("__time", "$.x", "v1")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{1672531200000L, null, 8L}, (Object)new Object[]{1672617600000L, null, 8L}));
    }

    @Test
    public void testGroupBySomeFieldOnLongColumnFilter() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.LONG)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("__time", "$", "v0")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setDimFilter((DimFilter)new SelectorDimFilter("v0", "1672531200000", null)).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{1672531200000L, 8L}));
    }

    @Test
    public void testGroupBySomeFieldOnLongColumnFilterExpectedType() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.STRING)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("__time", "$", "v0", ColumnType.STRING)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setDimFilter((DimFilter)new SelectorDimFilter("v0", "1672531200000", null)).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{"1672531200000", 8L}));
    }

    @Test
    public void testGroupBySomeFieldOnLongColumnFilterNil() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.LONG)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("__time", "$.x", "v0")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setDimFilter((DimFilter)new SelectorDimFilter("v0", "1609459200000", null)).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testGroupByRootAuto() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"dim")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}, (Object)new Object[]{"hello", 12L}, (Object)new Object[]{"world", 2L}));
    }

    private void runResults(GroupByQuery groupQuery, List<Object[]> expectedResults) {
        List<Segment> segments = this.segmentsGenerator.apply(this.tempFolder, this.closer);
        Supplier<List> runner = () -> this.helper.runQueryOnSegmentsObjs(segments, groupQuery).toList();
        CursorBuildSpec spec = GroupingEngine.makeCursorBuildSpec((GroupByQuery)groupQuery, null);
        boolean allCanVectorize = segments.stream().allMatch(s -> {
            CursorHolder cursorHolder = s.asCursorFactory().makeCursorHolder(spec);
            boolean canVectorize = cursorHolder.canVectorize();
            cursorHolder.close();
            return canVectorize;
        });
        if (!allCanVectorize && this.vectorize == QueryContexts.Vectorize.FORCE) {
            Throwable t = Assert.assertThrows(RuntimeException.class, runner::get);
            Assert.assertEquals((Object)"java.util.concurrent.ExecutionException: java.lang.RuntimeException: org.apache.druid.java.util.common.ISE: Cannot vectorize!", (Object)t.getMessage());
            return;
        }
        List results = runner.get();
        NestedDataGroupByQueryTest.verifyResults(groupQuery.getResultRowSignature(), results, expectedResults);
    }

    private static void verifyResults(RowSignature rowSignature, List<ResultRow> results, List<Object[]> expected) {
        LOG.info("results:\n%s", new Object[]{results});
        Assert.assertEquals((long)expected.size(), (long)results.size());
        for (int i = 0; i < expected.size(); ++i) {
            Object[] resultRow = results.get(i).getArray();
            Assert.assertEquals((long)expected.get(i).length, (long)resultRow.length);
            for (int j = 0; j < resultRow.length; ++j) {
                if (rowSignature.getColumnType(j).map(t -> t.is((TypeDescriptor)ValueType.DOUBLE)).orElse(false).booleanValue()) {
                    Assert.assertEquals((double)((Double)expected.get(i)[j]), (double)((Double)resultRow[j]), (double)0.01);
                    continue;
                }
                if (rowSignature.getColumnType(j).map(t -> t.is((TypeDescriptor)ValueType.FLOAT)).orElse(false).booleanValue()) {
                    Assert.assertEquals((double)((Float)expected.get(i)[j]).floatValue(), (double)((Float)resultRow[j]).floatValue(), (double)0.01);
                    continue;
                }
                Assert.assertEquals((Object)expected.get(i)[j], (Object)resultRow[j]);
            }
        }
    }
}

