/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByStatsProvider;
import org.apache.druid.query.groupby.epinephelinae.ConcurrentGrouper;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.GrouperTestUtil;
import org.apache.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.druid.query.groupby.epinephelinae.ReusableEntry;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConcurrentGrouperTest
extends InitializedNullHandlingTest {
    private static final TestResourceHolder TEST_RESOURCE_HOLDER = new TestResourceHolder(256);
    private static final Grouper.KeySerdeFactory<LongKey> KEY_SERDE_FACTORY = new TestKeySerdeFactory();
    private static final ColumnSelectorFactory NULL_FACTORY = new TestColumnSelectorFactory();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final Supplier<ByteBuffer> bufferSupplier;
    private final int concurrencyHint;
    private final int parallelCombineThreads;
    private final ExecutorService exec;
    private final boolean mergeThreadLocal;
    private final Closer closer = Closer.create();

    @Parameterized.Parameters(name="bufferSize={0}, concurrencyHint={1}, parallelCombineThreads={2}, mergeThreadLocal={3}")
    public static Collection<Object[]> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (int bufferSize : new int[]{1024, 32768, 0x100000}) {
            for (int concurrencyHint : new int[]{8}) {
                for (int parallelCombineThreads : new int[]{8}) {
                    for (boolean mergeThreadLocal : new boolean[]{true, false}) {
                        if (parallelCombineThreads > concurrencyHint) continue;
                        constructors.add(new Object[]{bufferSize, concurrencyHint, parallelCombineThreads, mergeThreadLocal});
                    }
                }
            }
        }
        return constructors;
    }

    @Before
    public void setUp() {
        ConcurrentGrouperTest.TEST_RESOURCE_HOLDER.taken = false;
    }

    @After
    public void tearDown() throws IOException {
        this.exec.shutdownNow();
        this.closer.close();
    }

    public ConcurrentGrouperTest(final int bufferSize, int concurrencyHint, int parallelCombineThreads, boolean mergeThreadLocal) {
        this.concurrencyHint = concurrencyHint;
        this.parallelCombineThreads = parallelCombineThreads;
        this.mergeThreadLocal = mergeThreadLocal;
        this.bufferSupplier = new Supplier<ByteBuffer>(){
            private final AtomicBoolean called = new AtomicBoolean(false);
            private ByteBuffer buffer;

            public ByteBuffer get() {
                if (this.called.compareAndSet(false, true)) {
                    this.buffer = ByteBuffer.allocate(bufferSize);
                }
                return this.buffer;
            }
        };
        this.exec = Execs.multiThreaded((int)concurrencyHint, (String)"ConcurrentGrouperTest-%d");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAggregate() throws InterruptedException, ExecutionException, IOException {
        GroupByStatsProvider.PerQueryStats perQueryStats = new GroupByStatsProvider.PerQueryStats();
        LimitedTemporaryStorage temporaryStorage = new LimitedTemporaryStorage(this.temporaryFolder.newFolder(), 0x100000L, perQueryStats);
        ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)this.exec);
        try {
            ConcurrentGrouper grouper = new ConcurrentGrouper(this.bufferSupplier, (ReferenceCountingResourceHolder)TEST_RESOURCE_HOLDER, KEY_SERDE_FACTORY, KEY_SERDE_FACTORY, NULL_FACTORY, new AggregatorFactory[]{new CountAggregatorFactory("cnt")}, 1024, 0.7f, 1, temporaryStorage, (ObjectMapper)new DefaultObjectMapper(), this.concurrencyHint, null, false, service, 0, false, 0L, 4, this.parallelCombineThreads, this.mergeThreadLocal, perQueryStats);
            this.closer.register((Closeable)grouper);
            grouper.init();
            int numRows = 1000;
            Future[] futures = new Future[this.concurrencyHint];
            for (int i = 0; i < this.concurrencyHint; ++i) {
                futures[i] = this.exec.submit(() -> {
                    for (long j = 0L; j < 1000L; ++j) {
                        if (grouper.aggregate((Object)new LongKey(j)).isOk()) continue;
                        throw new ISE("Grouper is full", new Object[0]);
                    }
                });
            }
            for (Future eachFuture : futures) {
                eachFuture.get();
            }
            ArrayList<ReusableEntry> expected = new ArrayList<ReusableEntry>();
            for (long i = 0L; i < 1000L; ++i) {
                expected.add(new ReusableEntry((Object)new LongKey(i), new Object[]{(long)this.concurrencyHint}));
            }
            CloseableIterator iterator = (CloseableIterator)this.closer.register((Closeable)grouper.iterator(true));
            if (this.parallelCombineThreads > 1 && (this.mergeThreadLocal || temporaryStorage.currentSize() > 0L)) {
                Assert.assertTrue((boolean)ConcurrentGrouperTest.TEST_RESOURCE_HOLDER.taken);
            } else {
                Assert.assertFalse((boolean)ConcurrentGrouperTest.TEST_RESOURCE_HOLDER.taken);
            }
            GrouperTestUtil.assertEntriesEquals(expected.iterator(), iterator);
        }
        finally {
            service.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGrouperTimeout() throws Exception {
        if (this.concurrencyHint <= 1) {
            return;
        }
        GroupByStatsProvider.PerQueryStats perQueryStats = new GroupByStatsProvider.PerQueryStats();
        ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)this.exec);
        try {
            ConcurrentGrouper grouper = new ConcurrentGrouper(this.bufferSupplier, (ReferenceCountingResourceHolder)TEST_RESOURCE_HOLDER, KEY_SERDE_FACTORY, KEY_SERDE_FACTORY, NULL_FACTORY, new AggregatorFactory[]{new CountAggregatorFactory("cnt")}, 1024, 0.7f, 1, new LimitedTemporaryStorage(this.temporaryFolder.newFolder(), 0x100000L, perQueryStats), (ObjectMapper)new DefaultObjectMapper(), this.concurrencyHint, null, false, service, 0, true, 1L, 4, this.parallelCombineThreads, this.mergeThreadLocal, perQueryStats);
            this.closer.register((Closeable)grouper);
            grouper.init();
            int numRows = 1000;
            Future[] futures = new Future[this.concurrencyHint];
            for (int i = 0; i < this.concurrencyHint; ++i) {
                futures[i] = this.exec.submit(() -> {
                    for (long j = 0L; j < 1000L; ++j) {
                        if (grouper.aggregate((Object)new LongKey(j)).isOk()) continue;
                        throw new ISE("Grouper is full", new Object[0]);
                    }
                });
            }
            for (Future eachFuture : futures) {
                eachFuture.get();
            }
            QueryTimeoutException e = (QueryTimeoutException)Assert.assertThrows(QueryTimeoutException.class, () -> this.closer.register((Closeable)grouper.iterator(true)));
            Assert.assertEquals((Object)"Query timeout", (Object)e.getErrorCode());
        }
        finally {
            service.shutdownNow();
        }
    }

    static class TestResourceHolder
    extends ReferenceCountingResourceHolder<ByteBuffer> {
        private boolean taken;

        TestResourceHolder(int bufferSize) {
            super((Object)ByteBuffer.allocate(bufferSize), () -> {});
        }

        public ByteBuffer get() {
            this.taken = true;
            return (ByteBuffer)super.get();
        }
    }

    static class LongKey {
        private long longValue;

        @JsonCreator
        public LongKey(long longValue) {
            this.longValue = longValue;
        }

        @JsonValue
        public long longValue() {
            return this.longValue;
        }

        public void setValue(long longValue) {
            this.longValue = longValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongKey longKey = (LongKey)o;
            return this.longValue == longKey.longValue;
        }

        public int hashCode() {
            return Long.hashCode(this.longValue);
        }

        public String toString() {
            return "LongKey{longValue=" + this.longValue + "}";
        }
    }

    static class TestKeySerdeFactory
    implements Grouper.KeySerdeFactory<LongKey> {
        TestKeySerdeFactory() {
        }

        public long getMaxDictionarySize() {
            return 0L;
        }

        public Grouper.KeySerde<LongKey> factorize() {
            return new Grouper.KeySerde<LongKey>(){
                final ByteBuffer buffer = ByteBuffer.allocate(8);

                public int keySize() {
                    return 8;
                }

                public Class<LongKey> keyClazz() {
                    return LongKey.class;
                }

                public List<String> getDictionary() {
                    return ImmutableList.of();
                }

                public Long getDictionarySize() {
                    return 0L;
                }

                public ByteBuffer toByteBuffer(LongKey key) {
                    this.buffer.rewind();
                    this.buffer.putLong(key.longValue());
                    this.buffer.position(0);
                    return this.buffer;
                }

                public LongKey createKey() {
                    return new LongKey(0L);
                }

                public void readFromByteBuffer(LongKey key, ByteBuffer buffer, int position) {
                    key.setValue(buffer.getLong(position));
                }

                public Grouper.BufferComparator bufferComparator() {
                    return new Grouper.BufferComparator(){

                        public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                            return Longs.compare((long)lhsBuffer.getLong(lhsPosition), (long)rhsBuffer.getLong(rhsPosition));
                        }
                    };
                }

                public Grouper.BufferComparator bufferComparatorWithAggregators(AggregatorFactory[] aggregatorFactories, int[] aggregatorOffsets) {
                    return null;
                }

                public void reset() {
                }
            };
        }

        public Grouper.KeySerde<LongKey> factorizeWithDictionary(List<String> dictionary) {
            return this.factorize();
        }

        public LongKey copyKey(LongKey key) {
            return new LongKey(key.longValue());
        }

        public Comparator<Grouper.Entry<LongKey>> objectComparator(boolean forceDefaultOrder) {
            return Comparator.comparingLong(o -> ((LongKey)o.getKey()).longValue());
        }
    }

    private static class TestColumnSelectorFactory
    implements ColumnSelectorFactory {
        private TestColumnSelectorFactory() {
        }

        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return null;
        }

        public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
            return null;
        }

        public ColumnCapabilities getColumnCapabilities(String columnName) {
            return null;
        }
    }
}

