/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.query.IterableRowsCursorHelper;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.GroupByColumnSelectorStrategyFactory;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class NestedColumnGroupByColumnSelectorStrategyTest
extends InitializedNullHandlingTest {
    private static final GroupByColumnSelectorStrategyFactory STRATEGY_FACTORY;
    private static final List<Object[]> DATASOURCE_ROWS;
    private static final int[] DICT_IDS;
    private static final String NESTED_COLUMN = "nested";
    private static final int NULL_ROW_NUMBER = 2;
    private static final ByteBuffer BUFFER1;
    private static final ByteBuffer BUFFER2;

    @Test
    public void testKeySize() {
        Assert.assertEquals((long)4L, (long)NestedColumnGroupByColumnSelectorStrategyTest.createStrategy().getGroupingKeySizeBytes());
    }

    @Test
    public void testInitColumnValues() {
        int sz;
        GroupByColumnSelectorStrategy strategy = NestedColumnGroupByColumnSelectorStrategyTest.createStrategy();
        Cursor cursor = NestedColumnGroupByColumnSelectorStrategyTest.createCursor();
        ColumnValueSelector columnValueSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(NESTED_COLUMN);
        GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
        Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
        Object[] valuess = new Object[1];
        int rowNum = 0;
        while (!cursor.isDone()) {
            sz = strategy.initColumnValues(columnValueSelector, 0, valuess);
            if (DATASOURCE_ROWS.get(rowNum)[0] == null) {
                Assert.assertEquals((long)0L, (long)sz);
            } else {
                Assert.assertTrue((sz > 0 ? 1 : 0) != 0);
            }
            Assert.assertEquals((Object)DICT_IDS[rowNum], (Object)valuess[0]);
            cursor.advance();
            ++rowNum;
        }
        cursor = NestedColumnGroupByColumnSelectorStrategyTest.createCursor();
        columnValueSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(NESTED_COLUMN);
        rowNum = 0;
        while (!cursor.isDone()) {
            sz = strategy.initColumnValues(columnValueSelector, 0, valuess);
            Assert.assertEquals((long)0L, (long)sz);
            Assert.assertEquals((Object)DICT_IDS[rowNum], (Object)valuess[0]);
            cursor.advance();
            ++rowNum;
        }
    }

    @Test
    public void testWriteToKeyBuffer() {
        GroupByColumnSelectorStrategy strategy = NestedColumnGroupByColumnSelectorStrategyTest.createStrategy();
        ResultRow resultRow = ResultRow.create((int)1);
        GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
        Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
        Cursor cursor = NestedColumnGroupByColumnSelectorStrategyTest.createCursor();
        ColumnValueSelector columnValueSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(NESTED_COLUMN);
        int rowNum = 0;
        while (!cursor.isDone()) {
            int sz = strategy.writeToKeyBuffer(0, columnValueSelector, BUFFER1);
            if (DATASOURCE_ROWS.get(rowNum)[0] == null) {
                Assert.assertEquals((long)0L, (long)sz);
            } else {
                Assert.assertTrue((sz > 0 ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)DICT_IDS[rowNum], (long)BUFFER1.getInt(0));
            strategy.processValueFromGroupingKey(groupByColumnSelectorPlus, BUFFER1, resultRow, 0);
            Assert.assertEquals((Object)DATASOURCE_ROWS.get(rowNum)[0], (Object)resultRow.get(0));
            cursor.advance();
            ++rowNum;
        }
    }

    @Test
    public void testInitGroupingKeyColumnValue() {
        GroupByColumnSelectorStrategy strategy = NestedColumnGroupByColumnSelectorStrategyTest.createStrategy();
        GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
        Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
        int[] stack = new int[1];
        ResultRow resultRow = ResultRow.create((int)1);
        strategy.initGroupingKeyColumnValue(0, 0, (Object)-1, BUFFER1, stack);
        Assert.assertEquals((long)0L, (long)stack[0]);
        strategy.processValueFromGroupingKey(groupByColumnSelectorPlus, BUFFER1, resultRow, 0);
        Assert.assertNull((Object)resultRow.get(0));
    }

    private static GroupByColumnSelectorStrategy createStrategy() {
        return STRATEGY_FACTORY.makeColumnSelectorStrategy(NestedColumnGroupByColumnSelectorStrategyTest.createCursor().getColumnSelectorFactory().getColumnCapabilities(NESTED_COLUMN), NestedColumnGroupByColumnSelectorStrategyTest.createCursor().getColumnSelectorFactory().makeColumnValueSelector(NESTED_COLUMN), "dimension");
    }

    private static Cursor createCursor() {
        return (Cursor)IterableRowsCursorHelper.getCursorFromIterable(NestedColumnGroupByColumnSelectorStrategyTest.DATASOURCE_ROWS, (RowSignature)RowSignature.builder().add((String)NESTED_COLUMN, (ColumnType)ColumnType.NESTED_DATA).build()).lhs;
    }

    static {
        BuiltInTypesModule.registerHandlersAndSerde();
        STRATEGY_FACTORY = new GroupByColumnSelectorStrategyFactory();
        DATASOURCE_ROWS = ImmutableList.of((Object)new Object[]{StructuredData.wrap((Object)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"))}, (Object)new Object[]{StructuredData.wrap((Object)ImmutableMap.of((Object)"x", (Object)1.1, (Object)"y", (Object)2L))}, (Object)new Object[]{null}, (Object)new Object[]{StructuredData.wrap((Object)"hello")});
        DICT_IDS = new int[]{0, 1, -1, 2};
        BUFFER1 = ByteBuffer.allocate(10);
        BUFFER2 = ByteBuffer.allocate(10);
    }
}

