/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.orderby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DefaultLimitSpecTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private final List<ResultRow> testRowsList = ImmutableList.of((Object)ResultRow.of((Object[])new Object[]{10.0, 1L, 2L}), (Object)ResultRow.of((Object[])new Object[]{20.0, 3L, 1L}), (Object)ResultRow.of((Object[])new Object[]{9.0, 2L, 3L}));
    private final List<ResultRow> testRowsWithTimestampList = ImmutableList.of((Object)ResultRow.of((Object[])new Object[]{DateTimes.of((String)"2011-04-01").getMillis(), 10.0, 1L, 2L}), (Object)ResultRow.of((Object[])new Object[]{DateTimes.of((String)"2011-04-01").getMillis(), 20.0, 3L, 1L}), (Object)ResultRow.of((Object[])new Object[]{DateTimes.of((String)"2011-04-01").getMillis(), 9.0, 2L, 3L}));

    @Test
    public void testSerde() throws Exception {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        String json = "{\"type\": \"default\"}";
        DefaultLimitSpec spec = (DefaultLimitSpec)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, LimitSpec.class)), LimitSpec.class);
        Assert.assertEquals((Object)new DefaultLimitSpec(null, null), (Object)spec);
        json = "{\n  \"type\":\"default\",\n  \"columns\":[{\"dimension\":\"d\",\"direction\":\"DESCENDING\", \"dimensionOrder\":\"numeric\"}],\n  \"limit\":10\n}";
        spec = (DefaultLimitSpec)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, LimitSpec.class)), LimitSpec.class);
        Assert.assertEquals((Object)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(10)), (Object)spec);
        json = "{\n  \"type\":\"default\",\n  \"columns\":[{\"dimension\":\"d\",\"direction\":\"DES\", \"dimensionOrder\":\"numeric\"}],\n  \"limit\":10\n}";
        spec = (DefaultLimitSpec)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, LimitSpec.class)), LimitSpec.class);
        Assert.assertEquals((Object)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(10)), (Object)spec);
        json = "{\n  \"type\":\"default\",\n  \"columns\":[{\"dimension\":\"d\"}],\n  \"limit\":10\n}";
        spec = (DefaultLimitSpec)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, LimitSpec.class)), LimitSpec.class);
        Assert.assertEquals((Object)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(10)), (Object)spec);
        json = "{\n  \"type\":\"default\",\n  \"columns\":[\"d\"],\n  \"limit\":10\n}";
        spec = (DefaultLimitSpec)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, LimitSpec.class)), LimitSpec.class);
        Assert.assertEquals((Object)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(10)), (Object)spec);
    }

    @Test
    public void testBuildSimple() {
        DefaultLimitSpec limitSpec = new DefaultLimitSpec((List)ImmutableList.of(), Integer.valueOf(2));
        Function limitFn = limitSpec.build(GroupByQuery.builder().setDataSource("dummy").setInterval("1000/3000").setGranularity(Granularities.NONE).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsWithTimestampList.get(0), (Object)this.testRowsWithTimestampList.get(1)), (Object)((Sequence)limitFn.apply((Object)Sequences.simple(this.testRowsWithTimestampList))).toList());
    }

    @Test
    public void testWithAllGranularity() {
        DefaultLimitSpec limitSpec = new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("k1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(2));
        Function limitFn = limitSpec.build(GroupByQuery.builder().setDataSource("dummy").setInterval("1000/3000").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("k1", "k1", ColumnType.DOUBLE)}).setGranularity(Granularities.ALL).overrideContext((Map)ImmutableMap.of((Object)"sortByDimsFirst", (Object)true)).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsList.get(0), (Object)this.testRowsList.get(1)), (Object)((Sequence)limitFn.apply((Object)Sequences.simple(this.testRowsList))).toList());
    }

    @Test
    public void testWithSortByDimsFirst() {
        DefaultLimitSpec limitSpec = new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("k1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(2));
        Function limitFn = limitSpec.build(GroupByQuery.builder().setDataSource("dummy").setInterval("1000/3000").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("k1", "k1", ColumnType.DOUBLE)}).setGranularity(Granularities.NONE).overrideContext((Map)ImmutableMap.of((Object)"sortByDimsFirst", (Object)true)).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsWithTimestampList.get(2), (Object)this.testRowsWithTimestampList.get(0)), (Object)((Sequence)limitFn.apply((Object)Sequences.simple(this.testRowsWithTimestampList))).toList());
    }

    @Test
    public void testSortByDimNullSubtotals() {
        DefaultLimitSpec limitSpec = new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("k1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), null);
        Function limitFn = limitSpec.build(GroupByQuery.builder().setDataSource("dummy").setInterval("1000/3000").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("k1", "k1", ColumnType.DOUBLE)}).setGranularity(Granularities.ALL).build());
        Assert.assertEquals(this.testRowsList, (Object)((Sequence)limitFn.apply((Object)Sequences.simple(this.testRowsList))).toList());
    }

    @Test
    public void testSortByDimEmptySubtotals() {
        DefaultLimitSpec limitSpec = new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("k1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), null);
        Function limitFn = limitSpec.build(GroupByQuery.builder().setDataSource("dummy").setInterval("1000/3000").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("k1", "k1", ColumnType.DOUBLE)}).setGranularity(Granularities.ALL).setSubtotalsSpec((List)ImmutableList.of()).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsList.get(2), (Object)this.testRowsList.get(0), (Object)this.testRowsList.get(1)), (Object)((Sequence)limitFn.apply((Object)Sequences.simple(this.testRowsList))).toList());
    }

    @Test
    public void testSortByDimSomeSubtotals() {
        DefaultLimitSpec limitSpec = new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("k1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), null);
        Function limitFn = limitSpec.build(GroupByQuery.builder().setDataSource("dummy").setInterval("1000/3000").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("k1", "k1", ColumnType.DOUBLE)}).setGranularity(Granularities.ALL).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"k1"), (Object)ImmutableList.of())).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsList.get(2), (Object)this.testRowsList.get(0), (Object)this.testRowsList.get(1)), (Object)((Sequence)limitFn.apply((Object)Sequences.simple(this.testRowsList))).toList());
    }

    @Test
    public void testSortDimensionDescending() {
        DefaultLimitSpec limitSpec = new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("k1", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(2));
        Function limitFn = limitSpec.build(GroupByQuery.builder().setDataSource("dummy").setInterval("1000/3000").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("k1", "k1", ColumnType.DOUBLE)}).setGranularity(Granularities.ALL).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsList.get(2), (Object)this.testRowsList.get(1)), (Object)((Sequence)limitFn.apply((Object)Sequences.simple(this.testRowsList))).toList());
    }

    @Test
    public void testBuildWithExplicitOrder() {
        DefaultLimitSpec limitSpec = new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("k1", OrderByColumnSpec.Direction.ASCENDING)), Integer.valueOf(2));
        Function limitFn = limitSpec.build(GroupByQuery.builder().setDataSource("dummy").setInterval("1000/3000").setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("k1", "k1")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("k2", "k2")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ConstantPostAggregator("k3", (Number)1L))).setGranularity(Granularities.NONE).build());
        Assert.assertEquals((Object)ImmutableList.of((Object)this.testRowsList.get(0), (Object)this.testRowsList.get(1)), (Object)((Sequence)limitFn.apply((Object)Sequences.simple(this.testRowsList))).toList());
    }

    @Test
    public void testWithOffsetToLimit() {
        DefaultLimitSpec limitSpec = DefaultLimitSpec.builder().orderBy(new String[]{"abc"}).limit(1).offset(2).build();
        Assert.assertEquals((Object)DefaultLimitSpec.builder().orderBy(new String[]{"abc"}).limit(3).build(), (Object)limitSpec.withOffsetToLimit());
    }

    @Test
    public void testWithOffsetToLimitUnlimited() {
        DefaultLimitSpec limitSpec = DefaultLimitSpec.builder().orderBy(new String[]{"abc"}).offset(2).build();
        Assert.assertEquals((Object)DefaultLimitSpec.builder().orderBy(new String[]{"abc"}).build(), (Object)limitSpec.withOffsetToLimit());
    }

    @Test
    public void testWithOffsetToLimitTooCloseToMaxValue() {
        DefaultLimitSpec limitSpec = DefaultLimitSpec.builder().orderBy(new String[]{"abc"}).limit(0x7FFFFFFE).offset(2).build();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Cannot apply limit[2147483646] with offset[2] due to overflow");
        limitSpec.withOffsetToLimit();
    }
}

