/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import java.util.Arrays;
import org.apache.druid.query.operator.InlineScanOperator;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorTestHelper;
import org.apache.druid.query.operator.join.JoinConfig;
import org.apache.druid.query.operator.join.JoinPartDefn;
import org.apache.druid.query.operator.join.SortedInnerJoinOperator;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Test;

public class SortedInnerJoinOperatorTest {
    @Test
    public void testSimpleTwoWayJoin() {
        SortedInnerJoinOperator joinMe = new SortedInnerJoinOperator(Arrays.asList(this.buildDefn(new RowsAndColumns[]{MapOfColumnsRowsAndColumns.builder().add("joinField", new int[]{0, 0, 0, 1, 1, 2, 4, 4, 4}).add("projectMe", new int[]{3, 54, 21, 1, 5, 54, 2, 3, 92}).build()}).joinOn(new String[]{"joinField"}).project(new String[]{"joinField", "projectMe"}).build(), this.buildDefn(new RowsAndColumns[]{MapOfColumnsRowsAndColumns.builder().add("joinField", new int[]{0, 1, 4}).add("projectMeToo", ColumnType.STRING, new Object[]{"a", "b", "e"}).build()}).joinOn(new String[]{"joinField"}).project(new String[]{"projectMeToo"}).build()), new JoinConfig(4));
        new OperatorTestHelper().expectRowsAndColumns(new RowsAndColumnsHelper().expectColumn("joinField", new int[]{0, 0, 0, 1, 1}).expectColumn("projectMe", new int[]{3, 54, 21, 1, 5}).expectColumn("projectMeToo", ColumnType.STRING, "a", "a", "a", "b", "b").allColumnsRegistered(), new RowsAndColumnsHelper().expectColumn("joinField", new int[]{4, 4, 4}).expectColumn("projectMe", new int[]{2, 3, 92}).expectColumn("projectMeToo", ColumnType.STRING, "e", "e", "e").allColumnsRegistered()).runToCompletion((Operator)joinMe);
    }

    @Test
    public void testSimpleThreeWayJoin() {
        SortedInnerJoinOperator joinMe = new SortedInnerJoinOperator(Arrays.asList(this.buildDefn(new RowsAndColumns[]{MapOfColumnsRowsAndColumns.builder().add("joinField", new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 2.0, 4.0, 4.0, 4.0}).add("projectMe", new int[]{3, 54, 21, 1, 5, 54, 2, 3, 92}).build()}).joinOn(new String[]{"joinField"}).project(new String[]{"joinField", "projectMe"}).build(), this.buildDefn(new RowsAndColumns[]{MapOfColumnsRowsAndColumns.builder().add("joinField", new double[]{0.0, 1.0, 4.0}).add("projectMeToo", ColumnType.STRING, new Object[]{"a", "b", "e"}).build()}).joinOn(new String[]{"joinField"}).project(new String[]{"projectMeToo"}).build(), this.buildDefn(new RowsAndColumns[]{MapOfColumnsRowsAndColumns.builder().add("joinField", new double[]{0.0, 0.0, 1.0, 2.0, 4.0}).add("projectMeThree", ColumnType.STRING, new Object[]{"C", "CC", "B", "Z", "A"}).build()}).joinOn(new String[]{"joinField"}).project(new String[]{"projectMeThree"}).build()), new JoinConfig(4));
        new OperatorTestHelper().expectRowsAndColumns(new RowsAndColumnsHelper().expectColumn("joinField", new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}).expectColumn("projectMe", new int[]{3, 3, 54, 54, 21, 21}).expectColumn("projectMeToo", ColumnType.STRING, "a", "a", "a", "a", "a", "a").expectColumn("projectMeThree", ColumnType.STRING, "C", "CC", "C", "CC", "C", "CC").allColumnsRegistered(), new RowsAndColumnsHelper().expectColumn("joinField", new double[]{1.0, 1.0, 4.0, 4.0, 4.0}).expectColumn("projectMe", new int[]{1, 5, 2, 3, 92}).expectColumn("projectMeToo", ColumnType.STRING, "b", "b", "e", "e", "e").expectColumn("projectMeThree", ColumnType.STRING, "B", "B", "A", "A", "A").allColumnsRegistered()).runToCompletion((Operator)joinMe);
    }

    private JoinPartDefn.Builder buildDefn(RowsAndColumns ... racs) {
        return JoinPartDefn.builder((Operator)InlineScanOperator.make(racs));
    }
}

