/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.ranking;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.operator.window.ranking.WindowDenseRankProcessor;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.junit.Assert;
import org.junit.Test;

public class WindowDenseRankProcessorTest {
    @Test
    public void testDenseRankProcessing() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("vals", new IntArrayColumn(new int[]{7, 18, 18, 30, 120, 121, 122, 122, 8290, 8290}));
        MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap(map);
        WindowDenseRankProcessor processor = new WindowDenseRankProcessor(Collections.singletonList("vals"), "DenseRank");
        Assert.assertEquals(Collections.singletonList("DenseRank"), (Object)processor.getOutputColumnNames());
        RowsAndColumnsHelper expectations = new RowsAndColumnsHelper().expectColumn("vals", new int[]{7, 18, 18, 30, 120, 121, 122, 122, 8290, 8290}).expectColumn("DenseRank", new int[]{1, 2, 2, 3, 4, 5, 6, 6, 7, 7});
        RowsAndColumns results = processor.process((RowsAndColumns)rac);
        expectations.validate(results);
    }
}

