/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.column.LongArrayColumn;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.apache.druid.query.rowsandcols.semantic.AppendableRowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.ClusteredGroupPartitioner;
import org.apache.druid.query.rowsandcols.semantic.SemanticTestBase;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Assert;
import org.junit.Test;

public class AppendableRowsAndColumnsTest
extends SemanticTestBase {
    public AppendableRowsAndColumnsTest(String name, Function<MapOfColumnsRowsAndColumns, RowsAndColumns> fn) {
        super(name, fn);
    }

    @Test
    public void testAppendableRowsAndColumns() {
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"colA", (Object)new IntArrayColumn(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}), (Object)"colB", (Object)new LongArrayColumn(new long[]{4L, -4L, 3L, -3L, 4L, 82L, -90L, 4L, 0L, 0L}))));
        AppendableRowsAndColumns appender = RowsAndColumns.expectAppendable((RowsAndColumns)rac);
        appender.addColumn("newCol", (Column)new IntArrayColumn(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}));
        new RowsAndColumnsHelper().expectColumn("colA", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).expectColumn("colB", new long[]{4L, -4L, 3L, -3L, 4L, 82L, -90L, 4L, 0L, 0L}).expectColumn("newCol", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).allColumnsRegistered().validate((RowsAndColumns)appender);
    }

    @Test
    public void testAppendableRowsAndColumnsCanBeUsedForClusterGrouper() {
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"unsorted", (Object)new IntArrayColumn(new int[]{3, 54, 21, 1, 5, 54, 2, 3, 92}))));
        AppendableRowsAndColumns appender = RowsAndColumns.expectAppendable((RowsAndColumns)rac);
        appender.addColumn("sorted", (Column)new ObjectArrayColumn(new Object[]{null, null, null, 1, 1, 2, 4, 4, 4}, ColumnType.LONG));
        new RowsAndColumnsHelper().expectColumn("unsorted", new int[]{3, 54, 21, 1, 5, 54, 2, 3, 92}).expectColumn("sorted", new Object[]{null, null, null, 1, 1, 2, 4, 4, 4}, ColumnType.LONG).allColumnsRegistered().validate((RowsAndColumns)appender);
        ClusteredGroupPartitioner parter = ClusteredGroupPartitioner.fromRAC((RowsAndColumns)appender);
        int[] boundaries = parter.computeBoundaries(Collections.singletonList("sorted"));
        Assert.assertArrayEquals((int[])new int[]{0, 3, 5, 6, 9}, (int[])boundaries);
    }
}

