/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.ListBasedInputRow;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactoryProjectionTest;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.QueryableIndexCursorHolder;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class QueryableIndexCursorHolderTest {
    @Test
    public void testTimeSearch() {
        final int[] values = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 5, 7, 10};
        NumericColumn column = new NumericColumn(){

            public int length() {
                return values.length;
            }

            public long getLongSingleValueRow(int rowNum) {
                return values[rowNum];
            }

            public void close() {
                throw new UnsupportedOperationException();
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                throw new UnsupportedOperationException();
            }

            public ColumnValueSelector<?> makeColumnValueSelector(ReadableOffset offset) {
                throw new UnsupportedOperationException();
            }
        };
        Assert.assertEquals((long)0L, (long)QueryableIndexCursorHolder.timeSearch((NumericColumn)column, (long)0L, (int)0, (int)values.length));
        Assert.assertEquals((long)2L, (long)QueryableIndexCursorHolder.timeSearch((NumericColumn)column, (long)0L, (int)2, (int)values.length));
        Assert.assertEquals((long)0L, (long)QueryableIndexCursorHolder.timeSearch((NumericColumn)column, (long)0L, (int)0, (int)(values.length / 2)));
        Assert.assertEquals((long)1L, (long)QueryableIndexCursorHolder.timeSearch((NumericColumn)column, (long)1L, (int)0, (int)values.length));
        Assert.assertEquals((long)2L, (long)QueryableIndexCursorHolder.timeSearch((NumericColumn)column, (long)1L, (int)2, (int)values.length));
        Assert.assertEquals((long)1L, (long)QueryableIndexCursorHolder.timeSearch((NumericColumn)column, (long)1L, (int)0, (int)(values.length / 2)));
        Assert.assertEquals((long)1L, (long)QueryableIndexCursorHolder.timeSearch((NumericColumn)column, (long)1L, (int)1, (int)8));
        Assert.assertEquals((long)8L, (long)QueryableIndexCursorHolder.timeSearch((NumericColumn)column, (long)2L, (int)0, (int)values.length));
        Assert.assertEquals((long)10L, (long)QueryableIndexCursorHolder.timeSearch((NumericColumn)column, (long)10L, (int)0, (int)values.length));
        Assert.assertEquals((long)11L, (long)QueryableIndexCursorHolder.timeSearch((NumericColumn)column, (long)15L, (int)0, (int)values.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProjectionTimeBoundaryInspector() {
        DateTime startTime = DateTimes.nowUtc();
        DimensionsSpec dims = DimensionsSpec.builder().setDimensions(Arrays.asList(new StringDimensionSchema("a"), new StringDimensionSchema("b"), new LongDimensionSchema("c"), new DoubleDimensionSchema("d"))).build();
        File tmp = FileUtils.createTempDir();
        Closer closer = Closer.create();
        closer.register(tmp::delete);
        List<InputRow> rows = Arrays.asList(new ListBasedInputRow(CursorFactoryProjectionTest.ROW_SIGNATURE, startTime, CursorFactoryProjectionTest.ROW_SIGNATURE.getColumnNames(), Arrays.asList("a", "aa", 1L, 1.0)), new ListBasedInputRow(CursorFactoryProjectionTest.ROW_SIGNATURE, startTime.plusMinutes(2), CursorFactoryProjectionTest.ROW_SIGNATURE.getColumnNames(), Arrays.asList("a", "bb", 1L, 1.1, Float.valueOf(1.1f))));
        IndexBuilder bob = IndexBuilder.create().tmpDir(tmp).schema(IncrementalIndexSchema.builder().withDimensionsSpec(dims).withRollup(false).withMinTimestamp(startTime.getMillis()).withProjections(Collections.singletonList(new AggregateProjectionSpec("ab_hourly_cd_sum_time_ordered", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}), Arrays.asList(new LongDimensionSchema("__gran"), new StringDimensionSchema("a"), new StringDimensionSchema("b")), new AggregatorFactory[]{new LongSumAggregatorFactory("_c_sum", "c"), new DoubleSumAggregatorFactory("d", "d")}))).build()).rows(rows);
        try (QueryableIndex index = bob.buildMMappedIndex();){
            CursorBuildSpec buildSpec = CursorBuildSpec.builder().setGroupingColumns((List)ImmutableList.of((Object)"a", (Object)"b")).setPhysicalColumns((Set)ImmutableSet.of((Object)"a", (Object)"b")).setAggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("c_sum", "c"))).setQueryContext(QueryContext.of((Map)ImmutableMap.of((Object)"forceProjections", (Object)true))).build();
            QueryableIndexCursorFactory cursorFactory = new QueryableIndexCursorFactory(index);
            try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(buildSpec);){
                Cursor cursor = cursorHolder.asCursor();
                int rowCount = 0;
                while (!cursor.isDone()) {
                    ++rowCount;
                    cursor.advance();
                }
                Assert.assertEquals((long)2L, (long)rowCount);
            }
        }
        finally {
            CloseableUtils.closeAndWrapExceptions((Closeable)closer);
        }
    }
}

