/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.column.CapabilitiesBasedFormat;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CapabilitiesBasedFormatTest {
    @Test
    public void testMerge() {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setHasMultipleValues(true);
        ColumnCapabilitiesImpl capabilities2 = new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(true).setDictionaryValuesSorted(true).setDictionaryValuesUnique(true).setHasBitmapIndexes(true).setHasNulls(true);
        CapabilitiesBasedFormat format = new CapabilitiesBasedFormat((ColumnCapabilities)capabilities);
        ColumnCapabilities mergedCapabilities = format.merge((ColumnFormat)new CapabilitiesBasedFormat((ColumnCapabilities)capabilities2)).toColumnCapabilities();
        Assertions.assertTrue((boolean)mergedCapabilities.is((TypeDescriptor)ValueType.STRING));
        Assertions.assertFalse((boolean)mergedCapabilities.hasBitmapIndexes());
        Assertions.assertFalse((boolean)mergedCapabilities.areDictionaryValuesSorted().isTrue());
        Assertions.assertFalse((boolean)mergedCapabilities.areDictionaryValuesUnique().isTrue());
        Assertions.assertTrue((boolean)mergedCapabilities.isDictionaryEncoded().isTrue());
        Assertions.assertTrue((boolean)mergedCapabilities.hasMultipleValues().isTrue());
        Assertions.assertTrue((boolean)mergedCapabilities.hasNulls().isTrue());
    }

    @Test
    public void testMergeNullCapabilities() {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setHasMultipleValues(true);
        CapabilitiesBasedFormat format = new CapabilitiesBasedFormat((ColumnCapabilities)capabilities);
        ColumnFormat merged = format.merge(null);
        Assertions.assertEquals((Object)format, (Object)merged);
    }

    @Test
    public void testMergeIncompatibleArray() {
        ColumnCapabilitiesImpl arrayString = ColumnCapabilitiesImpl.createSimpleArrayColumnCapabilities((TypeSignature)ColumnType.STRING_ARRAY);
        ColumnCapabilitiesImpl arrayLong = ColumnCapabilitiesImpl.createSimpleArrayColumnCapabilities((TypeSignature)ColumnType.LONG_ARRAY);
        ColumnCapabilitiesImpl string = ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities();
        CapabilitiesBasedFormat stringArrayFormat = new CapabilitiesBasedFormat((ColumnCapabilities)arrayString);
        CapabilitiesBasedFormat longArrayFormat = new CapabilitiesBasedFormat((ColumnCapabilities)arrayLong);
        CapabilitiesBasedFormat stringFormat = new CapabilitiesBasedFormat((ColumnCapabilities)string);
        Throwable t = Assertions.assertThrows(ISE.class, () -> CapabilitiesBasedFormatTest.lambda$testMergeIncompatibleArray$0((ColumnFormat)stringArrayFormat, (ColumnFormat)longArrayFormat));
        Assertions.assertEquals((Object)"Cannot merge columns of type[ARRAY<STRING>] and [ARRAY<LONG>]", (Object)t.getMessage());
        t = Assertions.assertThrows(ISE.class, () -> CapabilitiesBasedFormatTest.lambda$testMergeIncompatibleArray$1((ColumnFormat)stringArrayFormat, stringFormat));
        Assertions.assertEquals((Object)"Cannot merge columns of type[ARRAY<STRING>] and [STRING]", (Object)t.getMessage());
    }

    @Test
    public void testMergeIncompatibleComplexType() {
        ColumnCapabilitiesImpl complex1 = new ColumnCapabilitiesImpl().setType(ColumnType.ofComplex((String)"someComplex"));
        ColumnCapabilitiesImpl complex2 = new ColumnCapabilitiesImpl().setType(ColumnType.ofComplex((String)"otherComplex"));
        ColumnCapabilitiesImpl string = ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities();
        CapabilitiesBasedFormat format1 = new CapabilitiesBasedFormat((ColumnCapabilities)complex1);
        CapabilitiesBasedFormat format2 = new CapabilitiesBasedFormat((ColumnCapabilities)complex2);
        CapabilitiesBasedFormat stringFormat = new CapabilitiesBasedFormat((ColumnCapabilities)string);
        Throwable t = Assertions.assertThrows(ISE.class, () -> CapabilitiesBasedFormatTest.lambda$testMergeIncompatibleComplexType$2((ColumnFormat)format1, (ColumnFormat)format2));
        Assertions.assertEquals((Object)"Cannot merge columns of type[COMPLEX<someComplex>] and [COMPLEX<otherComplex>]", (Object)t.getMessage());
        t = Assertions.assertThrows(ISE.class, () -> CapabilitiesBasedFormatTest.lambda$testMergeIncompatibleComplexType$3((ColumnFormat)format1, stringFormat));
        Assertions.assertEquals((Object)"Cannot merge columns of type[COMPLEX<someComplex>] and [STRING]", (Object)t.getMessage());
    }

    private static /* synthetic */ void lambda$testMergeIncompatibleComplexType$3(ColumnFormat format1, CapabilitiesBasedFormat stringFormat) throws Throwable {
        format1.merge((ColumnFormat)stringFormat);
    }

    private static /* synthetic */ void lambda$testMergeIncompatibleComplexType$2(ColumnFormat format1, ColumnFormat format2) throws Throwable {
        format1.merge(format2);
    }

    private static /* synthetic */ void lambda$testMergeIncompatibleArray$1(ColumnFormat stringArrayFormat, CapabilitiesBasedFormat stringFormat) throws Throwable {
        stringArrayFormat.merge((ColumnFormat)stringFormat);
    }

    private static /* synthetic */ void lambda$testMergeIncompatibleArray$0(ColumnFormat stringArrayFormat, ColumnFormat longArrayFormat) throws Throwable {
        stringArrayFormat.merge(longArrayFormat);
    }
}

