/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import org.apache.druid.query.aggregation.firstlast.last.StringLastAggregatorFactory;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.SegmentMetadata;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.SegmentId;
import org.junit.Assert;
import org.junit.Test;

public class SegmentSchemaMappingTest {
    private ObjectMapper mapper = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws IOException {
        RowSignature rowSignature = RowSignature.builder().add("c", ColumnType.FLOAT).build();
        SegmentId segmentId = SegmentId.dummy((String)"ds1");
        StringLastAggregatorFactory factory = new StringLastAggregatorFactory("billy", "nilly", null, Integer.valueOf(20));
        SchemaPayload payload = new SchemaPayload(rowSignature, Collections.singletonMap("twosum", factory));
        SchemaPayloadPlus schemaPayloadPlus = new SchemaPayloadPlus(payload, Long.valueOf(20L));
        SegmentSchemaMapping segmentSchemaMapping = new SegmentSchemaMapping(Collections.singletonMap(segmentId.toString(), new SegmentMetadata(Long.valueOf(20L), "fp1")), Collections.singletonMap("fp1", payload), 1);
        byte[] bytes = this.mapper.writeValueAsBytes((Object)segmentSchemaMapping);
        SegmentSchemaMapping deserialized = (SegmentSchemaMapping)this.mapper.readValue(bytes, SegmentSchemaMapping.class);
        Assert.assertEquals((Object)segmentSchemaMapping, (Object)deserialized);
        SegmentSchemaMapping copy = new SegmentSchemaMapping(1);
        copy.merge(segmentSchemaMapping);
        Assert.assertEquals((Object)segmentSchemaMapping, (Object)copy);
        SegmentSchemaMapping copy2 = new SegmentSchemaMapping(1);
        copy2.addSchema(segmentId, schemaPayloadPlus, "fp1");
        Assert.assertEquals((Object)segmentSchemaMapping, (Object)copy2);
    }

    @Test
    public void testEquals() {
        RowSignature rowSignature = RowSignature.builder().add("c", ColumnType.FLOAT).build();
        SegmentId segmentId = SegmentId.dummy((String)"ds1");
        StringLastAggregatorFactory factory = new StringLastAggregatorFactory("billy", "nilly", null, Integer.valueOf(20));
        SchemaPayload payload = new SchemaPayload(rowSignature, Collections.singletonMap("twosum", factory));
        SegmentSchemaMapping segmentSchemaMapping = new SegmentSchemaMapping(Collections.singletonMap(segmentId.toString(), new SegmentMetadata(Long.valueOf(20L), "fp1")), Collections.singletonMap("fp1", payload), 1);
        SegmentSchemaMapping segmentSchemaMappingWithDifferentVersion = new SegmentSchemaMapping(Collections.singletonMap(segmentId.toString(), new SegmentMetadata(Long.valueOf(20L), "fp1")), Collections.singletonMap("fp1", payload), 0);
        Assert.assertNotEquals((Object)segmentSchemaMapping, (Object)segmentSchemaMappingWithDifferentVersion);
        SegmentSchemaMapping segmentSchemaMappingWithDifferentPayload = new SegmentSchemaMapping(Collections.emptyMap(), Collections.emptyMap(), 0);
        Assert.assertNotEquals((Object)segmentSchemaMapping, (Object)segmentSchemaMappingWithDifferentPayload);
    }
}

