/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.error.DruidException;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.TypedInFilter;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

public class InFilterTests {
    private static TypedInFilter inFilter(String columnName, ColumnType matchValueType, List<?> values) {
        return new TypedInFilter(columnName, matchValueType, values, null, null);
    }

    private static InDimFilter legacyInFilter(String dim, String value, String ... values) {
        return new InDimFilter(dim, (Collection)Lists.asList((Object)value, (Object[])values), null);
    }

    private static InDimFilter legacyInFilterWithFn(String dim, ExtractionFn fn, String value, String ... values) {
        return new InDimFilter(dim, (Collection)Lists.asList((Object)value, (Object[])values), fn);
    }

    public static class LegacyInDimFilterNonParameterizedTests
    extends InitializedNullHandlingTest {
        @Test
        public void testRequiredColumnRewrite() {
            InDimFilter filter = (InDimFilter)InFilterTests.legacyInFilter("dim0", "a", "c").toFilter();
            InDimFilter filter2 = (InDimFilter)InFilterTests.legacyInFilter("dim1", "a", "c").toFilter();
            Assert.assertTrue((boolean)filter.supportsRequiredColumnRewrite());
            Assert.assertTrue((boolean)filter2.supportsRequiredColumnRewrite());
            Filter rewrittenFilter = filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"dim0", (Object)"dim1"));
            Assert.assertEquals((Object)filter2, (Object)rewrittenFilter);
            Throwable t = Assert.assertThrows(IAE.class, () -> filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"invalidName", (Object)"dim1")));
            Assert.assertEquals((Object)"Received a non-applicable rewrite: {invalidName=dim1}, filter's dimension: dim0", (Object)t.getMessage());
        }

        @Test
        public void testEuals() {
            EqualsVerifier.forClass(InDimFilter.class).usingGetClass().withNonnullFields(new String[]{"dimension", "values"}).withIgnoredFields(new String[]{"cacheKeySupplier", "predicateFactory", "optimizedFilterIncludeUnknown", "optimizedFilterNoIncludeUnknown", "valuesUtf8"}).verify();
        }

        @Test
        public void testEqualsForInFilterDruidPredicateFactory() {
            EqualsVerifier.forClass(InDimFilter.InFilterDruidPredicateFactory.class).usingGetClass().withNonnullFields(new String[]{"values"}).withIgnoredFields(new String[]{"longPredicateSupplier", "floatPredicateSupplier", "doublePredicateSupplier", "stringPredicateSupplier"}).verify();
        }
    }

    public static class TypedInFilterFilterNonParameterizedTests
    extends InitializedNullHandlingTest {
        @Test
        public void testSerde() throws JsonProcessingException {
            DefaultObjectMapper mapper = new DefaultObjectMapper();
            TypedInFilter filter = InFilterTests.inFilter("column", ColumnType.STRING, Arrays.asList("a", "b", "c"));
            String s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, TypedInFilter.class));
            filter = InFilterTests.inFilter("column", ColumnType.STRING, Arrays.asList("a", "b", "b", null, "c"));
            s = mapper.writeValueAsString((Object)filter);
            TypedInFilter deserialized = (TypedInFilter)mapper.readValue(s, TypedInFilter.class);
            Assert.assertEquals(Arrays.asList(null, "a", "b", "c"), (Object)deserialized.getSortedValues());
            Assert.assertEquals((Object)filter, (Object)deserialized);
            filter = InFilterTests.inFilter("column", ColumnType.LONG, Arrays.asList(1L, 2L, 2L, null, 3L));
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, TypedInFilter.class));
            filter = InFilterTests.inFilter("column", ColumnType.DOUBLE, Arrays.asList(1.1, 2.2, 2.3, null, 3.3));
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, TypedInFilter.class));
            filter = InFilterTests.inFilter("column", ColumnType.FLOAT, Arrays.asList(Float.valueOf(1.1f), Float.valueOf(2.2f), Float.valueOf(2.2f), null, Float.valueOf(3.3f)));
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, TypedInFilter.class));
            filter = InFilterTests.inFilter("column", ColumnType.FLOAT, Arrays.asList(1.1, 2.2, 2.3, null, 3.3));
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, TypedInFilter.class));
        }

        @Test
        public void testGetCacheKey() {
            TypedInFilter filterUnsorted = InFilterTests.inFilter("column", ColumnType.STRING, Arrays.asList("a", "b", null, "c"));
            TypedInFilter filterDifferent = InFilterTests.inFilter("column", ColumnType.STRING, Arrays.asList("a", "c", "b"));
            TypedInFilter filterPresorted = new TypedInFilter("column", ColumnType.STRING, null, Arrays.asList(null, "a", "b", "c"), null);
            Assert.assertEquals((Object)filterPresorted, (Object)filterUnsorted);
            Assert.assertNotEquals((Object)filterDifferent, (Object)filterPresorted);
            Assert.assertArrayEquals((byte[])filterPresorted.getCacheKey(), (byte[])filterUnsorted.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(filterDifferent.getCacheKey(), filterPresorted.getCacheKey()));
            filterUnsorted = InFilterTests.inFilter("column", ColumnType.LONG, Arrays.asList(2L, -2L, 1L, null, 3L));
            filterDifferent = InFilterTests.inFilter("column", ColumnType.LONG, Arrays.asList(2L, -2L, 1L, 3L));
            filterPresorted = new TypedInFilter("column", ColumnType.LONG, null, Arrays.asList(null, -2L, 1L, 2L, 3L), null);
            Assert.assertEquals((Object)filterPresorted, (Object)filterUnsorted);
            Assert.assertNotEquals((Object)filterDifferent, (Object)filterPresorted);
            Assert.assertArrayEquals((byte[])filterPresorted.getCacheKey(), (byte[])filterUnsorted.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(filterDifferent.getCacheKey(), filterPresorted.getCacheKey()));
            filterUnsorted = InFilterTests.inFilter("column", ColumnType.DOUBLE, Arrays.asList(2.2, -2.2, 1.1, null, 3.3));
            filterDifferent = InFilterTests.inFilter("column", ColumnType.DOUBLE, Arrays.asList(2.2, -2.2, 1.1, 3.3));
            filterPresorted = new TypedInFilter("column", ColumnType.DOUBLE, null, Arrays.asList(null, -2.2, 1.1, 2.2, 3.3), null);
            Assert.assertEquals((Object)filterPresorted, (Object)filterUnsorted);
            Assert.assertNotEquals((Object)filterDifferent, (Object)filterPresorted);
            Assert.assertArrayEquals((byte[])filterPresorted.getCacheKey(), (byte[])filterUnsorted.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(filterDifferent.getCacheKey(), filterPresorted.getCacheKey()));
            filterUnsorted = InFilterTests.inFilter("column", ColumnType.FLOAT, Arrays.asList(Float.valueOf(2.2f), Float.valueOf(-2.2f), Float.valueOf(1.1f), null, Float.valueOf(3.3f)));
            filterDifferent = InFilterTests.inFilter("column", ColumnType.FLOAT, Arrays.asList(Float.valueOf(2.2f), Float.valueOf(-2.2f), Float.valueOf(1.1f), Float.valueOf(3.3f)));
            filterPresorted = new TypedInFilter("column", ColumnType.FLOAT, null, Arrays.asList(null, Float.valueOf(-2.2f), Float.valueOf(1.1f), Float.valueOf(2.2f), Float.valueOf(3.3f)), null);
            Assert.assertEquals((Object)filterPresorted, (Object)filterUnsorted);
            Assert.assertNotEquals((Object)filterDifferent, (Object)filterPresorted);
            Assert.assertArrayEquals((byte[])filterPresorted.getCacheKey(), (byte[])filterUnsorted.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(filterDifferent.getCacheKey(), filterPresorted.getCacheKey()));
        }

        @Test
        public void testInvalidParameters() {
            Throwable t = Assert.assertThrows(DruidException.class, () -> new TypedInFilter(null, ColumnType.STRING, null, null, null));
            Assert.assertEquals((Object)"Invalid IN filter, column cannot be null", (Object)t.getMessage());
            t = Assert.assertThrows(DruidException.class, () -> new TypedInFilter("dim0", null, null, null, null));
            Assert.assertEquals((Object)"Invalid IN filter on column [dim0], matchValueType cannot be null", (Object)t.getMessage());
            t = Assert.assertThrows(DruidException.class, () -> new TypedInFilter("dim0", ColumnType.STRING, null, null, null));
            Assert.assertEquals((Object)"Invalid IN filter on column [dim0], exactly one of values or sortedValues must be non-null", (Object)t.getMessage());
        }

        @Test
        public void testGetDimensionRangeSet() {
            TypedInFilter filter = InFilterTests.inFilter("x", ColumnType.STRING, Arrays.asList(null, "a", "b", "c"));
            TypedInFilter filter2 = InFilterTests.inFilter("x", ColumnType.STRING, Arrays.asList("a", "b", null, "c"));
            Assert.assertEquals((Object)filter.getDimensionRangeSet("x"), (Object)filter2.getDimensionRangeSet("x"));
            RangeSet range = filter.getDimensionRangeSet("x");
            Assert.assertTrue((boolean)range.contains((Comparable)((Object)"b")));
            filter = InFilterTests.inFilter("x", ColumnType.LONG, Arrays.asList(null, 1L, 2L, 3L));
            filter2 = InFilterTests.inFilter("x", ColumnType.LONG, Arrays.asList(3L, 1L, null, 2L));
            Assert.assertEquals((Object)filter.getDimensionRangeSet("x"), (Object)filter2.getDimensionRangeSet("x"));
            range = filter.getDimensionRangeSet("x");
            Assert.assertTrue((boolean)range.contains((Comparable)((Object)"2")));
            filter = InFilterTests.inFilter("x", ColumnType.DOUBLE, Arrays.asList(null, 1.1, 2.2, 3.3));
            filter2 = InFilterTests.inFilter("x", ColumnType.DOUBLE, Arrays.asList(3.3, 1.1, null, 2.2));
            range = filter.getDimensionRangeSet("x");
            Assert.assertEquals((Object)filter.getDimensionRangeSet("x"), (Object)filter2.getDimensionRangeSet("x"));
            Assert.assertTrue((boolean)range.contains((Comparable)((Object)"2.2")));
            filter = InFilterTests.inFilter("x", ColumnType.FLOAT, Arrays.asList(null, Float.valueOf(1.1f), Float.valueOf(2.2f), Float.valueOf(3.3f)));
            filter2 = InFilterTests.inFilter("x", ColumnType.FLOAT, Arrays.asList(Float.valueOf(3.3f), Float.valueOf(1.1f), null, Float.valueOf(2.2f)));
            range = filter.getDimensionRangeSet("x");
            Assert.assertEquals((Object)filter.getDimensionRangeSet("x"), (Object)filter2.getDimensionRangeSet("x"));
            Assert.assertTrue((boolean)range.contains((Comparable)((Object)"2.2")));
        }

        @Test
        public void testRequiredColumnRewrite() {
            TypedInFilter filter = InFilterTests.inFilter("dim0", ColumnType.STRING, Arrays.asList("a", "c"));
            TypedInFilter filter2 = InFilterTests.inFilter("dim1", ColumnType.STRING, Arrays.asList("a", "c"));
            Assert.assertTrue((boolean)filter.supportsRequiredColumnRewrite());
            Assert.assertTrue((boolean)filter2.supportsRequiredColumnRewrite());
            Filter rewrittenFilter = filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"dim0", (Object)"dim1"));
            Assert.assertEquals((Object)filter2, (Object)rewrittenFilter);
            Throwable t = Assert.assertThrows(IAE.class, () -> filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"invalidName", (Object)"dim1")));
            Assert.assertEquals((Object)"Received a non-applicable rewrite: {invalidName=dim1}, filter's dimension: dim0", (Object)t.getMessage());
        }

        @Test
        public void testEquals() {
            EqualsVerifier.forClass(TypedInFilter.class).usingGetClass().withNonnullFields(new String[]{"column", "matchValueType", "unsortedValues", "sortedMatchValues", "optimizedFilterIncludeUnknown", "optimizedFilterNoIncludeUnknown"}).withPrefabValues(ColumnType.class, (Object)ColumnType.STRING, (Object)ColumnType.DOUBLE).withPrefabValues(Supplier.class, (Object)Suppliers.ofInstance((Object)ImmutableList.of((Object)"a", (Object)"b")), (Object)Suppliers.ofInstance((Object)ImmutableList.of((Object)"b", (Object)"c"))).withIgnoredFields(new String[]{"unsortedValues", "sortedUtf8MatchValueBytes", "predicateFactorySupplier", "cacheKeySupplier", "optimizedFilterIncludeUnknown", "optimizedFilterNoIncludeUnknown"}).verify();
        }
    }

    @RunWith(value=Parameterized.class)
    public static class InFilterTest
    extends BaseFilterTest {
        private static final List<InputRow> ROWS = ImmutableList.of((Object)InFilterTest.makeDefaultSchemaRow("a", "", ImmutableList.of((Object)"a", (Object)"b"), "2017-07-25", "", 0.0, Float.valueOf(0.0f), 0L), (Object)InFilterTest.makeDefaultSchemaRow("b", "10", ImmutableList.of(), "2017-07-25", "a", 10.1, Float.valueOf(10.1f), 100L), (Object)InFilterTest.makeDefaultSchemaRow("c", "2", ImmutableList.of((Object)""), "2017-05-25", null, null, Float.valueOf(5.5f), 40L), (Object)InFilterTest.makeDefaultSchemaRow("d", "1", ImmutableList.of((Object)"a"), "2020-01-25", "b", 120.0245, Float.valueOf(110.0f), null), (Object)InFilterTest.makeDefaultSchemaRow("e", "def", ImmutableList.of((Object)"c"), null, "c", 60.0, null, 9001L), (Object)InFilterTest.makeDefaultSchemaRow("f", "abc", null, "2020-01-25", "a", 765.432, Float.valueOf(123.45f), 12345L));
        private final ObjectMapper jsonMapper = new DefaultObjectMapper();

        public InFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<CursorFactory, Closeable>> finisher, boolean cnf, boolean optimize) {
            super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
        }

        @AfterClass
        public static void tearDown() throws Exception {
            BaseFilterTest.tearDown(InFilterTest.class.getName());
        }

        @Test
        public void testSingleValueStringColumnWithoutNulls() {
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim0", ColumnType.STRING, Collections.emptyList()), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("dim0", ColumnType.STRING, Collections.emptyList())), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim0", ColumnType.STRING, Collections.singletonList(null)), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim0", ColumnType.STRING, Arrays.asList("", "")), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim0", ColumnType.STRING, Arrays.asList("a", "c")), (List<String>)ImmutableList.of((Object)"a", (Object)"c"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim0", ColumnType.STRING, Arrays.asList("e", "x")), (List<String>)ImmutableList.of((Object)"e"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("dim0", ColumnType.STRING, Arrays.asList("e", "x"))), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"f"));
            this.assertTypedFilterMatches((DimFilter)InFilterTests.inFilter("dim1", ColumnType.LONG, Arrays.asList(2L, 10L)), (List<String>)ImmutableList.of((Object)"b", (Object)"c"));
            this.assertTypedFilterMatches((DimFilter)InFilterTests.inFilter("dim1", ColumnType.DOUBLE, Arrays.asList(2.0, 10.0)), (List<String>)ImmutableList.of((Object)"b", (Object)"c"));
        }

        @Test
        public void testSingleValueStringColumnWithNulls() {
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim1", ColumnType.STRING, Arrays.asList(null, "")), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim1", ColumnType.STRING, Collections.singletonList("")), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim1", ColumnType.STRING, Arrays.asList("-1", "ab", "de")), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("s0", ColumnType.STRING, Arrays.asList("a", "b")), (List<String>)ImmutableList.of((Object)"b", (Object)"d", (Object)"f"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("s0", ColumnType.STRING, Collections.singletonList("noexist")), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim1", ColumnType.STRING, Arrays.asList(null, "10", "abc")), (List<String>)ImmutableList.of((Object)"b", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("dim1", ColumnType.STRING, Arrays.asList("-1", "ab", "de"))), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("s0", ColumnType.STRING, Arrays.asList("a", "b"))), (List<String>)ImmutableList.of((Object)"a", (Object)"e"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("s0", ColumnType.STRING, Collections.singletonList("noexist"))), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"d", (Object)"e", (Object)"f"));
        }

        @Test
        public void testMultiValueStringColumn() {
            Assume.assumeFalse((boolean)this.isAutoSchema());
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim2", ColumnType.STRING, Collections.singletonList(null)), (List<String>)ImmutableList.of((Object)"b", (Object)"f"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim2", ColumnType.STRING, Arrays.asList(null, "a")), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"d", (Object)"f"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim2", ColumnType.STRING, Arrays.asList(null, "b")), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"f"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim2", ColumnType.STRING, Collections.singletonList("")), (List<String>)ImmutableList.of((Object)"c"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim2", ColumnType.STRING, Arrays.asList("", null)), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"f"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim2", ColumnType.STRING, Collections.singletonList("c")), (List<String>)ImmutableList.of((Object)"e"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim2", ColumnType.STRING, Collections.singletonList("d")), (List<String>)ImmutableList.of());
        }

        @Test
        public void testMissingColumn() {
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim3", ColumnType.STRING, Arrays.asList(null, null)), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("dim3", ColumnType.STRING, Arrays.asList(null, null))), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim3", ColumnType.STRING, Arrays.asList(null, "a")), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim3", ColumnType.STRING, Collections.singletonList("a")), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim3", ColumnType.STRING, Collections.singletonList("b")), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim3", ColumnType.STRING, Collections.singletonList("c")), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("dim3", ColumnType.STRING, Collections.singletonList("")), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("dim3", ColumnType.STRING, Collections.singletonList(""))), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("dim3", ColumnType.STRING, Collections.singletonList("a"))), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("dim3", ColumnType.STRING, Arrays.asList(null, "a"))), (List<String>)ImmutableList.of());
        }

        @Test
        public void testNumeric() {
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("f0", ColumnType.FLOAT, Collections.singletonList(Float.valueOf(0.0f))), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("d0", ColumnType.DOUBLE, Collections.singletonList(0.0)), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("l0", ColumnType.LONG, Collections.singletonList(0L)), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("f0", ColumnType.FLOAT, Collections.singletonList(Float.valueOf(0.0f)))), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"d", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("d0", ColumnType.DOUBLE, Collections.singletonList(0.0))), (List<String>)ImmutableList.of((Object)"b", (Object)"d", (Object)"e", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("l0", ColumnType.LONG, Collections.singletonList(0L))), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"e", (Object)"f"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("f0", ColumnType.FLOAT, Collections.singletonList(null)), (List<String>)ImmutableList.of((Object)"e"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("d0", ColumnType.DOUBLE, Collections.singletonList(null)), (List<String>)ImmutableList.of((Object)"c"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("l0", ColumnType.LONG, Collections.singletonList(null)), (List<String>)ImmutableList.of((Object)"d"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("f0", ColumnType.FLOAT, Collections.singletonList(null))), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("d0", ColumnType.DOUBLE, Collections.singletonList(null))), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"d", (Object)"e", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.inFilter("l0", ColumnType.LONG, Collections.singletonList(null))), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"e", (Object)"f"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("f0", ColumnType.FLOAT, Arrays.asList("0", "999")), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("d0", ColumnType.DOUBLE, Arrays.asList("0", "999")), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("l0", ColumnType.LONG, Arrays.asList("0", "999")), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("f0", ColumnType.FLOAT, Arrays.asList(null, "999")), (List<String>)ImmutableList.of((Object)"e"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("d0", ColumnType.DOUBLE, Arrays.asList(null, "999")), (List<String>)ImmutableList.of((Object)"c"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("l0", ColumnType.LONG, Arrays.asList(null, "999")), (List<String>)ImmutableList.of((Object)"d"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("l0", ColumnType.LONG, Arrays.asList(100L, 9001L)), (List<String>)ImmutableList.of((Object)"b", (Object)"e"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("l0", ColumnType.FLOAT, Arrays.asList(Float.valueOf(100.0f), Float.valueOf(110.0f))), (List<String>)ImmutableList.of((Object)"b"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("l0", ColumnType.DOUBLE, Arrays.asList(100.0, 110.0)), (List<String>)ImmutableList.of((Object)"b"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("d0", ColumnType.DOUBLE, Arrays.asList(10.1, 120.0245)), (List<String>)ImmutableList.of((Object)"b", (Object)"d"));
            Assume.assumeFalse((boolean)this.isAutoSchema());
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("f0", ColumnType.FLOAT, Arrays.asList(Float.valueOf(10.1f), Float.valueOf(110.0f))), (List<String>)ImmutableList.of((Object)"b", (Object)"d"));
            this.assertFilterMatches((DimFilter)InFilterTests.inFilter("f0", ColumnType.DOUBLE, Arrays.asList(10.1, 110.0)), (List<String>)ImmutableList.of((Object)"b", (Object)"d"));
        }

        @Test
        public void testLegacyNumericDefaults() {
            this.assertLegacyFilterMatches((DimFilter)new InDimFilter("f0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null), (List<String>)ImmutableList.of((Object)"a"));
            this.assertLegacyFilterMatches((DimFilter)new InDimFilter("d0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null), (List<String>)ImmutableList.of((Object)"a"));
            this.assertLegacyFilterMatches((DimFilter)new InDimFilter("l0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null), (List<String>)ImmutableList.of((Object)"a"));
            this.assertLegacyFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("f0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null)), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"d", (Object)"f"));
            this.assertLegacyFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("d0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null)), (List<String>)ImmutableList.of((Object)"b", (Object)"d", (Object)"e", (Object)"f"));
            this.assertLegacyFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("l0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null)), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"e", (Object)"f"));
            this.assertLegacyFilterMatches((DimFilter)new InDimFilter("f0", Collections.singleton(null), null), (List<String>)ImmutableList.of((Object)"e"));
            this.assertLegacyFilterMatches((DimFilter)new InDimFilter("d0", Collections.singleton(null), null), (List<String>)ImmutableList.of((Object)"c"));
            this.assertLegacyFilterMatches((DimFilter)new InDimFilter("l0", Collections.singleton(null), null), (List<String>)ImmutableList.of((Object)"d"));
            this.assertLegacyFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("f0", Collections.singleton(null), null)), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"f"));
            this.assertLegacyFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("d0", Collections.singleton(null), null)), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"d", (Object)"e", (Object)"f"));
            this.assertLegacyFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("l0", Collections.singleton(null), null)), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"e", (Object)"f"));
            this.assertLegacyFilterMatches((DimFilter)new InDimFilter("f0", (Collection)Sets.newHashSet((Object[])new String[]{"0", "999"}), null), (List<String>)ImmutableList.of((Object)"a"));
            this.assertLegacyFilterMatches((DimFilter)new InDimFilter("d0", (Collection)Sets.newHashSet((Object[])new String[]{"0", "999"}), null), (List<String>)ImmutableList.of((Object)"a"));
            this.assertLegacyFilterMatches((DimFilter)new InDimFilter("l0", (Collection)Sets.newHashSet((Object[])new String[]{"0", "999"}), null), (List<String>)ImmutableList.of((Object)"a"));
            this.assertLegacyFilterMatches((DimFilter)new InDimFilter("f0", (Collection)Sets.newHashSet((Object[])new String[]{null, "999"}), null), (List<String>)ImmutableList.of((Object)"e"));
            this.assertLegacyFilterMatches((DimFilter)new InDimFilter("d0", (Collection)Sets.newHashSet((Object[])new String[]{null, "999"}), null), (List<String>)ImmutableList.of((Object)"c"));
            this.assertLegacyFilterMatches((DimFilter)new InDimFilter("l0", (Collection)Sets.newHashSet((Object[])new String[]{null, "999"}), null), (List<String>)ImmutableList.of((Object)"d"));
        }

        @Test
        public void testLegacyMatchWithExtractionFn() {
            String extractionJsFn = "function(str) { return 'super-' + str; }";
            JavaScriptExtractionFn superFn = new JavaScriptExtractionFn(extractionJsFn, false, JavaScriptConfig.getEnabledInstance());
            String nullJsFn = "function(str) { if (str === null) { return 'YES'; } else { return 'NO';} }";
            JavaScriptExtractionFn yesNullFn = new JavaScriptExtractionFn(nullJsFn, false, JavaScriptConfig.getEnabledInstance());
            this.assertFilterMatchesSkipArrays((DimFilter)InFilterTests.legacyInFilterWithFn("dim2", (ExtractionFn)superFn, "super-null", "super-a", "super-b"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"d", (Object)"f"));
            this.assertFilterMatchesSkipArrays((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.legacyInFilterWithFn("dim2", (ExtractionFn)superFn, "super-null", "super-a", "super-b")), (List<String>)ImmutableList.of((Object)"c", (Object)"e"));
            this.assertFilterMatchesSkipArrays((DimFilter)InFilterTests.legacyInFilterWithFn("dim2", (ExtractionFn)yesNullFn, "YES", new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"f"));
            this.assertFilterMatchesSkipArrays((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.legacyInFilterWithFn("dim2", (ExtractionFn)yesNullFn, "YES", new String[0])), (List<String>)ImmutableList.of((Object)"a", (Object)"c", (Object)"d", (Object)"e"));
            this.assertLegacyFilterMatches((DimFilter)InFilterTests.legacyInFilterWithFn("dim1", (ExtractionFn)superFn, "super-null", "super-10", "super-def"), (List<String>)ImmutableList.of((Object)"b", (Object)"e"));
            this.assertLegacyFilterMatches((DimFilter)InFilterTests.legacyInFilterWithFn("dim1", (ExtractionFn)yesNullFn, "NO", new String[0]), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
            this.assertLegacyFilterMatches((DimFilter)InFilterTests.legacyInFilterWithFn("dim3", (ExtractionFn)yesNullFn, "NO", new String[0]), (List<String>)ImmutableList.of());
            this.assertLegacyFilterMatches((DimFilter)NotDimFilter.of((DimFilter)InFilterTests.legacyInFilterWithFn("dim3", (ExtractionFn)yesNullFn, "NO", new String[0])), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
            this.assertLegacyFilterMatches((DimFilter)InFilterTests.legacyInFilterWithFn("dim3", (ExtractionFn)yesNullFn, "YES", new String[0]), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        }

        @Test
        public void testLegacyMatchWithLookupExtractionFn() {
            ImmutableMap stringMap = ImmutableMap.of((Object)"a", (Object)"HELLO", (Object)"10", (Object)"HELLO", (Object)"def", (Object)"HELLO", (Object)"c", (Object)"BYE");
            MapLookupExtractor mapExtractor = new MapLookupExtractor((Map)stringMap, false);
            LookupExtractionFn lookupFn = new LookupExtractionFn((LookupExtractor)mapExtractor, false, "UNKNOWN", Boolean.valueOf(false), Boolean.valueOf(true));
            this.assertLegacyFilterMatches((DimFilter)InFilterTests.legacyInFilterWithFn("dim0", (ExtractionFn)lookupFn, null, "HELLO"), (List<String>)ImmutableList.of((Object)"a"));
            this.assertLegacyFilterMatches((DimFilter)InFilterTests.legacyInFilterWithFn("dim0", (ExtractionFn)lookupFn, "HELLO", "BYE"), (List<String>)ImmutableList.of((Object)"a", (Object)"c"));
            this.assertLegacyFilterMatches((DimFilter)InFilterTests.legacyInFilterWithFn("dim0", (ExtractionFn)lookupFn, "UNKNOWN", new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"d", (Object)"e", (Object)"f"));
            this.assertLegacyFilterMatches((DimFilter)InFilterTests.legacyInFilterWithFn("dim1", (ExtractionFn)lookupFn, "HELLO", new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"e"));
            this.assertLegacyFilterMatches((DimFilter)InFilterTests.legacyInFilterWithFn("dim1", (ExtractionFn)lookupFn, "N/A", new String[0]), (List<String>)ImmutableList.of());
            if (this.optimize) {
                this.assertLegacyFilterMatches((DimFilter)InFilterTests.legacyInFilterWithFn("dim2", (ExtractionFn)lookupFn, "a", new String[0]), (List<String>)ImmutableList.of());
            } else {
                this.assertFilterMatchesSkipArrays((DimFilter)InFilterTests.legacyInFilterWithFn("dim2", (ExtractionFn)lookupFn, "a", new String[0]), (List<String>)ImmutableList.of());
            }
            this.assertFilterMatchesSkipArrays((DimFilter)InFilterTests.legacyInFilterWithFn("dim2", (ExtractionFn)lookupFn, "HELLO", new String[0]), (List<String>)ImmutableList.of((Object)"a", (Object)"d"));
            this.assertFilterMatchesSkipArrays((DimFilter)InFilterTests.legacyInFilterWithFn("dim2", (ExtractionFn)lookupFn, "HELLO", "BYE", "UNKNOWN"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
            ImmutableMap stringMap2 = ImmutableMap.of((Object)"a", (Object)"e");
            MapLookupExtractor mapExtractor2 = new MapLookupExtractor((Map)stringMap2, false);
            LookupExtractionFn lookupFn2 = new LookupExtractionFn((LookupExtractor)mapExtractor2, true, null, Boolean.valueOf(false), Boolean.valueOf(true));
            this.assertLegacyFilterMatches((DimFilter)InFilterTests.legacyInFilterWithFn("dim0", (ExtractionFn)lookupFn2, null, "e"), (List<String>)ImmutableList.of((Object)"a", (Object)"e"));
            this.assertLegacyFilterMatches((DimFilter)InFilterTests.legacyInFilterWithFn("dim0", (ExtractionFn)lookupFn2, "a", new String[0]), (List<String>)ImmutableList.of());
            ImmutableMap stringMap3 = ImmutableMap.of((Object)"c", (Object)"500", (Object)"100", (Object)"e");
            MapLookupExtractor mapExtractor3 = new MapLookupExtractor((Map)stringMap3, false);
            LookupExtractionFn lookupFn3 = new LookupExtractionFn((LookupExtractor)mapExtractor3, false, null, Boolean.valueOf(false), Boolean.valueOf(true));
            this.assertLegacyFilterMatches((DimFilter)InFilterTests.legacyInFilterWithFn("dim0", (ExtractionFn)lookupFn3, null, "c"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"d", (Object)"e", (Object)"f"));
            this.assertLegacyFilterMatches((DimFilter)InFilterTests.legacyInFilterWithFn("dim0", (ExtractionFn)lookupFn3, "e", new String[0]), (List<String>)ImmutableList.of());
        }

        @Override
        protected void assertFilterMatches(DimFilter filter, List<String> expectedRows) {
            this.assertTypedFilterMatches(filter, expectedRows);
            this.assertLegacyFilterMatches(filter, expectedRows);
        }

        private void assertTypedFilterMatches(DimFilter filter, List<String> expectedRows) {
            super.assertFilterMatches(filter, expectedRows);
            try {
                super.assertFilterMatches((DimFilter)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString((Object)filter), DimFilter.class), expectedRows);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        private void assertLegacyFilterMatches(DimFilter filter, List<String> expectedRows) {
            DimFilter newFilter = this.rewriteToLegacyFilter(filter);
            if (newFilter != null) {
                super.assertFilterMatches(newFilter, expectedRows);
            }
        }

        @Nullable
        private DimFilter rewriteToLegacyFilter(DimFilter filter) {
            DimFilter rewrite;
            if (filter instanceof InDimFilter) {
                return filter;
            }
            if (filter instanceof TypedInFilter) {
                TypedInFilter theFilter = (TypedInFilter)filter;
                return new InDimFilter(theFilter.getColumn(), (Collection)InDimFilter.ValuesSet.copyOf((Collection)theFilter.getSortedValues().stream().map(DimensionHandlerUtils::convertObjectToString).collect(Collectors.toList())), null);
            }
            if (filter instanceof NotDimFilter && (rewrite = this.rewriteToLegacyFilter(((NotDimFilter)filter).getField())) != null) {
                return NotDimFilter.of((DimFilter)rewrite);
            }
            return null;
        }
    }
}

