/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCreator;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IncrementalIndexMultiValueSpecTest
extends InitializedNullHandlingTest {
    public final IncrementalIndexCreator indexCreator;
    @Rule
    public final CloserRule closer = new CloserRule(false);

    public IncrementalIndexMultiValueSpecTest(String indexType) throws JsonProcessingException {
        BuiltInTypesModule.registerHandlersAndSerde();
        this.indexCreator = this.closer.closeLater(new IncrementalIndexCreator(indexType, (builder, args) -> builder.setIndexSchema((IncrementalIndexSchema)args[0]).setMaxRowCount(10000).build()));
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<?> constructorFeeder() {
        return IncrementalIndexCreator.getAppendableIndexTypes();
    }

    @Test
    public void test() throws IndexSizeExceededException {
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("string1", DimensionSchema.MultiValueHandling.ARRAY, Boolean.valueOf(true)), new StringDimensionSchema("string2", DimensionSchema.MultiValueHandling.SORTED_ARRAY, Boolean.valueOf(true)), new StringDimensionSchema("string3", DimensionSchema.MultiValueHandling.SORTED_SET, Boolean.valueOf(true))));
        IncrementalIndexSchema schema = IncrementalIndexSchema.builder().withTimestampSpec(new TimestampSpec("ds", "auto", null)).withDimensionsSpec(dimensionsSpec).withRollup(false).build();
        HashMap<String, Object> map = new HashMap<String, Object>(){

            @Override
            public Object get(Object key) {
                if (((String)key).startsWith("string")) {
                    return Arrays.asList("xsd", "aba", "fds", "aba");
                }
                if (((String)key).startsWith("float")) {
                    return Arrays.asList(Float.valueOf(3.92f), Float.valueOf(-2.76f), Float.valueOf(42.153f), Float.valueOf(Float.NaN), Float.valueOf(-2.76f), Float.valueOf(-2.76f));
                }
                if (((String)key).startsWith("long")) {
                    return Arrays.asList(-231238789L, 328L, 923L, 328L, -2L, 0L);
                }
                return null;
            }
        };
        IncrementalIndex index = this.indexCreator.createIndex(schema);
        index.add((InputRow)new MapBasedInputRow(0L, Arrays.asList("string1", "string2", "string3", "float1", "float2", "float3", "long1", "long2", "long3"), (Map)map));
        Row row = (Row)index.iterator().next();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"xsd", "aba", "fds", "aba"}), (Object)row.getRaw("string1"));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"aba", "aba", "fds", "xsd"}), (Object)row.getRaw("string2"));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"aba", "fds", "xsd"}), (Object)row.getRaw("string3"));
    }
}

