/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.join.HashJoinSegment;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinTestHelper;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.filter.JoinFilterAnalyzer;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysisKey;
import org.apache.druid.segment.join.filter.rewrite.JoinFilterRewriteConfig;
import org.apache.druid.segment.join.lookup.LookupJoinable;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableJoinable;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class BaseHashJoinSegmentCursorFactoryTest
extends InitializedNullHandlingTest {
    public static JoinFilterRewriteConfig DEFAULT_JOIN_FILTER_REWRITE_CONFIG = new JoinFilterRewriteConfig(true, true, true, true, 10000L);
    public static final String FACT_TO_COUNTRY_ON_ISO_CODE_PREFIX = "c1.";
    public static final String FACT_TO_COUNTRY_ON_NUMBER_PREFIX = "c2.";
    public static final String FACT_TO_REGION_PREFIX = "r1.";
    public static final String REGION_TO_COUNTRY_PREFIX = "rtc.";
    public static Long NULL_COUNTRY;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    public QueryableIndexSegment factSegment;
    public LookupExtractor countryIsoCodeToNameLookup;
    public LookupExtractor countryNumberToNameLookup;
    public IndexedTable countriesTable;
    public IndexedTable regionsTable;

    @BeforeClass
    public static void setUpStatic() {
        NULL_COUNTRY = null;
    }

    @Before
    public void setUp() throws IOException {
        this.factSegment = new QueryableIndexSegment(JoinTestHelper.createFactIndexBuilder(this.temporaryFolder.newFolder()).buildMMappedIndex(), SegmentId.dummy((String)"facts"));
        this.countryIsoCodeToNameLookup = JoinTestHelper.createCountryIsoCodeToNameLookup();
        this.countryNumberToNameLookup = JoinTestHelper.createCountryNumberToNameLookup();
        this.countriesTable = JoinTestHelper.createCountriesIndexedTable();
        this.regionsTable = JoinTestHelper.createRegionsIndexedTable();
    }

    @After
    public void tearDown() {
        if (this.factSegment != null) {
            this.factSegment.close();
        }
    }

    protected JoinableClause factToCountryNameUsingIsoCodeLookup(JoinType joinType) {
        return new JoinableClause(FACT_TO_COUNTRY_ON_ISO_CODE_PREFIX, (Joinable)LookupJoinable.wrap((LookupExtractor)this.countryIsoCodeToNameLookup), joinType, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sk\" == countryIsoCode", (Object[])new Object[]{FACT_TO_COUNTRY_ON_ISO_CODE_PREFIX}), (String)FACT_TO_COUNTRY_ON_ISO_CODE_PREFIX, (ExprMacroTable)ExprMacroTable.nil()));
    }

    protected JoinableClause factToCountryNameUsingNumberLookup(JoinType joinType) {
        return new JoinableClause(FACT_TO_COUNTRY_ON_NUMBER_PREFIX, (Joinable)LookupJoinable.wrap((LookupExtractor)this.countryNumberToNameLookup), joinType, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sk\" == countryNumber", (Object[])new Object[]{FACT_TO_COUNTRY_ON_NUMBER_PREFIX}), (String)FACT_TO_COUNTRY_ON_NUMBER_PREFIX, (ExprMacroTable)ExprMacroTable.nil()));
    }

    protected JoinableClause factToCountryOnIsoCode(JoinType joinType) {
        return new JoinableClause(FACT_TO_COUNTRY_ON_ISO_CODE_PREFIX, (Joinable)new IndexedTableJoinable(this.countriesTable), joinType, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%scountryIsoCode\" == countryIsoCode", (Object[])new Object[]{FACT_TO_COUNTRY_ON_ISO_CODE_PREFIX}), (String)FACT_TO_COUNTRY_ON_ISO_CODE_PREFIX, (ExprMacroTable)ExprMacroTable.nil()));
    }

    protected JoinableClause factToCountryOnNumber(JoinType joinType) {
        return new JoinableClause(FACT_TO_COUNTRY_ON_NUMBER_PREFIX, (Joinable)new IndexedTableJoinable(this.countriesTable), joinType, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%scountryNumber\" == countryNumber", (Object[])new Object[]{FACT_TO_COUNTRY_ON_NUMBER_PREFIX}), (String)FACT_TO_COUNTRY_ON_NUMBER_PREFIX, (ExprMacroTable)ExprMacroTable.nil()));
    }

    protected JoinableClause factToRegion(JoinType joinType) {
        return new JoinableClause(FACT_TO_REGION_PREFIX, (Joinable)new IndexedTableJoinable(this.regionsTable), joinType, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sregionIsoCode\" == regionIsoCode && \"%scountryIsoCode\" == countryIsoCode", (Object[])new Object[]{FACT_TO_REGION_PREFIX, FACT_TO_REGION_PREFIX}), (String)FACT_TO_REGION_PREFIX, (ExprMacroTable)ExprMacroTable.nil()));
    }

    protected JoinableClause factToRegionIncludeNull(JoinType joinType) {
        return new JoinableClause(FACT_TO_REGION_PREFIX, (Joinable)new IndexedTableJoinable(this.regionsTable), joinType, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"notdistinctfrom(\"%sregionIsoCode\", regionIsoCode) && notdistinctfrom(\"%scountryIsoCode\", countryIsoCode)", (Object[])new Object[]{FACT_TO_REGION_PREFIX, FACT_TO_REGION_PREFIX}), (String)FACT_TO_REGION_PREFIX, (ExprMacroTable)ExprMacroTable.nil()));
    }

    protected JoinableClause regionToCountry(JoinType joinType) {
        return new JoinableClause(REGION_TO_COUNTRY_PREFIX, (Joinable)new IndexedTableJoinable(this.countriesTable), joinType, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%scountryIsoCode\" == \"%scountryIsoCode\"", (Object[])new Object[]{FACT_TO_REGION_PREFIX, REGION_TO_COUNTRY_PREFIX}), (String)REGION_TO_COUNTRY_PREFIX, (ExprMacroTable)ExprMacroTable.nil()));
    }

    protected HashJoinSegment makeFactToCountrySegment() {
        return this.makeFactToCountrySegment(JoinType.LEFT);
    }

    protected HashJoinSegment makeFactToCountrySegment(JoinType joinType) {
        return new HashJoinSegment((SegmentReference)ReferenceCountingSegment.wrapRootGenerationSegment((Segment)this.factSegment), null, (List)ImmutableList.of((Object)this.factToCountryOnIsoCode(joinType)), null);
    }

    protected void compareExpressionVirtualColumns(ExpressionVirtualColumn expectedVirtualColumn, ExpressionVirtualColumn actualVirtualColumn) {
        Assert.assertEquals((Object)expectedVirtualColumn.getOutputName(), (Object)actualVirtualColumn.getOutputName());
        Assert.assertEquals((Object)expectedVirtualColumn.getOutputType(), (Object)actualVirtualColumn.getOutputType());
        Assert.assertEquals((Object)((Expr)expectedVirtualColumn.getParsedExpression().get()).toString(), (Object)((Expr)actualVirtualColumn.getParsedExpression().get()).toString());
    }

    protected static JoinFilterPreAnalysis makeDefaultConfigPreAnalysis(Filter originalFilter, List<JoinableClause> joinableClauses, VirtualColumns virtualColumns) {
        Filter filterToUse = Filters.maybeAnd(Collections.singletonList(originalFilter)).orElse(null);
        return JoinFilterAnalyzer.computeJoinFilterPreAnalysis((JoinFilterPreAnalysisKey)new JoinFilterPreAnalysisKey(DEFAULT_JOIN_FILTER_REWRITE_CONFIG, joinableClauses, virtualColumns, filterToUse));
    }

    protected VirtualColumn makeExpressionVirtualColumn(String expression) {
        return this.makeExpressionVirtualColumn(expression, "virtual");
    }

    protected VirtualColumn makeExpressionVirtualColumn(String expression, String columnName) {
        return new ExpressionVirtualColumn(columnName, expression, ColumnType.STRING, ExprMacroTable.nil());
    }
}

