/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.groupby.DeferExpressionDimensions;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionPlan;
import org.apache.druid.segment.virtual.ExpressionPlanner;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ExpressionPlannerTest
extends InitializedNullHandlingTest {
    private static ColumnType DICTIONARY_COMPLEX = ColumnType.ofComplex((String)"dictionaryComplex");
    private static final ColumnInspector SYNTHETIC_INSPECTOR = new ColumnInspector(){
        private final Map<String, ColumnCapabilities> capabilitiesMap = ImmutableMap.builder().put((Object)"long1", (Object)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.LONG)).put((Object)"long2", (Object)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.LONG)).put((Object)"float1", (Object)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.FLOAT)).put((Object)"float2", (Object)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.FLOAT)).put((Object)"double1", (Object)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.DOUBLE)).put((Object)"double2", (Object)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.DOUBLE)).put((Object)"scalar_string", (Object)ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities()).put((Object)"scalar_dictionary_string", (Object)new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(true).setHasBitmapIndexes(true).setDictionaryValuesSorted(true).setDictionaryValuesUnique(true).setHasMultipleValues(false)).put((Object)"scalar_dictionary_string_nonunique", (Object)new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(true).setHasBitmapIndexes(false).setDictionaryValuesSorted(false).setDictionaryValuesUnique(false).setHasMultipleValues(false)).put((Object)"string_unknown", (Object)new ColumnCapabilitiesImpl().setType(ColumnType.STRING)).put((Object)"multi_dictionary_string", (Object)new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(true).setHasBitmapIndexes(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasMultipleValues(true)).put((Object)"multi_dictionary_string_nonunique", (Object)new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(false).setHasBitmapIndexes(false).setDictionaryValuesUnique(false).setDictionaryValuesSorted(false).setHasMultipleValues(true)).put((Object)"string_array_1", (Object)ColumnCapabilitiesImpl.createSimpleArrayColumnCapabilities((TypeSignature)ColumnType.STRING_ARRAY)).put((Object)"string_array_2", (Object)ColumnCapabilitiesImpl.createSimpleArrayColumnCapabilities((TypeSignature)ColumnType.STRING_ARRAY)).put((Object)"long_array_1", (Object)ColumnCapabilitiesImpl.createSimpleArrayColumnCapabilities((TypeSignature)ColumnType.LONG_ARRAY)).put((Object)"long_array_2", (Object)ColumnCapabilitiesImpl.createSimpleArrayColumnCapabilities((TypeSignature)ColumnType.LONG_ARRAY)).put((Object)"double_array_1", (Object)ColumnCapabilitiesImpl.createSimpleArrayColumnCapabilities((TypeSignature)ColumnType.DOUBLE_ARRAY)).put((Object)"double_array_2", (Object)ColumnCapabilitiesImpl.createSimpleArrayColumnCapabilities((TypeSignature)ColumnType.DOUBLE_ARRAY)).put((Object)"dictionary_complex", (Object)ColumnCapabilitiesImpl.createDefault().setDictionaryEncoded(true).setType(DICTIONARY_COMPLEX)).build();

        @Nullable
        public ColumnCapabilities getColumnCapabilities(String column) {
            return this.capabilitiesMap.get(column);
        }
    };
    private static final TestMacroTable MACRO_TABLE = new TestMacroTable();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testUnknown() {
        ExpressionPlan thePlan = ExpressionPlannerTest.plan("concat(x, 'x')");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.VECTORIZABLE}));
        Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.NON_SCALAR_OUTPUT, ExpressionPlan.Trait.CONSTANT}));
        Assert.assertEquals((Object)"concat(\"x\", 'x')", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"concat(\"x\", 'x')", (Object)thePlan.getAppliedFoldExpression("__acc").stringify());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)thePlan.getOutputType());
        ColumnCapabilities inferred = thePlan.inferColumnCapabilities(null);
        Assert.assertNotNull((Object)inferred);
        Assert.assertEquals((Object)ValueType.STRING, (Object)inferred.getType());
        Assert.assertTrue((boolean)inferred.hasNulls().isTrue());
        Assert.assertFalse((boolean)inferred.isDictionaryEncoded().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesSorted().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesUnique().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasBitmapIndexes());
        Assert.assertFalse((boolean)inferred.hasSpatialIndexes());
        thePlan = ExpressionPlannerTest.plan("x * y");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.UNKNOWN_INPUTS}));
        Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.VECTORIZABLE, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.NON_SCALAR_OUTPUT, ExpressionPlan.Trait.CONSTANT}));
        Assert.assertEquals((Object)"(\"x\" * \"y\")", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"(\"x\" * \"y\")", (Object)thePlan.getAppliedFoldExpression("__acc").stringify());
        Assert.assertNull((Object)thePlan.getOutputType());
        Assert.assertNull((Object)thePlan.inferColumnCapabilities(null));
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
    }

    @Test
    public void testScalarStringNondictionaryEncoded() {
        ExpressionPlan thePlan = ExpressionPlannerTest.plan("concat(scalar_string, 'x')");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.VECTORIZABLE}));
        Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.NON_SCALAR_OUTPUT}));
        Assert.assertEquals((Object)"concat(\"scalar_string\", 'x')", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"concat(\"scalar_string\", 'x')", (Object)thePlan.getAppliedFoldExpression("__acc").stringify());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)thePlan.getOutputType());
        ColumnCapabilities inferred = thePlan.inferColumnCapabilities(null);
        Assert.assertNotNull((Object)inferred);
        Assert.assertEquals((Object)ValueType.STRING, (Object)inferred.getType());
        Assert.assertTrue((boolean)inferred.hasNulls().isTrue());
        Assert.assertFalse((boolean)inferred.isDictionaryEncoded().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesSorted().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesUnique().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasBitmapIndexes());
        Assert.assertFalse((boolean)inferred.hasSpatialIndexes());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
    }

    @Test
    public void testScalarNumeric() {
        ExpressionPlan thePlan = ExpressionPlannerTest.plan("long1 + 5");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.VECTORIZABLE}));
        Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.NON_SCALAR_OUTPUT}));
        Assert.assertEquals((Object)"(\"long1\" + 5)", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"(\"long1\" + 5)", (Object)thePlan.getAppliedFoldExpression("__acc").stringify());
        Assert.assertEquals((Object)"(\"long1\" + 5)", (Object)thePlan.getAppliedFoldExpression("long1").stringify());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)thePlan.getOutputType());
        ColumnCapabilities inferred = thePlan.inferColumnCapabilities(null);
        Assert.assertNotNull((Object)inferred);
        Assert.assertEquals((Object)ValueType.LONG, (Object)inferred.getType());
        Assert.assertTrue((boolean)inferred.hasNulls().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.isDictionaryEncoded().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesSorted().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesUnique().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasBitmapIndexes());
        Assert.assertFalse((boolean)inferred.hasSpatialIndexes());
        thePlan = ExpressionPlannerTest.plan("long1 + 5.0");
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)thePlan.getOutputType());
        thePlan = ExpressionPlannerTest.plan("double1 * double2");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.VECTORIZABLE}));
        Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.NON_SCALAR_OUTPUT}));
        Assert.assertEquals((Object)"(\"double1\" * \"double2\")", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"(\"double1\" * \"double2\")", (Object)thePlan.getAppliedFoldExpression("__acc").stringify());
        Assert.assertEquals((Object)"(\"double1\" * \"double2\")", (Object)thePlan.getAppliedFoldExpression("double1").stringify());
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)thePlan.getOutputType());
        inferred = thePlan.inferColumnCapabilities(null);
        Assert.assertNotNull((Object)inferred);
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)inferred.getType());
        Assert.assertTrue((boolean)inferred.hasNulls().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.isDictionaryEncoded().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesSorted().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesUnique().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasBitmapIndexes());
        Assert.assertFalse((boolean)inferred.hasSpatialIndexes());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertTrue((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
    }

    @Test
    public void testScalarStringDictionaryEncoded() {
        ExpressionPlan thePlan = ExpressionPlannerTest.plan("concat(scalar_dictionary_string, 'x')");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.VECTORIZABLE}));
        Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.NON_SCALAR_OUTPUT}));
        Assert.assertEquals((Object)"concat(\"scalar_dictionary_string\", 'x')", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"concat(\"scalar_dictionary_string\", 'x')", (Object)thePlan.getAppliedFoldExpression("__acc").stringify());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)thePlan.getOutputType());
        ColumnCapabilities inferred = thePlan.inferColumnCapabilities(null);
        Assert.assertNotNull((Object)inferred);
        Assert.assertEquals((Object)ValueType.STRING, (Object)inferred.getType());
        Assert.assertTrue((boolean)inferred.hasNulls().isTrue());
        Assert.assertTrue((boolean)inferred.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesSorted().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesUnique().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasMultipleValues().isMaybeTrue());
        Assert.assertTrue((boolean)inferred.hasBitmapIndexes());
        Assert.assertFalse((boolean)inferred.hasSpatialIndexes());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        thePlan = ExpressionPlannerTest.plan("concat(scalar_dictionary_string, scalar_dictionary_string_nonunique)");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.VECTORIZABLE}));
        Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.NON_SCALAR_OUTPUT}));
        Assert.assertEquals((Object)"concat(\"scalar_dictionary_string\", \"scalar_dictionary_string_nonunique\")", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"concat(\"scalar_dictionary_string\", \"scalar_dictionary_string_nonunique\")", (Object)thePlan.getAppliedFoldExpression("__acc").stringify());
        Assert.assertEquals((Object)"concat(\"scalar_dictionary_string\", \"scalar_dictionary_string_nonunique\")", (Object)thePlan.getAppliedFoldExpression("scalar_dictionary_string_nonunique").stringify());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)thePlan.getOutputType());
        inferred = thePlan.inferColumnCapabilities(null);
        Assert.assertNotNull((Object)inferred);
        Assert.assertEquals((Object)ValueType.STRING, (Object)inferred.getType());
        Assert.assertTrue((boolean)inferred.hasNulls().isTrue());
        Assert.assertFalse((boolean)inferred.isDictionaryEncoded().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesSorted().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesUnique().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasBitmapIndexes());
        Assert.assertFalse((boolean)inferred.hasSpatialIndexes());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertTrue((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertTrue((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        thePlan = ExpressionPlannerTest.plan("array(scalar_dictionary_string)");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NON_SCALAR_OUTPUT}));
        Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.VECTORIZABLE}));
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertTrue((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertTrue((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
    }

    @Test
    public void testMultiValueStringDictionaryEncoded() {
        ExpressionPlan thePlan = ExpressionPlannerTest.plan("concat(multi_dictionary_string, 'x')");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE}));
        Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.NON_SCALAR_OUTPUT, ExpressionPlan.Trait.VECTORIZABLE}));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)thePlan.getOutputType());
        ColumnCapabilities inferred = thePlan.inferColumnCapabilities(null);
        Assert.assertNotNull((Object)inferred);
        Assert.assertEquals((Object)ValueType.STRING, (Object)inferred.getType());
        Assert.assertTrue((boolean)inferred.hasNulls().isMaybeTrue());
        Assert.assertTrue((boolean)inferred.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesSorted().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesUnique().isMaybeTrue());
        Assert.assertTrue((boolean)inferred.hasMultipleValues().isTrue());
        Assert.assertTrue((boolean)inferred.hasBitmapIndexes());
        Assert.assertFalse((boolean)inferred.hasSpatialIndexes());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        thePlan = ExpressionPlannerTest.plan("concat(scalar_string, multi_dictionary_string_nonunique)");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NEEDS_APPLIED}));
        Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.NON_SCALAR_OUTPUT, ExpressionPlan.Trait.VECTORIZABLE}));
        Assert.assertEquals((Object)"map((\"multi_dictionary_string_nonunique\") -> concat(\"scalar_string\", \"multi_dictionary_string_nonunique\"), \"multi_dictionary_string_nonunique\")", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"fold((\"multi_dictionary_string_nonunique\", \"scalar_string\") -> concat(\"scalar_string\", \"multi_dictionary_string_nonunique\"), \"multi_dictionary_string_nonunique\", \"scalar_string\")", (Object)thePlan.getAppliedFoldExpression("scalar_string").stringify());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)thePlan.getOutputType());
        inferred = thePlan.inferColumnCapabilities(null);
        Assert.assertNotNull((Object)inferred);
        Assert.assertEquals((Object)ValueType.STRING, (Object)inferred.getType());
        Assert.assertTrue((boolean)inferred.hasMultipleValues().isTrue());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        thePlan = ExpressionPlannerTest.plan("concat(multi_dictionary_string, multi_dictionary_string_nonunique)");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NEEDS_APPLIED}));
        Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.NON_SCALAR_OUTPUT, ExpressionPlan.Trait.VECTORIZABLE}));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)thePlan.getOutputType());
        Assert.assertEquals((Object)"cartesian_map((\"multi_dictionary_string\", \"multi_dictionary_string_nonunique\") -> concat(\"multi_dictionary_string\", \"multi_dictionary_string_nonunique\"), \"multi_dictionary_string\", \"multi_dictionary_string_nonunique\")", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"cartesian_fold((\"multi_dictionary_string\", \"multi_dictionary_string_nonunique\", \"__acc\") -> concat(\"multi_dictionary_string\", \"multi_dictionary_string_nonunique\"), \"multi_dictionary_string\", \"multi_dictionary_string_nonunique\", \"__acc\")", (Object)thePlan.getAppliedFoldExpression("__acc").stringify());
        inferred = thePlan.inferColumnCapabilities(null);
        Assert.assertNotNull((Object)inferred);
        Assert.assertEquals((Object)ValueType.STRING, (Object)inferred.getType());
        Assert.assertTrue((boolean)inferred.hasMultipleValues().isTrue());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        thePlan = ExpressionPlannerTest.plan("array_append(multi_dictionary_string, 'foo')");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NON_SCALAR_OUTPUT}));
        Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.VECTORIZABLE}));
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
    }

    @Test
    public void testMultiValueStringDictionaryEncodedIllegalAccumulator() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Accumulator cannot be implicitly transformed, if it is an ARRAY or multi-valued type it must be used explicitly as such");
        ExpressionPlan thePlan = ExpressionPlannerTest.plan("concat(multi_dictionary_string, 'x')");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE}));
        Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.NON_SCALAR_OUTPUT, ExpressionPlan.Trait.VECTORIZABLE}));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)thePlan.getOutputType());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        thePlan = ExpressionPlannerTest.plan("concat(multi_dictionary_string, multi_dictionary_string_nonunique)");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NEEDS_APPLIED}));
        Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.NON_SCALAR_OUTPUT, ExpressionPlan.Trait.VECTORIZABLE}));
        thePlan.getAppliedFoldExpression("multi_dictionary_string");
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)thePlan.getOutputType());
    }

    @Test
    public void testIncompleteString() {
        ExpressionPlan thePlan = ExpressionPlannerTest.plan("concat(string_unknown, 'x')");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.INCOMPLETE_INPUTS}));
        Assert.assertFalse((boolean)thePlan.any(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.NON_SCALAR_OUTPUT, ExpressionPlan.Trait.VECTORIZABLE}));
        Assert.assertEquals((Object)"concat(\"string_unknown\", 'x')", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"concat(\"string_unknown\", 'x')", (Object)thePlan.getAppliedFoldExpression("__acc").stringify());
        Assert.assertNull((Object)thePlan.getOutputType());
        Assert.assertNull((Object)thePlan.inferColumnCapabilities(null));
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
    }

    @Test
    public void testArrayOutput() {
        ExpressionPlan thePlan = ExpressionPlannerTest.plan("array_append(scalar_string, 'x')");
        ExpressionPlannerTest.assertArrayInAndOut(thePlan);
        ColumnCapabilities inferred = thePlan.inferColumnCapabilities(ColumnType.STRING);
        Assert.assertNotNull((Object)inferred);
        Assert.assertEquals((Object)ValueType.STRING, (Object)inferred.getType());
        Assert.assertTrue((boolean)inferred.hasNulls().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.isDictionaryEncoded().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesSorted().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesUnique().isMaybeTrue());
        Assert.assertTrue((boolean)inferred.hasMultipleValues().isTrue());
        Assert.assertFalse((boolean)inferred.hasBitmapIndexes());
        Assert.assertFalse((boolean)inferred.hasSpatialIndexes());
        inferred = thePlan.inferColumnCapabilities(ColumnType.STRING_ARRAY);
        Assert.assertNotNull((Object)inferred);
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, (Object)inferred.toColumnType());
        Assert.assertTrue((boolean)inferred.hasNulls().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.isDictionaryEncoded().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesSorted().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesUnique().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasBitmapIndexes());
        Assert.assertFalse((boolean)inferred.hasSpatialIndexes());
        Assert.assertEquals((Object)"array_append(\"scalar_string\", 'x')", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"array_append(\"scalar_string\", 'x')", (Object)thePlan.getAppliedFoldExpression("__acc").stringify());
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)thePlan.getOutputType());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        thePlan = ExpressionPlannerTest.plan("array_append(multi_dictionary_string, 'x')");
        ExpressionPlannerTest.assertArrayInAndOut(thePlan);
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        thePlan = ExpressionPlannerTest.plan("array_append(string_unknown, 'x')");
        ExpressionPlannerTest.assertArrayInAndOut(thePlan);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)thePlan.getOutputType());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        thePlan = ExpressionPlannerTest.plan("array_append(multi_dictionary_string, string_unknown)");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.NON_SCALAR_OUTPUT}));
        Assert.assertFalse((boolean)thePlan.any(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.VECTORIZABLE}));
        Assert.assertNull((Object)thePlan.getOutputType());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        thePlan = ExpressionPlannerTest.plan("array_append(string_array_1, 'x')");
        ExpressionPlannerTest.assertArrayInAndOut(thePlan);
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        thePlan = ExpressionPlannerTest.plan("array_append(string_array_1, 'x')");
        ExpressionPlannerTest.assertArrayInAndOut(thePlan);
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
    }

    @Test
    public void testScalarOutputMultiValueInput() {
        ExpressionPlan thePlan = ExpressionPlannerTest.plan("array_to_string(array_append(scalar_string, 'x'), ',')");
        ExpressionPlannerTest.assertArrayInput(thePlan);
        ColumnCapabilities inferred = thePlan.inferColumnCapabilities(ColumnType.STRING);
        Assert.assertNotNull((Object)inferred);
        Assert.assertEquals((Object)ValueType.STRING, (Object)inferred.getType());
        Assert.assertTrue((boolean)inferred.hasNulls().isTrue());
        Assert.assertFalse((boolean)inferred.isDictionaryEncoded().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesSorted().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.areDictionaryValuesUnique().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)inferred.hasBitmapIndexes());
        Assert.assertFalse((boolean)inferred.hasSpatialIndexes());
        Assert.assertEquals((Object)"array_to_string(array_append(\"scalar_string\", 'x'), ',')", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"array_to_string(array_append(\"scalar_string\", 'x'), ',')", (Object)thePlan.getAppliedFoldExpression("__acc").stringify());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)thePlan.getOutputType());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        thePlan = ExpressionPlannerTest.plan("array_to_string(array_append(scalar_string, multi_dictionary_string), ',')");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED}));
        Assert.assertFalse((boolean)thePlan.any(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.NON_SCALAR_OUTPUT, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS}));
        ExpressionPlannerTest.assertFallbackVectorizable(thePlan);
        Assert.assertEquals((Object)"array_to_string(map((\"multi_dictionary_string\") -> array_append(\"scalar_string\", \"multi_dictionary_string\"), \"multi_dictionary_string\"), ',')", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"array_to_string(fold((\"multi_dictionary_string\", \"scalar_string\") -> array_append(\"scalar_string\", \"multi_dictionary_string\"), \"multi_dictionary_string\", \"scalar_string\"), ',')", (Object)thePlan.getAppliedFoldExpression("scalar_string").stringify());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)thePlan.getOutputType());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
    }

    @Test
    public void testScalarOutputArrayInput() {
        ExpressionPlan thePlan = ExpressionPlannerTest.plan("array_to_string(array_append(string_array_1, 'x'), ',')");
        ExpressionPlannerTest.assertArrayInput(thePlan);
        Assert.assertEquals((Object)"array_to_string(array_append(\"string_array_1\", 'x'), ',')", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"array_to_string(array_append(\"string_array_1\", 'x'), ',')", (Object)thePlan.getAppliedFoldExpression("__acc").stringify());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)thePlan.getOutputType());
        thePlan = ExpressionPlannerTest.plan("array_to_string(array_concat(string_array_1, string_array_2), ',')");
        ExpressionPlannerTest.assertArrayInput(thePlan);
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)thePlan.getOutputType());
        thePlan = ExpressionPlannerTest.plan("fold((x, acc) -> acc + x, array_concat(long_array_1, long_array_2), 0)");
        ExpressionPlannerTest.assertArrayInput(thePlan);
        Assert.assertEquals((Object)"fold((\"x\", \"acc\") -> (\"acc\" + \"x\"), array_concat(\"long_array_1\", \"long_array_2\"), 0)", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"fold((\"x\", \"acc\") -> (\"acc\" + \"x\"), array_concat(\"long_array_1\", \"long_array_2\"), 0)", (Object)thePlan.getAppliedFoldExpression("__acc").stringify());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)thePlan.getOutputType());
        thePlan = ExpressionPlannerTest.plan("fold((x, acc) -> acc * x, array_concat(double_array_1, double_array_2), 0.0)");
        ExpressionPlannerTest.assertArrayInput(thePlan);
        Assert.assertEquals((Object)"fold((\"x\", \"acc\") -> (\"acc\" * \"x\"), array_concat(\"double_array_1\", \"double_array_2\"), 0.0)", (Object)thePlan.getAppliedExpression().stringify());
        Assert.assertEquals((Object)"fold((\"x\", \"acc\") -> (\"acc\" * \"x\"), array_concat(\"double_array_1\", \"double_array_2\"), 0.0)", (Object)thePlan.getAppliedFoldExpression("__acc").stringify());
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)thePlan.getOutputType());
    }

    @Test
    public void testArrayConstruction() {
        ExpressionPlan thePlan = ExpressionPlannerTest.plan("array(long1, long2)");
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NON_SCALAR_OUTPUT}));
        Assert.assertFalse((boolean)thePlan.any(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.NON_SCALAR_INPUTS}));
        ExpressionPlannerTest.assertFallbackVectorizable(thePlan);
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)thePlan.getOutputType());
        thePlan = ExpressionPlannerTest.plan("array(long1, double1)");
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)thePlan.getOutputType());
        thePlan = ExpressionPlannerTest.plan("array(long1, double1, scalar_string)");
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)thePlan.getOutputType());
    }

    @Test
    public void testNestedColumnExpression() {
        ExpressionPlan thePlan = ExpressionPlannerTest.plan("json_object('long1', long1, 'long2', long2)");
        Assert.assertFalse((boolean)thePlan.any(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NON_SCALAR_OUTPUT, ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.NON_SCALAR_INPUTS}));
        Assert.assertEquals((Object)ExpressionType.NESTED_DATA, (Object)thePlan.getOutputType());
        ColumnCapabilities inferred = thePlan.inferColumnCapabilities(ExpressionType.toColumnType((ExpressionType)thePlan.getOutputType()));
        Assert.assertEquals((Object)ColumnType.NESTED_DATA.getType(), (Object)inferred.getType());
        Assert.assertEquals((Object)ColumnType.NESTED_DATA.getComplexTypeName(), (Object)inferred.getComplexTypeName());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertTrue((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertTrue((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
    }

    @Test
    public void testDictionaryComplexStringOutput() {
        ExpressionPlan thePlan = ExpressionPlannerTest.plan("dict_complex_to_string(dictionary_complex)");
        Assert.assertFalse((boolean)thePlan.any(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NON_SCALAR_OUTPUT, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.NON_SCALAR_INPUTS}));
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.SINGLE_INPUT_SCALAR}));
        ExpressionPlannerTest.assertFallbackVectorizable(thePlan);
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)thePlan.getOutputType());
        ColumnCapabilities inferred = thePlan.inferColumnCapabilities(ExpressionType.toColumnType((ExpressionType)thePlan.getOutputType()));
        Assert.assertEquals((Object)ColumnType.STRING.getType(), (Object)inferred.getType());
        Assert.assertFalse((boolean)inferred.isDictionaryEncoded().isMaybeTrue());
        Assert.assertFalse((boolean)DeferExpressionDimensions.SINGLE_STRING.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
        Assert.assertFalse((boolean)DeferExpressionDimensions.FIXED_WIDTH.useDeferredGroupBySelector(thePlan, thePlan.getAnalysis().getRequiredBindingsList(), SYNTHETIC_INSPECTOR));
    }

    private static ExpressionPlan plan(String expression) {
        return ExpressionPlanner.plan((ColumnInspector)SYNTHETIC_INSPECTOR, (Expr)Parser.parse((String)expression, (ExprMacroTable)MACRO_TABLE));
    }

    private static void assertArrayInput(ExpressionPlan thePlan) {
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NON_SCALAR_INPUTS}));
        Assert.assertFalse((boolean)thePlan.any(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.NON_SCALAR_OUTPUT, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED}));
        ExpressionPlannerTest.assertFallbackVectorizable(thePlan);
    }

    private static void assertArrayInAndOut(ExpressionPlan thePlan) {
        Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.NON_SCALAR_OUTPUT}));
        Assert.assertFalse((boolean)thePlan.any(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED}));
        ExpressionPlannerTest.assertFallbackVectorizable(thePlan);
    }

    private static void assertFallbackVectorizable(ExpressionPlan thePlan) {
        if (ExpressionProcessing.allowVectorizeFallback()) {
            Assert.assertTrue((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.VECTORIZABLE}));
        } else {
            Assert.assertFalse((boolean)thePlan.is(new ExpressionPlan.Trait[]{ExpressionPlan.Trait.VECTORIZABLE}));
        }
    }

    private static class TestMacroTable
    extends ExprMacroTable {
        public TestMacroTable() {
            super((List)ImmutableList.builder().addAll((Iterable)TestExprMacroTable.INSTANCE.getMacros()).add((Object)new ExprMacroTable.ExprMacro(){

                public Expr apply(List<Expr> args) {
                    return new ExprMacroTable.BaseScalarMacroFunctionExpr(this, args){

                        public ExprEval eval(Expr.ObjectBinding bindings) {
                            throw DruidException.defensive((String)"just for planner test", (Object[])new Object[0]);
                        }

                        @Nullable
                        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                            return ExpressionType.STRING;
                        }
                    };
                }

                public String name() {
                    return "dict_complex_to_string";
                }
            }).build());
        }
    }
}

