/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import org.apache.druid.error.DruidException;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ObjectBasedColumnSelector;
import org.junit.Assert;
import org.junit.Test;

public class TestObjectBasedColumnSelector {
    @Test
    public void testNull() {
        MyObjectColumnSelector selector = new MyObjectColumnSelector(null);
        Assert.assertThrows(DruidException.class, () -> selector.getFloat());
        Assert.assertThrows(DruidException.class, () -> selector.getDouble());
        Assert.assertThrows(DruidException.class, () -> selector.getLong());
        Assert.assertTrue((boolean)selector.isNull());
    }

    @Test
    public void testLong() {
        MyObjectColumnSelector selector = new MyObjectColumnSelector(11L);
        Assert.assertFalse((boolean)selector.isNull());
        Assert.assertEquals((float)11.0f, (float)selector.getLong(), (float)0.0f);
    }

    @Test
    public void testInvalidIsNullUse() {
        MyObjectColumnSelector selector = new MyObjectColumnSelector(this.getClass());
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> selector.isNull());
        Assert.assertEquals((Object)e.getMessage(), (Object)"isNull() may only be called in case the underlying object is a Number but it was [java.lang.Class]");
    }

    static class MyObjectColumnSelector
    extends ObjectBasedColumnSelector<Object> {
        private Object obj;

        MyObjectColumnSelector(Object obj) {
            this.obj = obj;
        }

        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }

        public Object getObject() {
            return this.obj;
        }

        public Class<? extends Object> classOfObject() {
            if (this.obj == null) {
                return null;
            }
            return this.obj.getClass();
        }
    }
}

