/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class SegmentTimelineTest {
    @Test
    public void testIsOvershadowed() {
        SegmentTimeline timeline = SegmentTimeline.forSegments(Arrays.asList(this.createSegment("2022-01-01/2022-01-02", "v1", 0, 3), this.createSegment("2022-01-01/2022-01-02", "v1", 1, 3), this.createSegment("2022-01-01/2022-01-02", "v1", 2, 3), this.createSegment("2022-01-02/2022-01-03", "v2", 0, 2), this.createSegment("2022-01-02/2022-01-03", "v2", 1, 2)));
        Assert.assertFalse((boolean)timeline.isOvershadowed(this.createSegment("2022-01-01/2022-01-02", "v1", 1, 3)));
        Assert.assertFalse((boolean)timeline.isOvershadowed(this.createSegment("2022-01-01/2022-01-02", "v1", 2, 3)));
        Assert.assertFalse((boolean)timeline.isOvershadowed(this.createSegment("2022-01-01/2022-01-02", "v1", 1, 4)));
        Assert.assertFalse((boolean)timeline.isOvershadowed(this.createSegment("2022-01-01T00:00:00/2022-01-01T06:00:00", "v1", 1, 4)));
        Assert.assertTrue((boolean)timeline.isOvershadowed(this.createSegment("2022-01-02/2022-01-03", "v1", 2, 4)));
        Assert.assertTrue((boolean)timeline.isOvershadowed(this.createSegment("2022-01-02/2022-01-03", "v1", 0, 1)));
    }

    @Test
    public void testAddRemoveSegment() {
        DataSegment segment = this.createSegment("2022-01-01/P1D", "v1", 0, 1);
        SegmentTimeline timeline = SegmentTimeline.forSegments(Set.of());
        timeline.add(segment);
        Assert.assertEquals((long)1L, (long)timeline.getNumObjects());
        timeline.remove(segment);
        Assert.assertEquals((long)0L, (long)timeline.getNumObjects());
        Assert.assertTrue((boolean)timeline.isEmpty());
    }

    private DataSegment createSegment(String interval, String version, int partitionNum, int totalNumPartitions) {
        return new DataSegment("wiki", Intervals.of((String)interval), version, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)new NumberedShardSpec(partitionNum, totalNumPartitions), Integer.valueOf(9), 1L);
    }
}

