/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.timeline.partition.BuildingDimensionRangeShardSpec;
import org.apache.druid.timeline.partition.BuildingSingleDimensionShardSpec;
import org.apache.druid.timeline.partition.DimensionRangeBucketShardSpec;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;
import org.apache.druid.timeline.partition.ShardSpecTestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DimensionRangeBucketShardSpecTest {
    private static final List<String> DIMENSIONS = Arrays.asList("dim1", "dim2");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testConvert() {
        Assert.assertEquals((Object)new BuildingDimensionRangeShardSpec(1, DIMENSIONS, StringTuple.create((String[])new String[]{"start1", "start2"}), StringTuple.create((String[])new String[]{"end1", "end2"}), 5), (Object)new DimensionRangeBucketShardSpec(1, DIMENSIONS, StringTuple.create((String[])new String[]{"start1", "start2"}), StringTuple.create((String[])new String[]{"end1", "end2"})).convert(5));
    }

    @Test
    public void testConvert_withSingleDimension() {
        Assert.assertEquals((Object)new BuildingSingleDimensionShardSpec(1, "dim", "start", "end", 5), (Object)new DimensionRangeBucketShardSpec(1, Collections.singletonList("dim"), StringTuple.create((String[])new String[]{"start"}), StringTuple.create((String[])new String[]{"end"})).convert(5));
    }

    @Test
    public void testCreateChunk() {
        Assert.assertEquals((Object)new NumberedPartitionChunk(1, 0, (Object)"test"), (Object)new DimensionRangeBucketShardSpec(1, DIMENSIONS, StringTuple.create((String[])new String[]{"start1", "start2"}), StringTuple.create((String[])new String[]{"end1", "end2"})).createChunk((Object)"test"));
    }

    @Test
    public void testShardSpecLookup() {
        ImmutableList shardSpecs = ImmutableList.of((Object)new DimensionRangeBucketShardSpec(0, DIMENSIONS, null, StringTuple.create((String[])new String[]{"c", "12"})), (Object)new DimensionRangeBucketShardSpec(1, DIMENSIONS, StringTuple.create((String[])new String[]{"f", "13"}), StringTuple.create((String[])new String[]{"i", "9"})), (Object)new DimensionRangeBucketShardSpec(2, DIMENSIONS, StringTuple.create((String[])new String[]{"i", "9"}), null));
        ShardSpecLookup lookup = ((ShardSpec)shardSpecs.get(0)).getLookup((List)shardSpecs);
        long currentTime = DateTimes.nowUtc().getMillis();
        Assert.assertEquals(shardSpecs.get(0), (Object)lookup.getShardSpec(currentTime, (InputRow)new MapBasedInputRow(currentTime, DIMENSIONS, (Map)ImmutableMap.of((Object)DIMENSIONS.get(0), (Object)"a", (Object)DIMENSIONS.get(1), (Object)"12", (Object)"time", (Object)currentTime))));
        Assert.assertEquals(shardSpecs.get(1), (Object)lookup.getShardSpec(currentTime, (InputRow)new MapBasedInputRow(currentTime, DIMENSIONS, (Map)ImmutableMap.of((Object)DIMENSIONS.get(0), (Object)"g", (Object)DIMENSIONS.get(1), (Object)"8", (Object)"time", (Object)currentTime))));
        Assert.assertEquals(shardSpecs.get(2), (Object)lookup.getShardSpec(currentTime, (InputRow)new MapBasedInputRow(currentTime, DIMENSIONS, (Map)ImmutableMap.of((Object)DIMENSIONS.get(0), (Object)"k", (Object)DIMENSIONS.get(1), (Object)"14", (Object)"time", (Object)currentTime))));
    }

    @Test
    public void testSerde() throws JsonProcessingException {
        ObjectMapper mapper = ShardSpecTestUtils.initObjectMapper();
        mapper.registerSubtypes(new NamedType[]{new NamedType(DimensionRangeBucketShardSpec.class, "bucket_range")});
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ObjectMapper.class, (Object)mapper));
        DimensionRangeBucketShardSpec original = new DimensionRangeBucketShardSpec(1, DIMENSIONS, StringTuple.create((String[])new String[]{"start1", "start2"}), StringTuple.create((String[])new String[]{"end1", "end2"}));
        String json = mapper.writeValueAsString((Object)original);
        ShardSpec shardSpec = (ShardSpec)mapper.readValue(json, ShardSpec.class);
        Assert.assertEquals((Object)"bucket_range", (Object)shardSpec.getType());
        Assert.assertEquals((Object)original, (Object)shardSpec);
    }

    @Test
    public void testInvalidStartTupleSize() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Start tuple must either be null or of the same size as the number of partition dimensions");
        new DimensionRangeBucketShardSpec(1, DIMENSIONS, StringTuple.create((String[])new String[]{"a"}), null);
    }

    @Test
    public void testInvalidEndTupleSize() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("End tuple must either be null or of the same size as the number of partition dimensions");
        new DimensionRangeBucketShardSpec(1, DIMENSIONS, StringTuple.create((String[])new String[]{"a", "b"}), StringTuple.create((String[])new String[]{"e", "f", "g"}));
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(DimensionRangeBucketShardSpec.class).usingGetClass().verify();
    }
}

