/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.partition.IntegerPartitionChunk;
import org.apache.druid.timeline.partition.OvershadowableInteger;
import org.junit.Assert;
import org.junit.Test;

public class IntegerPartitionChunkTest {
    private static IntegerPartitionChunk<OvershadowableInteger> make(Integer start, Integer end, int chunkNumber, int obj) {
        return new IntegerPartitionChunk(start, end, chunkNumber, (Overshadowable)new OvershadowableInteger(obj));
    }

    @Test
    public void testAbuts() {
        IntegerPartitionChunk<OvershadowableInteger> lhs = IntegerPartitionChunkTest.make(null, 10, 0, 1);
        Assert.assertTrue((boolean)lhs.abuts(IntegerPartitionChunkTest.make(10, null, 1, 2)));
        Assert.assertFalse((boolean)lhs.abuts(IntegerPartitionChunkTest.make(11, null, 2, 3)));
        Assert.assertFalse((boolean)lhs.abuts(IntegerPartitionChunkTest.make(null, null, 3, 4)));
        Assert.assertFalse((boolean)IntegerPartitionChunkTest.make(null, null, 0, 1).abuts(IntegerPartitionChunkTest.make(null, null, 1, 2)));
    }

    @Test
    public void testIsStart() {
        Assert.assertTrue((boolean)IntegerPartitionChunkTest.make(null, 10, 0, 1).isStart());
        Assert.assertFalse((boolean)IntegerPartitionChunkTest.make(10, null, 0, 1).isStart());
        Assert.assertFalse((boolean)IntegerPartitionChunkTest.make(10, 11, 0, 1).isStart());
        Assert.assertTrue((boolean)IntegerPartitionChunkTest.make(null, null, 0, 1).isStart());
    }

    @Test
    public void testIsEnd() {
        Assert.assertFalse((boolean)IntegerPartitionChunkTest.make(null, 10, 0, 1).isEnd());
        Assert.assertTrue((boolean)IntegerPartitionChunkTest.make(10, null, 0, 1).isEnd());
        Assert.assertFalse((boolean)IntegerPartitionChunkTest.make(10, 11, 0, 1).isEnd());
        Assert.assertTrue((boolean)IntegerPartitionChunkTest.make(null, null, 0, 1).isEnd());
    }

    @Test
    public void testCompareTo() {
        Assert.assertEquals((long)0L, (long)IntegerPartitionChunkTest.make(null, null, 0, 1).compareTo(IntegerPartitionChunkTest.make(null, null, 0, 1)));
        Assert.assertEquals((long)0L, (long)IntegerPartitionChunkTest.make(10, null, 0, 1).compareTo(IntegerPartitionChunkTest.make(10, null, 0, 2)));
        Assert.assertEquals((long)0L, (long)IntegerPartitionChunkTest.make(null, 10, 0, 1).compareTo(IntegerPartitionChunkTest.make(null, 10, 0, 2)));
        Assert.assertEquals((long)0L, (long)IntegerPartitionChunkTest.make(10, 11, 0, 1).compareTo(IntegerPartitionChunkTest.make(10, 11, 0, 2)));
        Assert.assertEquals((long)-1L, (long)IntegerPartitionChunkTest.make(null, 10, 0, 1).compareTo(IntegerPartitionChunkTest.make(10, null, 1, 2)));
        Assert.assertEquals((long)-1L, (long)IntegerPartitionChunkTest.make(11, 20, 0, 1).compareTo(IntegerPartitionChunkTest.make(20, 33, 1, 1)));
        Assert.assertEquals((long)1L, (long)IntegerPartitionChunkTest.make(20, 33, 1, 1).compareTo(IntegerPartitionChunkTest.make(11, 20, 0, 1)));
        Assert.assertEquals((long)1L, (long)IntegerPartitionChunkTest.make(10, null, 1, 1).compareTo(IntegerPartitionChunkTest.make(null, 10, 0, 1)));
    }

    @Test
    public void testEquals() {
        Assert.assertEquals(IntegerPartitionChunkTest.make(null, null, 0, 1), IntegerPartitionChunkTest.make(null, null, 0, 1));
        Assert.assertEquals(IntegerPartitionChunkTest.make(null, 10, 0, 1), IntegerPartitionChunkTest.make(null, 10, 0, 1));
        Assert.assertEquals(IntegerPartitionChunkTest.make(10, null, 0, 1), IntegerPartitionChunkTest.make(10, null, 0, 1));
        Assert.assertEquals(IntegerPartitionChunkTest.make(10, 11, 0, 1), IntegerPartitionChunkTest.make(10, 11, 0, 1));
    }
}

