/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.utils;

import java.util.Properties;
import org.apache.druid.common.utils.PropUtils;
import org.apache.druid.java.util.common.ISE;
import org.junit.Assert;
import org.junit.Test;

public class PropUtilsTest {
    @Test(expected=ISE.class)
    public void testNotSpecifiedGetProperty() {
        Properties prop = new Properties();
        PropUtils.getProperty((Properties)prop, (String)"");
    }

    @Test
    public void testGetProperty() {
        Properties prop = new Properties();
        prop.setProperty("key", "value");
        Assert.assertEquals((Object)"value", (Object)PropUtils.getProperty((Properties)prop, (String)"key"));
    }

    @Test(expected=ISE.class)
    public void testNotSpecifiedGetPropertyAsInt() {
        Properties prop = new Properties();
        PropUtils.getPropertyAsInt((Properties)prop, (String)"", null);
    }

    @Test
    public void testDefaultValueGetPropertyAsInt() {
        Properties prop = new Properties();
        int defaultValue = 1;
        int result = PropUtils.getPropertyAsInt((Properties)prop, (String)"", (Integer)defaultValue);
        Assert.assertEquals((long)defaultValue, (long)result);
    }

    @Test
    public void testParseGetPropertyAsInt() {
        Properties prop = new Properties();
        int expectedValue = 1;
        prop.setProperty("key", Integer.toString(expectedValue));
        int result = PropUtils.getPropertyAsInt((Properties)prop, (String)"key");
        Assert.assertEquals((long)expectedValue, (long)result);
    }

    @Test(expected=ISE.class)
    public void testFormatExceptionGetPropertyAsInt() {
        Properties prop = new Properties();
        prop.setProperty("key", "1-value");
        PropUtils.getPropertyAsInt((Properties)prop, (String)"key", null);
    }
}

