/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.junit.Assert;
import org.junit.Test;

public class TimestampSpecTest {
    @Test
    public void testExtractTimestamp() {
        TimestampSpec spec = new TimestampSpec("TIMEstamp", "yyyy-MM-dd", null);
        Assert.assertEquals((Object)DateTimes.of((String)"2014-03-01"), (Object)spec.extractTimestamp((Map)ImmutableMap.of((Object)"TIMEstamp", (Object)"2014-03-01")));
    }

    @Test
    public void testExtractTimestampWithMissingTimestampColumn() {
        TimestampSpec spec = new TimestampSpec(null, null, DateTimes.EPOCH);
        Assert.assertEquals((Object)DateTimes.of((String)"1970-01-01"), (Object)spec.extractTimestamp((Map)ImmutableMap.of((Object)"dim", (Object)"foo")));
    }

    @Test
    public void testContextualTimestampList() {
        String dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
        String[] dates = new String[]{"2000-01-01T05:00:00", "2000-01-01T05:00:01", "2000-01-01T05:00:01", "2000-01-01T05:00:02", "2000-01-01T05:00:03"};
        TimestampSpec spec = new TimestampSpec("TIMEstamp", dateFormat, null);
        DateTimes.UtcFormatter formatter = DateTimes.wrapFormatter((DateTimeFormatter)ISODateTimeFormat.dateHourMinuteSecond());
        for (String date : dates) {
            DateTime dateTime = spec.extractTimestamp((Map)ImmutableMap.of((Object)"TIMEstamp", (Object)date));
            DateTime expectedDateTime = formatter.parse(date);
            Assert.assertEquals((Object)expectedDateTime, (Object)dateTime);
        }
    }
}

